/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.spectromost.InterSpecPanel;
import sws.spectromost.SpectroscopyPanel;
import sws.spectromost.UserInterface;

public class SaveGraphsPanel
extends JPanel {
    static JFrame frmSaveGraphs;
    static JButton btn_Save;
    private JLabel lblFileName;
    private JTextField txt_FileName;
    private JLabel lblNote;
    private static String tabPrefix;

    public SaveGraphsPanel(String string) {
        tabPrefix = string;
        UserInterface.fileNameToSave = "!Cancel!";
        this.initialize();
    }

    public void initialize() {
        frmSaveGraphs = new JFrame();
        frmSaveGraphs.setAlwaysOnTop(true);
        try {
            File file = new File(UserInterface.ICON_PATH);
            if (file.exists()) {
                BufferedImage bufferedImage = ImageIO.read(file);
                frmSaveGraphs.setIconImage(bufferedImage);
            } else {
                JOptionPane.showMessageDialog(frmSaveGraphs, "Icon doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(frmSaveGraphs, "Error loading Icon:" + iOException.getMessage(), "Loading icon", 0);
        }
        frmSaveGraphs.setBackground(new Color(176, 196, 222));
        frmSaveGraphs.getContentPane().setBackground(new Color(176, 196, 222));
        frmSaveGraphs.setVisible(true);
        frmSaveGraphs.setName("SpecFrame");
        frmSaveGraphs.setMinimumSize(new Dimension(450, 120));
        frmSaveGraphs.setMaximumSize(new Dimension(450, 120));
        frmSaveGraphs.setPreferredSize(new Dimension(450, 120));
        frmSaveGraphs.setLocation((int)(UserInterface.screenSize.getWidth() / 2.0 - 150.0), (int)(UserInterface.screenSize.getHeight() / 2.0 - 60.0));
        frmSaveGraphs.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SaveGraphsPanel.this.onCloseOperation();
            }
        });
        frmSaveGraphs.setTitle("Saving Graphs");
        frmSaveGraphs.setDefaultCloseOperation(0);
        frmSaveGraphs.setResizable(false);
        frmSaveGraphs.setFont(new Font("Dialog", 0, 12));
        frmSaveGraphs.setBackground(new Color(176, 196, 222));
        frmSaveGraphs.getContentPane().setLayout((LayoutManager)new MigLayout("", "[90.00:90.00][45.00:45.00,grow]", "[][][]"));
        this.lblFileName = new JLabel("File Name");
        frmSaveGraphs.getContentPane().add((Component)this.lblFileName, "cell 0 0,grow");
        this.txt_FileName = new JTextField();
        this.txt_FileName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    SaveGraphsPanel.this.saveAction();
                }
            }
        });
        frmSaveGraphs.getContentPane().add((Component)this.txt_FileName, "cell 1 0,growx");
        this.txt_FileName.setColumns(10);
        this.lblNote = new JLabel("Note: Measurements' original \r\nnames will be used as default.");
        frmSaveGraphs.getContentPane().add((Component)this.lblNote, "cell 0 1 2 1,grow");
        btn_Save = new JButton("");
        btn_Save.setFont(new Font("Dialog", 0, 12));
        btn_Save.setText("Save");
        btn_Save.setVerticalTextPosition(0);
        btn_Save.setHorizontalTextPosition(0);
        btn_Save.setToolTipText("Save Graphs");
        btn_Save.setMaximumSize(new Dimension(110, SaveGraphsPanel.btn_Save.getPreferredSize().height));
        btn_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveGraphsPanel.this.saveAction();
            }
        });
        frmSaveGraphs.getContentPane().add((Component)btn_Save, "cell 0 2 2 1,alignx center");
    }

    private void onCloseOperation() {
        UserInterface.stopEnablingButtons = false;
        UserInterface.checkDeviceStatusThreadStop = false;
        UserInterface.boardReadyRoutine(true);
        frmSaveGraphs.dispose();
        InterSpecPanel.btn_ClearGraphs_Inter_Spec.setEnabled(true);
        SpectroscopyPanel.btn_ClearGraphs_Spec.setEnabled(true);
        if (tabPrefix.equals("_InterSpec_") && !UserInterface.fileNameToSave.equals("!Cancel!")) {
            InterSpecPanel.saveGraphsRoutine();
        } else if (tabPrefix.equals("_Spec_") && !UserInterface.fileNameToSave.equals("!Cancel!")) {
            SpectroscopyPanel.saveGraphsRoutine();
        }
    }

    private void saveAction() {
        if (this.txt_FileName.getText().equals("")) {
            UserInterface.fileNameToSave = "!Default!";
        } else if (p3AppManagerUtils.isFilenameValid((String)this.txt_FileName.getText())) {
            UserInterface.fileNameToSave = this.txt_FileName.getText();
        } else {
            JOptionPane.showMessageDialog(null, "The name you entered isn't valid for file naming!", "Saving Graphs", 0);
            return;
        }
        this.onCloseOperation();
    }

    static {
        tabPrefix = null;
    }
}

