/*
 * Decompiled with CFR 0.152.
 */
package sws.p3AppManager_micro.utils;

public class p3Enumerations {

    public static enum p3AppManagerStatus {
        NO_ERROR(0),
        DEVICE_BUSY_ERROR(1),
        BOARD_DISTCONNECTED_ERROR(2),
        BOARD_NOT_INITIALIZED_ERROR(3),
        UNKNOWN_ERROR(4),
        CONFIG_FILES_LOADING_ERROR(7),
        CONFIG_PARAM_LENGTH_ERROR(8),
        INVALID_RUN_TIME_ERROR(11),
        INAVLID_REG_FILE_FORMAT_ERROR(23),
        NO_OF_SCANS_DSP_ERROR(24),
        DSP_INTERFEROGRAM_POST_PROCESSING_ERROR(25),
        DSP_INTERFEROGRAM_POST_EMPTY_DATA_ERROR(26),
        DSP_INTERFEROGRAM_POST_BAD_DATA_ERROR(27),
        UPDATE_CORR_FILE_ERROR(28),
        WHITE_LIGHT_PROCESSING_ERROR(29),
        DSP_INTERFEROGRAM_FFT_POST_PROCESSINF_ERROR(30),
        INVALID_RUN_PARAMETERS_ERROR(31),
        INVALID_RUN_TIME_NOT_EQUAL_BG_RUN_TIME_ERROR(32),
        NO_VALID_BG_DATA_ERROR(33),
        INTERFERO_FILE_CREATION_ERROR(34),
        PSD_FILE_CREATION_ERROR(35),
        SPECTRUM_FILE_CREATION_ERROR(36),
        GRAPHS_FOLDER_CREATION_ERROR(37),
        INVALID_APODIZATION_WINDOW(38),
        INITIATE_TAIFDRIVER_ERROR(42),
        INVALID_BOARD_CONFIGURATION_ERROR(43),
        DATA_STREAMING_TAIF_ERROR(50),
        DATA_STREAMING_ERROR(51),
        INVALID_NOTIFICATION_ERROR(52),
        INVALID_ACTION_ERROR(53),
        INVALID_DEVICE_ERROR(54),
        THREADING_ERROR(55),
        BOARD_ALREADY_INITIALIZED(56),
        INITIALIZATION_IN_PROGRESS(57),
        ACTUATION_SETTING_ERROR(60),
        DEVICE_IS_TURNED_OFF_ERROR(61),
        ASIC_REGISTER_WRITING_ERROR(62),
        WHITE_FILE_NOT_EXIST_ERROR(76),
        FAILED_IN_ADAPTIVE_GAIN(110),
        ASIC_REGISTER_READING_ERROR(111),
        TWO_POINTS_CORR_CALIB_FOLDER_ERROR(112),
        FAILED_TO_WRITE_OPTICAL_OPTION_TO_FILE(113),
        FAILED_TO_CREATE_OPTICAL_SETTINGS_FILE(114),
        STANDARD_CALIBRATOR_FILE_NOT_EXIST_ERROR(115),
        WAVELENGTH_CALIBRATION_ERROR(116),
        NO_VALID_OLD_MEASUREMENT_ERROR(117),
        DSP_UPDATE_FFT_SETTINGS_ERROR(118),
        GAIN_OPTIONS_ERROR(119),
        USBCommunicationTimeOutError(199),
        CommunicationWriteError(201),
        CommunicationReadError(202),
        FLASHING_CONFIGURATION_ERROR(203),
        ROM_INVALID_ID(213),
        DEVICE_NOT_INITIALIZED_ERROR(214),
        SAMPLE_FOLDERS_INVALID_ERROR(218),
        OPTICAL_FILE_ERROR(228),
        NOT_ENOUGH_MEMORY_ERROR(229),
        I2_STAT_INT1_END_TIMEOUT(230),
        I2_STAT_INT1_END_INVALID(231),
        I2_STAT_INT1_AVG_OVERFLOW(232),
        I2_STAT_INT1_CORE_INVALID_REGION(233),
        I2_STAT_INT1_CORE_TIMEOUT(234),
        I2_STAT_INT1_CORE_OVERFLOW(235),
        I2_STAT_INT1_START_TIMEOUT(236),
        I2_STAT_INT2_END_TIMEOUT(237),
        I2_STAT_INT2_END_INVALID(238),
        I2_STAT_INT2_AVG_OVERFLOW(239),
        I2_STAT_INT2_CORE_INVALID_REGION(240),
        I2_STAT_INT2_CORE_TIMEOUT(241),
        I2_STAT_INT2_CORE_OVERFLOW(242),
        I2_STAT_INT2_START_TIMEOUT(243),
        INVALID_SAMPLE_FOLDER_VERSION(244),
        TAIF_STREAMING_ERROR_INT1(245),
        STREAMING_TIMEOUT_ERROR(246),
        TAIF_STREAMING_ERROR_INT2(247),
        P3_FFT_ADDRESS_ERROR(248),
        FFT_WRONG_NUMBER_POINTS(300),
        CRC_NOT_MATCHED(249),
        PATTERN_NOT_MATCHED(250),
        FLASH_FAILED(251),
        IN_ADDRESS_ERROR(252),
        RX_OR_ERROR(253),
        WRITE_ENABLE_FAILED(254),
        WRITE_DISABLE_FAILED(255),
        FLASH_BUSY_ERROR(256),
        P3_SPI_TAIF_ADDRESS_ERROR(259),
        P3_SPI_TAIF_RX_OR_ERROR(204),
        P3_SPI_TAIF_IN_ADDR_ERROR(205),
        P3_FIR_ADDRESS_ERROR(260),
        P3_FIR_INVALID_ADD_DATA_ERROR(261),
        P3_FIR_INVALID_SAMPLES_NUMBER_ERROR(262),
        P3_FIR_INVALID_ADD_COEFF_ERROR(263),
        P3_FIR_ACC1_SAT_ERROR(264),
        P3_FIR_ACC2_SAT_ERROR(265),
        P3_FIR_ACC3_SAT_ERROR(266),
        P3_FIR_ACC4_SAT_ERROR(267),
        P3_LIN_INTRP_XNEW_ACC_SAT_ERROR(268),
        P3_LIN_INTRP_XNEW_THRES_SAT_ERROR(269),
        P3_LIN_INTRP_XNEW_LD_MEM_NON_MON_ERROR(270),
        P3_LIN_INTRP_XNEW_OUT_STRTXOLD_RNG_ERROR(271),
        P3_LIN_INTRP_XNEW_OUT_FNLXOLD_RANGE_ERROR(272),
        P3_LIN_INTRP_XOLD_NON_MONO_ERROR(273),
        P3_LIN_INTRP_ZERO_DIV_ZERO_ERROR(274),
        P3_LIN_INTRP_SCALR_DIV_ZERO_ERROR(275),
        P3_LIN_INTRP_WR_XNEW_ERR_ERROR(276),
        P3_LIN_INTRP_DMA_ADDR_WRD_ALGN_ERROR(277),
        P3_LIN_INTRP_DMA_ADDR_LSB_IN_RNG_ERROR(278),
        P3_LIN_INTRP_DMA_ADDR_MSB_IN_RNG_ERROR(279),
        ACTION_ABORTED(280),
        USERINTERFACE_DMA_WRITE_ERROR(281),
        USERINTERFACE_WRONG_OPERATION(282),
        WDT_WRITE_LOCK_FAILED(283),
        WDT_WRITE_UNLOCK_FAILED(284),
        DSP_INITIALIZATION_CONFIGURATION_FILES_IS_EMPTY_ERROR(285),
        DSP_INITIALIZATION_CONFIGURATION_FILES_LENGTH_NOT_VALID_ERROR(286),
        DSP_INITIALIZATION_INVALID_INTERFEROGRAM_TYPE_ERROR(287),
        DSP_INTERPOLATION_LINEAR_INPUT_SIZE_ZERO_ERROR(288),
        DSP_INTERPOLATION_LINEAR_OUTPUT_SIZE_ZERO_ERROR(289),
        DSP_INTERPOLATION_LINEAR_DIVISION_BY_ZERO_ERROR(290),
        DSP_MATH_DIVISION_BY_ZERO_ERROR(291),
        DSP_Spline_NO_POINTS_ERROR(292),
        DSP_SPLINE_KNOTS_DECREASING_ERROR(293),
        DSP_SPLINE_UNKNOWN_ERROR(294),
        DSP_FFT_NO_POINTS_ERROR(295),
        DSP_NOISE_LEVEL_ERROR(296);

        private final int numVal;

        private p3AppManagerStatus(int n2) {
            this.numVal = n2;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static p3AppManagerStatus getAppManagerStatusByCode(int n) {
            for (p3AppManagerStatus p3AppManagerStatus2 : p3AppManagerStatus.values()) {
                if (p3AppManagerStatus2.getNumVal() != n) continue;
                return p3AppManagerStatus2;
            }
            return UNKNOWN_ERROR;
        }
    }

    public static enum p3DeviceAction {
        initializeCore(0),
        RunInterSpec(1),
        RunSpecBackground(2),
        RunSpecSample(3),
        SetActuation(4),
        CheckBoardStatus(5),
        RunCapCurrent(6),
        RunCapTimeCalibration(7),
        RunDelayCompensation(8),
        RunCalibration(9),
        GenerateCalibration(10),
        BurnSampleID(11),
        BurnSampleFolders(12),
        ReadTemp(13),
        ReadASICRegisters(14),
        WriteASICRegisters(15),
        ReadSampleFolders(16),
        CalculateResponse(17),
        CalculateParameters(18),
        TrimCoefficients(19),
        TrimPhase(20),
        CheckStability(21),
        RunWaveform(22),
        RunGainAdjustInterSpec(23),
        RunSNR(24),
        RunSelfCorr(25),
        RunWavelengthCalibration(26),
        RunStability(27),
        RunGainAdjustSpecBG(28),
        RunGainAdjustSpecSample(29),
        RunWavelengthCalibrationBG(30),
        RunUpdateFFT_SettingsInterSpec(31),
        RunUpdateFFT_SettingsSpec(32),
        RestoreDefaultSettings(33),
        BurnWorkingSettings(34),
        TrimPhaseFast(35);

        private final int numVal;

        private p3DeviceAction(int n2) {
            this.numVal = n2;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }

    public static enum p3AppManagerState {
        Idle(0),
        Initialize(1, p3DeviceAction.initializeCore),
        InterferogramRun(2, p3DeviceAction.RunInterSpec),
        SpectroscopySampleRun(3, p3DeviceAction.RunSpecSample),
        SpectroscopyBackgroundRun(4, p3DeviceAction.RunSpecBackground),
        ActuationProfileSetting(5, p3DeviceAction.SetActuation),
        CheckingDeviceStatus(6, p3DeviceAction.CheckBoardStatus),
        CapCurrentRun(7, p3DeviceAction.RunCapCurrent),
        CalibrationCapVsTimeRun(8, p3DeviceAction.RunCapTimeCalibration),
        CalibrationDelayCompensationRun(9, p3DeviceAction.RunDelayCompensation),
        CalibrationCoreRun(10, p3DeviceAction.RunCalibration),
        CalibrationGeneration(11, p3DeviceAction.GenerateCalibration),
        SampleIDBurn(12, p3DeviceAction.BurnSampleID),
        SampleFoldersBurn(13, p3DeviceAction.BurnSampleFolders),
        TempReading(14, p3DeviceAction.ReadTemp),
        ASICRegistersReading(15, p3DeviceAction.ReadASICRegisters),
        ASICRegistersWriting(16, p3DeviceAction.WriteASICRegisters),
        SampleFoldersReading(17, p3DeviceAction.ReadSampleFolders),
        ResponseCalculation(18, p3DeviceAction.CalculateResponse),
        ParametersCalculation(19, p3DeviceAction.CalculateParameters),
        CoefficientsTrimming(20, p3DeviceAction.TrimCoefficients),
        PhaseTrimming(21, p3DeviceAction.TrimPhase),
        StabilityCheck(22, p3DeviceAction.CheckStability),
        WaveformPreview(23, p3DeviceAction.RunWaveform),
        gainAdjustInterSpecRun(24, p3DeviceAction.RunGainAdjustInterSpec),
        SNR_Run(25, p3DeviceAction.RunSNR),
        selfCorr_Run(26, p3DeviceAction.RunSelfCorr),
        wavelengthCalibration_Run(27, p3DeviceAction.RunWavelengthCalibration),
        StabilityRun(28, p3DeviceAction.RunStability),
        gainAdjustSpecBG_Run(29, p3DeviceAction.RunGainAdjustSpecBG),
        gainAdjustSpecSampleRun(30, p3DeviceAction.RunGainAdjustSpecSample),
        wavelengthCalibrationBG_Run(31, p3DeviceAction.RunWavelengthCalibrationBG),
        updateFFT_SettingsInterSpecRun(32, p3DeviceAction.RunUpdateFFT_SettingsInterSpec),
        updateFFT_SettingsSpecRun(33, p3DeviceAction.RunUpdateFFT_SettingsSpec),
        RestoreDefault(34, p3DeviceAction.RestoreDefaultSettings),
        BurnSettings(35, p3DeviceAction.BurnWorkingSettings),
        FastPhaseTrimming(36, p3DeviceAction.TrimPhaseFast);

        private final int numVal;
        private final p3DeviceAction deviceAction;

        private p3AppManagerState(int n2) {
            this.numVal = n2;
            this.deviceAction = null;
        }

        private p3AppManagerState(int n2, p3DeviceAction p3DeviceAction2) {
            this.numVal = n2;
            this.deviceAction = p3DeviceAction2;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public p3DeviceAction getDeviceAtion() {
            return this.deviceAction;
        }
    }

    public static enum p3CorrectionType {
        Corrected(0),
        Uncorrected(1);

        private final int numVal;

        private p3CorrectionType(int n2) {
            this.numVal = n2;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }

    public static enum RestoreOptionsEnum {
        OPTICAL_GAIN_SETTINGS(0, "Optical gain settings"),
        CORRECTION_SETTINGS(1, "Correction settings"),
        ALL(3, "All");

        private final int numVal;
        private final String stringVal;

        private RestoreOptionsEnum(int n2, String string2) {
            this.numVal = n2;
            this.stringVal = string2;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public String getStringVal() {
            return this.stringVal;
        }
    }
}

