/*
 * Decompiled with CFR 0.152.
 */
package sws.p3AppManager_micro.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sws.p3AppManager_micro.utils.p3NumberConverter;

public class p3AppManagerUtils {
    private static Logger logger = Logger.getLogger(p3AppManagerUtils.class);

    private p3AppManagerUtils() {
    }

    public static boolean isFilenameValid(String string) {
        for (char c : string.toCharArray()) {
            switch (c) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '`': 
                case '|': {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean createDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean removeDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                File file2 = new File(file.getPath(), string2);
                file2.delete();
            }
            return file.delete();
        }
        return true;
    }

    public static boolean removeDir(String string, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                File file2 = new File(file.getPath(), string2);
                if (file2.isDirectory() && bl) {
                    p3AppManagerUtils.removeDir(file2.getPath(), true);
                }
                file2.delete();
            }
            return file.delete();
        }
        return true;
    }

    public static boolean exist(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static String[] getFolderSubFoldersNames(String string, ArrayList<String> arrayList, boolean bl) {
        File[] fileArray;
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory() || file2.isHidden()) continue;
            arrayList.add(file2.getName());
            if (!bl) continue;
            p3AppManagerUtils.getFolderSubFoldersNames(file2.getAbsolutePath(), arrayList, true);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getFolderSubFilesNames(String string, ArrayList<String> arrayList) {
        File[] fileArray;
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory() || file2.isHidden()) continue;
            arrayList.add(file2.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isEmptyString(String string) {
        return string == null || "".equals(string);
    }

    public static String formatString(String string, Object ... objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] loadParamFile(String string) {
        Object object;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                String[] stringArray = ((String)object).split(":");
                if (stringArray.length != 2) continue;
                arrayList.add(Double.parseDouble(stringArray[1]));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        object = new double[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Double)arrayList.get(i);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] loadRawDataFile(String string) {
        Object object;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add(Double.parseDouble((String)object));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        object = new double[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Double)arrayList.get(i);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] loadIntDataFile(String string) {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add(Integer.parseInt((String)object));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            int[] nArray = null;
            return nArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] loadLongDataFile(String string) {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add(Long.parseLong((String)object));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            long[] lArray = null;
            return lArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        object = new long[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Long)arrayList.get(i);
        }
        return object;
    }

    public static double[] concatenateMultipleArraysIntoOne(double[] ... dArray) {
        try {
            int n = 0;
            for (double[] dArray2 : dArray) {
                n += dArray2.length + 1;
            }
            double[] dArray3 = new double[n];
            int n2 = 0;
            for (double[] dArray4 : dArray) {
                dArray3[n2] = dArray4.length;
                System.arraycopy(dArray4, 0, dArray3, n2 + 1, (int)dArray3[n2]);
                n2 += dArray4.length + 1;
            }
            return dArray3;
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            return null;
        }
    }

    public static List<String> decodeBytesToValues(int n, byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 0: {
                for (int i = 0; i < byArray.length; i += 8) {
                    arrayList.add(new Double(p3NumberConverter.toDouble(byArray, i)).toString());
                }
                return arrayList;
            }
            case 1: {
                for (int i = 0; i < byArray.length; i += 4) {
                    arrayList.add(new Integer(p3NumberConverter.ToInt(byArray, i)).toString());
                }
                return arrayList;
            }
            case 2: {
                arrayList.add(new String(byArray, StandardCharsets.US_ASCII));
                return arrayList;
            }
            case 3: {
                for (int i = 0; i < byArray.length; i += 4) {
                    arrayList.add(new Float(p3NumberConverter.ToSingle(byArray, i)).toString());
                }
                return arrayList;
            }
        }
        logger.error((Object)"invalid data type ");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringfile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileOfArray(int[] nArray, String string, String string2) {
        Writer writer = null;
        boolean bl = string2 != null;
        try {
            writer = new BufferedWriter(new FileWriter(string));
            for (int n : nArray) {
                writer.write(Integer.toString(n));
                if (!bl) continue;
                writer.write(string2);
            }
            writer.close();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileOfArray(double[] dArray, String string, String string2) {
        Writer writer = null;
        boolean bl = string2 != null;
        try {
            writer = new BufferedWriter(new FileWriter(string));
            for (double d : dArray) {
                writer.write(Double.toString(d));
                if (!bl) continue;
                writer.write(string2);
            }
            writer.close();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileOfArray(String[] stringArray, String string, String string2) {
        Writer writer = null;
        boolean bl = string2 != null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "utf-8"));
            for (String string3 : stringArray) {
                writer.write(string3);
                if (!bl) continue;
                writer.write(string2);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
    }
}

