/*
 * Decompiled with CFR 0.152.
 */
package sws.p3AppManager_micro;

import java.util.Observable;
import org.apache.log4j.Logger;
import sws.p3AppManager_micro.devices.p3Device;
import sws.p3AppManager_micro.devices.p3Sample;
import sws.p3AppManager_micro.p3AppManager_micro;
import sws.p3AppManager_micro.utils.p3AppManagerNotification;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.p3AppManager_micro.utils.p3Constants;
import sws.p3AppManager_micro.utils.p3DeviceNotificationResult;
import sws.p3AppManager_micro.utils.p3Enumerations;

public class p3AppManagerImpl
extends p3AppManager_micro {
    private p3Device device;
    private static Logger logger = Logger.getLogger(p3AppManagerImpl.class);
    private String workingDirectory;

    public p3AppManagerImpl() {
        p3Constants.APPLICATION_WORKING_DIRECTORY = this.workingDirectory = System.getProperty("user.dir");
    }

    public p3AppManagerImpl(String string) {
        this.workingDirectory = string;
        p3Constants.APPLICATION_WORKING_DIRECTORY = string;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus initializeCore(String ... stringArray) {
        logger.info((Object)"start initializeCore method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = p3Enumerations.p3AppManagerStatus.NO_ERROR;
        return p3AppManagerStatus2;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus checkDeviceStatus(String ... stringArray) {
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.checkDeviceStatus(stringArray);
    }

    @Override
    public void setExternalApodizationWindow(long[] lArray) {
        logger.info((Object)"start setExternalApodizationWindow method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        this.device.setExternalApodizationWindow(lArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runSpec(String ... stringArray) {
        logger.info((Object)"start runSpec method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.runSpec(stringArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus wavelengthCalibrationBG(String ... stringArray) {
        logger.info((Object)"start wavelengthCalibrationBG method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.wavelengthCalibrationBG(stringArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus wavelengthCalibration(String ... stringArray) {
        logger.info((Object)"start wavelengthCalibration method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.wavelengthCalibration(stringArray);
    }

    @Override
    public double getErrorData() {
        logger.info((Object)"start getErrorData method ");
        if (this.device == null) {
            return 1.0;
        }
        return this.device.getErrorData();
    }

    @Override
    public double[][] getSpecData() {
        logger.info((Object)"start getSpecData method ");
        if (this.device == null) {
            return null;
        }
        return this.device.getSpecData();
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runInterSpec(String ... stringArray) {
        logger.info((Object)"start runInterSpec method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.runInterSpec(stringArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runCalibCorr(String ... stringArray) {
        logger.info((Object)"start runCalibCorr method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.runCalibCorr(stringArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runSpecGainAdjBG(String ... stringArray) {
        logger.info((Object)"start runSpecGainAdjBG method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.runSpecGainAdjBG(stringArray);
    }

    @Override
    public double[][] getInterSpecData() {
        logger.info((Object)"start getInterSpecData method ");
        if (this.device == null) {
            return null;
        }
        return this.device.getInterSpecData();
    }

    @Override
    public double[][] getGainAdjustSpecData() {
        logger.info((Object)"start getGainAdjustSpecData method ");
        if (this.device == null) {
            return null;
        }
        return this.device.getGainAdjustSpecData();
    }

    @Override
    public String getDeviceId() {
        return this.device.getDeviceId();
    }

    @Override
    public void update(Observable observable, Object object) {
        String string;
        p3DeviceNotificationResult p3DeviceNotificationResult2;
        p3Enumerations.p3DeviceAction p3DeviceAction2;
        logger.info((Object)"start update method ");
        if (object == null || !(object instanceof p3DeviceNotificationResult)) {
            this.setChanged();
            this.notifyObservers(new p3AppManagerNotification(-1, p3Enumerations.p3AppManagerStatus.INVALID_NOTIFICATION_ERROR.getNumVal(), null));
        }
        if ((p3DeviceAction2 = (p3DeviceNotificationResult2 = (p3DeviceNotificationResult)object).getAction()) == null) {
            this.setChanged();
            this.notifyObservers(new p3AppManagerNotification(-1, p3Enumerations.p3AppManagerStatus.INVALID_ACTION_ERROR.getNumVal(), null));
        }
        if (p3AppManagerUtils.isEmptyString(string = p3DeviceNotificationResult2.getDeviceId())) {
            this.setChanged();
            this.notifyObservers(new p3AppManagerNotification(-1, p3Enumerations.p3AppManagerStatus.INVALID_DEVICE_ERROR.getNumVal(), null));
        }
        switch (p3DeviceAction2) {
            case initializeCore: {
                logger.info((Object)"initialize core....");
                this.initializeCoreFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunInterSpec: {
                logger.info((Object)"run inter spec....");
                this.RunInterSpecFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunGainAdjustSpecBG: {
                logger.info((Object)"run Gain Adjustment Spec BG....");
                this.RunGainAdjustSpecBG_Finished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunSpecBackground: {
                logger.info((Object)"run background ....");
                this.RunSpecBackgroundeFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunSpecSample: {
                logger.info((Object)"run spectrocopy ....");
                this.RunSpecSampleFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunWavelengthCalibrationBG: {
                logger.info((Object)"run BG wavelength calibration ....");
                this.RunWavelengthCalibrationBG_Finished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunWavelengthCalibration: {
                logger.info((Object)"run wavelength calibration ....");
                this.RunWavelengthCalibrationFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RestoreDefaultSettings: {
                logger.info((Object)"Restore Default Settings");
                this.RestoreDefaultSettingsFinished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case RunSelfCorr: {
                logger.info((Object)"run Interferogram Corr ....");
                this.RunInterferogramCorr_Finished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            case BurnWorkingSettings: {
                logger.info((Object)"run BurnWorkingSettings ....");
                this.BurnWorkingSettings_Finished(string, p3DeviceNotificationResult2.getStatus());
                break;
            }
            default: {
                this.setChanged();
                this.notifyObservers(new p3AppManagerNotification(-1, p3Enumerations.p3AppManagerStatus.INVALID_ACTION_ERROR.getNumVal(), null));
            }
        }
    }

    private p3Device getConnectedSample() {
        p3Sample p3Sample2 = new p3Sample();
        p3Sample2.addObserver(this);
        return p3Sample2;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus restoreDefaultSettings(String ... stringArray) {
        logger.info((Object)"start restoreDefaultSettings method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.restoreDefaultSettings(stringArray);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus burnSpecificSettings(String ... stringArray) {
        logger.info((Object)"start restoreDefaultSettings method ");
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.burnSettingsSpecificSettings(stringArray);
    }

    @Override
    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
        p3Constants.APPLICATION_WORKING_DIRECTORY = string;
    }

    @Override
    public String getWorkingDirectory(String string) {
        return this.workingDirectory;
    }

    @Override
    public String[] getSoftwareVersion() {
        if (this.device == null) {
            this.device = this.getConnectedSample();
        }
        return this.device.getSoftwareVersion();
    }

    private void initializeCoreFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)"lynxinitializeCoreFinished");
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.initializeCore.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunInterSpecFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunInterSpecFinished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunInterSpec.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunGainAdjustSpecBG_Finished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunGainAdjustSpecBG_Finished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunGainAdjustSpecBG.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunSpecBackgroundeFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunSpecBackgroundeFinished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunSpecBackground.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunSpecSampleFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunSpecSampleFinished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunSpecSample.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunWavelengthCalibrationBG_Finished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunWavelengthCalibrationBG_Finished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunWavelengthCalibrationBG.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunWavelengthCalibrationFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunWavelengthCalibrationFinished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunWavelengthCalibration.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RestoreDefaultSettingsFinished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RestoreDefaultSettingsFinished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RestoreDefaultSettings.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void RunInterferogramCorr_Finished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunInterferogramCorr_Finished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.RunSelfCorr.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }

    private void BurnWorkingSettings_Finished(String string, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        logger.info((Object)("RunInterferogramCorr_Finished with status : " + (Object)((Object)p3AppManagerStatus2)));
        this.setChanged();
        this.notifyObservers(new p3AppManagerNotification(p3Enumerations.p3DeviceAction.BurnWorkingSettings.getNumVal(), p3AppManagerStatus2.getNumVal(), string));
    }
}

