//
//  UserUtils.swift
//  NeoSpectraSwift
//
//  Created by doda on 11/10/16.
//  Copyright © 2016 siware. All rights reserved.
//

import Foundation
import UIKit

class UserUtils: NSObject
    
{
    
    static func setMode(automaticMode :Bool){
        let defaults = UserDefaults.standard
        defaults.set(automaticMode, forKey: "source_mode")
        defaults.synchronize()
    }
    
    static func getMode() -> Bool! {
        return UserDefaults.standard.bool(forKey: "source_mode")
    }
    
    static func setT1(time :Int){
        let defaults = UserDefaults.standard
        defaults.set(time, forKey: "time_t1")
        defaults.synchronize()
    }
    
    static func getT1() -> Int! {
        return UserDefaults.standard.integer(forKey: "time_t1")
    }
    
    
    static func setT2(time :Int){
        let defaults = UserDefaults.standard
        defaults.set(time, forKey: "time_t2")
        defaults.synchronize()
    }
    
    static func getT2() -> Int! {
        return UserDefaults.standard.integer(forKey: "time_t2")
    }
    
    static func setUserDeviceName(device_name :String){
        let defaults = UserDefaults.standard
        defaults.set(device_name, forKey: "user_device_name")
        
        defaults.synchronize()
    }
    
    static func getUserDeviceName() -> String! {
        
        if UserDefaults.standard.object(forKey: "user_device_name") != nil
        {
            return UserDefaults.standard.object(forKey: "user_device_name") as! String!
            
        }else{
            return ""
        }
    }
}
