//
//  SpectrumViewController.swift
//  NeoSpectraSwift
//
//  Created by doda on 10/26/16.
//  Copyright © 2016 siware. All rights reserved.
//

import UIKit
import CoreBluetooth

class SpectrumViewController: UIViewController , NSBluetoothManagerDelegate  {
    
    //MARK: - View Properties
    var doubledata: [[Double]] = [[Double]]()
    var floatdata: [Float] = [Float]()
    var buttonAnimating = false
    var BgButtonAnimating = false
    var sender = AppDelegate.MainViews.SPECTRUM
    var skipBoardError = 0
    var Iteration = 1
    var Bg_Input_ST = 2.0
    var Bg_Input_Values = [1,0,1,2]
    var Bg_taken = false
    var requestedMode = 0
    
    //MARK: - View OUtlets
    @IBOutlet weak var scanTimeConstraint: NSLayoutConstraint!
    @IBOutlet weak var scanViewConstraint: NSLayoutConstraint!
    @IBOutlet weak var scanViewConstraintX: NSLayoutConstraint!
    @IBOutlet weak var bgViewConstraintX: NSLayoutConstraint!
    @IBOutlet weak var bgViewConstraintY: NSLayoutConstraint!
    @IBOutlet weak var scanTimeTF: UITextField!
    @IBOutlet weak var showRawDataButton: UIButton!
    @IBOutlet weak var loadSpectrumButton: UIButton!
    @IBOutlet weak var scanButton: UIButton!
    @IBOutlet weak var bgButton: UIButton!
    @IBOutlet weak var stopButton: UIButton!
    
    @IBAction func loadSpectrumButtonTapped(_ sender: Any) {
        let fileBrowser = FileBrowser(save_load: "load")
        fileBrowser.excludesFileExtensions = ["InterPSD"]
        fileBrowser.setSpectrumView(SpectrumView: self)
        present(fileBrowser, animated: true, completion: nil)
    }
    
    func loadDataLogic(dataPaths: [URL]){
        for i in 0..<dataPaths.count{
            var textofFile = ""
            do {
                textofFile = try String(contentsOf: dataPaths[i], encoding: .utf8)
            }
            catch {/* error handling here */}
            var textLines = textofFile.split(separator: "\n")
            let xAxisUnit = textLines[0].split(separator: "\t")[0]
            let yAxisUnit = textLines[0].split(separator: "\t")[1]
            textLines.removeFirst()
            var data = [Double]()
            var x = [Double] ()
            var y = [Double] ()
            for j in 0..<textLines.count{
                if(xAxisUnit == "x_Axis:Wavenumber (cm-1)" && yAxisUnit == "y_Axis:Absorbance"){
                    y.append((100 * pow(10.0, (-(Double(textLines[j].split(separator: "\t")[1])!)))))
                    x.append(Double(textLines[j].split(separator: "\t")[0])!)
                }else if(xAxisUnit == "x_Axis:Wavelength (nm)" && yAxisUnit == "y_Axis:Absorbance"){
                    y.insert(((100 * pow(10.0, (-(Double(textLines[j].split(separator: "\t")[1])!))))), at: 0)
                    x.insert(10000000/(Double(textLines[j].split(separator: "\t")[0])!), at: 0)
                }else if(xAxisUnit == "x_Axis:Wavelength (nm)"){
                    y.insert(Double(textLines[j].split(separator: "\t")[1])!, at: 0)
                    x.insert(10000000/(Double(textLines[j].split(separator: "\t")[0])!), at: 0)
                }else{
                    y.append(Double(textLines[j].split(separator: "\t")[1])!)
                    x.append(Double(textLines[j].split(separator: "\t")[0])!)
                }
            }
            data = y + x
            Constants.Spectrumdoubledata.append(data)
        }
    }
    
    @IBAction func stopButtonTapped(_ sender: Any) {
        self.requestedMode = 0
    }
    @IBAction func buttonTapped(_ sender: AnyObject){
        if(Constants.kitInUseSpectrum == false){
            self.dismissKeyboard()
            if(isValidData()){
                if(isSameSettingsAsBg()){
                    if(UserDefaults.standard.integer(forKey: "Run_mode") == 0){
                        self.requestedMode = 0
                    }else{
                        self.requestedMode = 1
                    }
                    self.runSpectrum()
                }
            }
        }
    }
    
    func runSpectrum(){
        if(AppDelegate.bluetoothManager != nil && Constants.BlueToothConnected == true){
            if(self.Iteration == 1){
                if(self.buttonAnimating == false){
                    self.startScanButtonAnimation()
                }
                let data = Data(bytes: self.setOpticalGainBytes())
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }else{
                let data = Data(bytes: self.getRunORBGBytes(command: 0x05))
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }
        }
    }
    
    @IBAction func BgbuttonTapped(_ sender: AnyObject) {
        if(Constants.kitInUseSpectrum == false){
            self.dismissKeyboard()
            if(isValidData()){
                self.Bg_Input_ST = Double(scanTimeTF.text!)!
                //Keep Common WL value
                if(UserDefaults.standard.bool(forKey: "Interpolation_enabled")){
                    if(UserDefaults.standard.integer(forKey: "Number_data_points") == 0){
                        self.Bg_Input_Values[0] = 5
                    }else{
                        self.Bg_Input_Values[0] = Int(UserDefaults.standard.integer(forKey: "Number_data_points"))
                    }
                }else{
                    self.Bg_Input_Values[0] = 0
                }
                //Keep Optical Settings Value
                let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
                if(selectedOption != nil){
                    if(selectedOption == "Default"){
                        self.Bg_Input_Values[1] = 0
                    }else{
                        self.Bg_Input_Values[1] = 2
                    }
                }else{
                    self.Bg_Input_Values[1] = 0
                }
                //Keep Apodization Window Value
                self.Bg_Input_Values[2] = Int(UserDefaults.standard.integer(forKey: "Apodization_function"))
                //Keep zero Padding Value
                if(UserDefaults.standard.integer(forKey: "Zero_padding") == 0){
                    self.Bg_Input_Values[3] = 1
                }else{
                    self.Bg_Input_Values[3] = Int(UserDefaults.standard.integer(forKey: "Zero_padding"))
                }
                self.runBG()
            }
        }
    }
    
    func runBG(){
        if(AppDelegate.bluetoothManager != nil && Constants.BlueToothConnected == true){
            if(self.Iteration == 1){
                if(self.BgButtonAnimating == false){
                    self.startBgButtonAnimation()
                }
                let data = Data(bytes: self.setOpticalGainBytes())
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }else{
                let data = Data(bytes: self.getRunORBGBytes(command: 0x04))
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }
        }
    }
    
    func setOpticalGainBytes() -> [UInt8]
    {
        //append Command
        var bytes = [UInt8]()
        bytes.append(UInt8(27))
        
        //append Optical Settings Value
        let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
        if(selectedOption != nil){
            if(UserDefaults.standard.object(forKey: "Optical_gain_settings_options") != nil){
                let kitID = Constants.SelectedDeviceName.components(separatedBy: "_")[1]
                let currentOptions = UserDefaults.standard.object(forKey: "Optical_gain_settings_options") as! [String : String]
                var selectedValue = ""
                if(selectedOption == "Default"){
                    selectedValue = currentOptions[selectedOption!]!
                }else{
                    selectedValue = currentOptions[selectedOption! + "_" + kitID]!
                }
                let value = UInt16(selectedValue)
                let Valuebytes = self.toByteArray(value)
                bytes.append(Valuebytes[0])
                bytes.append(Valuebytes[1])
            }else{
                bytes.append(UInt8(0))
                bytes.append(UInt8(0))
            }
        }else{
            bytes.append(UInt8(0))
            bytes.append(UInt8(0))
        }
        
        return bytes
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        let appDelegate = UIApplication.shared.delegate as! AppDelegate
        appDelegate.spectrumDelegate = self
        //self.showRawDataButton.isHidden = true
        self.scanButton.isEnabled = false
        self.stopButton.isHidden = true
        self.showRawDataButton.titleEdgeInsets = UIEdgeInsetsMake(10,10,10,10)
        self.loadSpectrumButton.titleEdgeInsets = UIEdgeInsetsMake(10,10,10,10)
        if(Constants.BlueToothConnected == false){
            self.bgButton.isEnabled = false
        }
        //notifyBatteryDataChanged(value: appDelegate.battery_value)
        
        //keyboard gesture
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(SpectrumViewController.dismissKeyboard))
        view.addGestureRecognizer(tap)
    }
    
    func dismissKeyboard() {
        view.endEditing(true)
    }
    
    func getRunORBGBytes(command: UInt8) -> [UInt8]
    {
        var bytes = [UInt8]()
        bytes.append(command)
        let st  = Int(Double(scanTimeTF.text!)! * 1000)
        let scan_time = toByteArray(st)
        bytes.append(scan_time[0])
        bytes.append(scan_time[1])
        bytes.append(scan_time[2])
        
        //get Common WL Value
        if(UserDefaults.standard.bool(forKey: "Interpolation_enabled")){
            if(UserDefaults.standard.integer(forKey: "Number_data_points") == 0){
                bytes.append(UInt8(5))
            }else{
                bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Number_data_points")))
            }
        }else{
            bytes.append(UInt8(0))
        }
        
        //get Optical Settings Value
        let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
        if(selectedOption != nil){
            if(selectedOption == "Default"){
                bytes.append(UInt8(0))
            }else{
                bytes.append(UInt8(2))
            }
        }else{
            bytes.append(UInt8(0))
        }
        
        //get Apodization Window Value
        bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Apodization_function")))
        
        //get zero Padding Value
        if(UserDefaults.standard.integer(forKey: "Zero_padding") == 0){
            bytes.append(UInt8(1))
        }else{
            bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Zero_padding")))
        }
        
        //get Run Mode
        bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Run_mode") * 5))
        
        return bytes
    }
    
    func toByteArray<T>(_ value: T) -> [UInt8] {
        var value = value
        return withUnsafePointer(to: &value) {
            $0.withMemoryRebound(to: UInt8.self, capacity: MemoryLayout<T>.size) {
                Array(UnsafeBufferPointer(start: $0, count: MemoryLayout<T>.size))
            }
        }
    }
    
    func isSameSettingsAsBg () -> Bool
    {
        var error = false
        let scanTimeValue = Double(scanTimeTF.text!)!
        if(scanTimeTF.text == "" || scanTimeValue != self.Bg_Input_ST)
        {
            error = true
        }
        //Check Common WL Value
        var CWL : Int
        if(UserDefaults.standard.bool(forKey: "Interpolation_enabled")){
            if(UserDefaults.standard.integer(forKey: "Number_data_points") == 0){
                CWL = 5
            }else{
                CWL = Int(UserDefaults.standard.integer(forKey: "Number_data_points"))
            }
        }else{
            CWL = 0
        }
        if(CWL != self.Bg_Input_Values[0])
        {
            error = true
        }
        //Check Optical Settings Value
        var OptSet : Int
        let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
        if(selectedOption != nil){
            if(selectedOption == "Default"){
                OptSet = 0
            }else{
                OptSet = 2
            }
        }else{
            OptSet = 0
        }
        if(OptSet != self.Bg_Input_Values[1])
        {
            error = true
        }
        //Check Apodization Window Value
        let ApodW = Int(UserDefaults.standard.integer(forKey: "Apodization_function"))
        if(ApodW != self.Bg_Input_Values[2])
        {
            error = true
        }
        //Check zero Padding Value
        var zPad : Int
        if(UserDefaults.standard.integer(forKey: "Zero_padding") == 0){
            zPad = 1
        }else{
            zPad = Int(UserDefaults.standard.integer(forKey: "Zero_padding"))
        }
        if(zPad != self.Bg_Input_Values[3])
        {
            error = true
        }
        
        if(error != false)
        {
            let error_message = ErrorMessageforExpectedInput()
            let alertController = UIAlertController(title: "Error", message:
                error_message, preferredStyle: UIAlertControllerStyle.alert)
            alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: nil))
            
            DispatchQueue.main.async {
                self.present(alertController, animated: true, completion: nil)
            }
            return false
        }
        
        return true
    }
    
    func ErrorMessageforExpectedInput() -> String
    {
        var outputMessage = "Sample scan should have the same settings as the Background scan. Used Settings are as follows.\n"
        outputMessage = outputMessage + "Scan Time: " + String(self.Bg_Input_ST) + "\n"
        outputMessage = outputMessage + "Common Wavelength: " + Constants.COMMON_WL_VALUES[self.Bg_Input_Values[0]] + "\n"
        outputMessage = outputMessage + "Optical Settings: " + Constants.OPTICAL_GAIN_VALUES[self.Bg_Input_Values[1]] + "\n"
        outputMessage = outputMessage + "Apodization Window: " + Constants.APPODIZATION_W_VALUES[self.Bg_Input_Values[2]] + "\n"
        outputMessage = outputMessage + "Zero Padding: " + Constants.ZERO_PADDING_VALUES[self.Bg_Input_Values[3] - 1] + "\n"
        
        return outputMessage
    }
    
    func isValidData () -> Bool
    {
        var error_message = ""
        if(scanTimeTF.text == "") {error_message =  "Please, fill Scan Time value."}
        else{
            let instance = NumberFormatter()
            if((instance.number(from: scanTimeTF.text!)?.doubleValue) == nil) {
                error_message =  "Please provide a valid scan time."
            }else if(Double(scanTimeTF.text!)! < 0.01){
                error_message = "Scan Time should be greater than 10 ms."
            }
        }
        
        if error_message != ""
        {
            let alertController = UIAlertController(title: "Error", message:
                error_message, preferredStyle: UIAlertControllerStyle.alert)
            alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: nil))
            
            DispatchQueue.main.async {
                self.present(alertController, animated: true, completion: nil)
            }
            return false
        }
        
        return true
    }
    
    override func viewDidAppear(_ animated: Bool) {
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        
        NotificationCenter.default.removeObserver(self)
        if UIDevice.current.isGeneratingDeviceOrientationNotifications {
            UIDevice.current.endGeneratingDeviceOrientationNotifications()
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        if(Constants.kitInUsePSD){
            self.bgButton.isEnabled = false
            self.scanButton.isEnabled = false
        }else if(Constants.BlueToothConnected){
            self.bgButton.isEnabled = true
            if(self.Bg_taken){
                self.scanButton.isEnabled = true
            }
        }
        self.deviceDidRotate()
        UIDevice.current.beginGeneratingDeviceOrientationNotifications()
        NotificationCenter.default.addObserver(self, selector: #selector(deviceDidRotate), name: NSNotification.Name.UIDeviceOrientationDidChange, object: nil)
        guard let statusBar = UIApplication.shared.value(forKeyPath: "statusBarWindow.statusBar") as? UIView else { return }
        statusBar.backgroundColor = UIColor.white
        
    }
    
    func deviceDidRotate(){
        if(UIDevice.current.orientation == .landscapeLeft || UIDevice.current.orientation == .landscapeRight){
            if(Constants.deviceType == .iPhone6 || Constants.deviceType == .iPhone6s || Constants.deviceType == .iPhone7 || Constants.deviceType == .iPhone8){
                self.scanViewConstraint.constant = 0
            }else if(Constants.deviceType == .iPhone6Plus || Constants.deviceType == .iPhone6sPlus || Constants.deviceType == .iPhone7Plus || Constants.deviceType == .iPhone8Plus){
                self.scanViewConstraint.constant = 20
            }
            self.scanTimeConstraint.constant = 33
            self.bgViewConstraintY.constant = -240
            self.scanViewConstraintX.constant = 120
            self.bgViewConstraintX.constant = -120
        }else if(UIDevice.current.orientation == .portrait){
            self.scanTimeConstraint.constant = 66
            self.scanViewConstraint.constant = 33.5
            self.scanViewConstraintX.constant = 0
            self.bgViewConstraintX.constant = 0
            self.bgViewConstraintY.constant = -70
        }
    }
    
    private var _orientations = UIInterfaceOrientationMask.portrait
    override var supportedInterfaceOrientations : UIInterfaceOrientationMask {
        get { return self._orientations }
        set { self._orientations = newValue }
    }
    
    //MARK: - Segue methods
    override func shouldPerformSegue(withIdentifier identifier: String, sender: Any?) -> Bool {
        //if identifier == "rawData1"{
        //    return self.doubledata.count != 0 || self.floatdata.count != 0
        //}
        return true
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "rawData1"
        {
            let nc = segue.destination as! UINavigationController
            let controller = nc.childViewControllerForStatusBarHidden as! ChartViewController
            controller.floatdata = self.floatdata
            controller.doubledata = Constants.Spectrumdoubledata
            controller.source = "Spectrum"
        }
        
    }
    
    //MARK: - NSBluetoothManagerDelegate
    func didConnectPeripheral(deviceName aName : String)
    {
        let delayInSeconds = 3.0
        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + delayInSeconds) {
        //DispatchQueue.main.async {
            self.bgButton.isEnabled = true
        }
    }
    
    func didDisconnectPeripheral()
    {
        let alertController = UIAlertController(title: "Error", message:
            "Connection Lost.", preferredStyle: UIAlertControllerStyle.alert)
        alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: nil))
        
        DispatchQueue.main.async {
            self.skipBoardError = 0
            self.Iteration = 1
            self.bgButton.isEnabled = false
            if(self.scanButton.isEnabled == true){
                self.scanButton.isEnabled = false
            }
            self.Bg_taken = false
            if(self.buttonAnimating){
                self.stopScanButtonAnimation()
                self.present(alertController, animated: true, completion: nil)
                
            }
            if(self.BgButtonAnimating){
                self.stopBgButtonAnimation()
                self.present(alertController, animated: true, completion: nil)
            }
        }
        
    }
    
    func receivedDoubleData(allData:[Double], sender:AppDelegate.MainViews)
    {
        if allData.count > 0 {
            DispatchQueue.main.async {
                //if(self.skipBoardError > 0){
                //    self.skipBoardError = 0
                //}
                if(allData.count == 1) {
                    if(self.BgButtonAnimating){
                        if(self.Iteration == 1){
                            self.Iteration = 2
                            self.runBG()
                        }else{
                            self.Iteration = 1
                            self.stopBgButtonAnimation()
                            //self.showRawDataButton.isHidden = true
                            if(self.scanButton.isEnabled == false){
                                self.scanButton.isEnabled = true
                            }
                        }
                    }
                    if(self.buttonAnimating){
                        if(self.Iteration == 1){
                            self.Iteration = 2
                            self.runSpectrum()
                        }
                    }
                }else{
                    if(self.Iteration == 2){
                        if(UserDefaults.standard.integer(forKey: "Run_mode") == 1){
                            if(!Constants.SpectrumcaptureRequested && Constants.Spectrumdoubledata.count > 0 && Constants.Spectrumdoubledata.count > Constants.SpectrumstartingDataCount){
                                Constants.Spectrumdoubledata.removeLast()
                            }else if(Constants.SpectrumcaptureRequested){
                                Constants.SpectrumcaptureRequested = false
                            }
                        }
                        self.Iteration = 1
                        var spectrum = allData
                        for i in 0..<spectrum.count/2
                        {
                          spectrum[i] = spectrum[i] * Double(100)
                        }
                        Constants.Spectrumdoubledata.append(spectrum)
                        if(self.requestedMode == 0){
                            self.stopScanButtonAnimation()
                            //self.showRawDataButton.isHidden = false
                        }else{
                            self.runSpectrum()
                        }
                    }
                }
            }
        }
    }
    
    func receivedFloatData(allData:[Float], sender:AppDelegate.MainViews)
    {
        
    }
    
    func reportError(error:UInt8, sender:AppDelegate.MainViews)
    {
        if(self.skipBoardError < 3){
            //let delayInSeconds = 2.0
            //DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + delayInSeconds) {
            DispatchQueue.main.async {
                self.skipBoardError += 1
                print(self.skipBoardError)
                self.Iteration = 1
                if(self.BgButtonAnimating){
                    self.runBG()
                }else{
                    self.runSpectrum()
                }
            }
        }else{
            let alertController = UIAlertController(title: "Error", message:
                self.getErrorMessage(error: error), preferredStyle: UIAlertControllerStyle.alert)
            alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: { (UIAlertAction)in
                    Constants.reportedError = 0
            }))
            let delayInSeconds = 2.0
            DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + delayInSeconds) {
                //DispatchQueue.main.async {
                self.Iteration = 1
                if(self.skipBoardError > 0){
                    self.skipBoardError = 0
                }
                Constants.reportedError = error
                if(self.buttonAnimating) {self.stopScanButtonAnimation()}
                if(self.BgButtonAnimating) {self.stopBgButtonAnimation()}
                self.present(alertController, animated: true, completion: nil)
            }
        }
        
    }
    
    func getErrorMessage(error:UInt8) -> String
    {
        if(error == 101){
            return "Timeout!"
        }else if(error == 102){
            return "No background!"
        }else{
            return String(format: "Error number: %d" , error)
        }
    }
    
    //MARK: - ViewAnimation
    func startScanButtonAnimation()
    {
        self.floatdata = [Float]()
        //self.doubledata = [Double]()
        //self.showRawDataButton.isHidden = true
        let image1:UIImage = UIImage(named: "scan_bt1")!
        let image2:UIImage = UIImage(named: "scan_bt2")!
        let image3:UIImage = UIImage(named: "scan_bt3")!
        self.scanButton.setImage(image3, for: UIControlState.normal)
        self.scanButton.imageView!.animationImages = [image1, image2, image3]
        self.scanButton.imageView!.animationDuration = 0.75
        self.buttonAnimating = true
        self.skipBoardError = 0
        Constants.SpectrumstartingDataCount = Constants.Spectrumdoubledata.count
        Constants.reportedError = 0
        Constants.kitInUseSpectrum = true
        self.scanTimeTF.isEnabled = false
        self.loadSpectrumButton.isEnabled = false
        if(UserDefaults.standard.integer(forKey: "Run_mode") == 1){
            self.stopButton.isHidden = false
            self.scanButton.isHidden = true
            let image1:UIImage = UIImage(named: "stop_bt1")!
            let image2:UIImage = UIImage(named: "stop_bt2")!
            let image3:UIImage = UIImage(named: "stop_bt3")!
            self.stopButton.setImage(image3, for: UIControlState.normal)
            self.stopButton.imageView!.animationImages = [image1, image2, image3]
            self.stopButton.imageView!.animationDuration = 0.75
            self.stopButton.imageView!.startAnimating()
        }else{
            self.scanButton.imageView!.startAnimating()
        }
    }
    
    func stopScanButtonAnimation()
    {
        if(self.scanButton.imageView?.isAnimating)!{
            self.scanButton.imageView!.stopAnimating()
        }
        if(self.stopButton.imageView?.isAnimating)!{
            self.stopButton.imageView!.stopAnimating()
            self.scanButton.isHidden = false
        }
        self.buttonAnimating = false
        self.stopButton.isHidden = true
        self.scanTimeTF.isEnabled = true
        Constants.kitInUseSpectrum = false
        self.loadSpectrumButton.isEnabled = true
    }
    
    func startBgButtonAnimation()
    {
        self.floatdata = [Float]()
        //self.doubledata = [Double]()
        //self.showRawDataButton.isHidden = true
        let image1:UIImage = UIImage(named: "bg_btn_round_1")!
        let image2:UIImage = UIImage(named: "bg_btn_round_2")!
        let image3:UIImage = UIImage(named: "bg_btn_round_3")!
        self.bgButton.setImage(image3, for: UIControlState.normal)
        self.bgButton.imageView!.animationImages = [image1, image2, image3]
        self.bgButton.imageView!.animationDuration = 0.75
        self.bgButton.imageView!.startAnimating()
        self.BgButtonAnimating = true
        self.skipBoardError = 0
        Constants.kitInUseSpectrum = true
        self.scanTimeTF.isEnabled = false
        self.scanButton.isEnabled = false
        self.loadSpectrumButton.isEnabled = false
    }
    
    func stopBgButtonAnimation()
    {
        self.bgButton.imageView!.stopAnimating()
        self.BgButtonAnimating = false
        self.Bg_taken = true
        self.scanTimeTF.isEnabled = true
        Constants.kitInUseSpectrum = false
        self.loadSpectrumButton.isEnabled = true
    }
}
