//
//  SettingsViewController.swift
//  NeoSpectraMicroSwift
//
//  Created by Si-Ware on 10/26/17.
//  Copyright © 2017 siware. All rights reserved.
//

import Foundation
import InAppSettingsKit

class SettingsViewController : IASKAppSettingsViewController , IASKSettingsDelegate{
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.delegate = self
        
        self.updateOptions()
        
        if(Constants.SelectedDeviceName == ""){
            UserDefaults.standard.set("Default", forKey: "Optical_gain_settings_title")
        }
        guard let statusBar = UIApplication.shared.value(forKeyPath: "statusBarWindow.statusBar") as? UIView else { return }
        statusBar.backgroundColor = UIColor.clear
        //UserDefaults.standard.set("Taymour", forKey: "Optical_gain_settings_title")
    }
    
    func didChangeSettingViaIASK(_ notification: Notification!)
    {
        if (notification.userInfo?.keys.first?.description == "Interpolation_enabled" || notification.userInfo?.keys.first?.description == "FFT_enabled" || notification.userInfo?.keys.first?.description == "Advanced_enabled")
        {
            updateOptions()
        }
    }
    
    func  settingsViewController(_ sender: IASKAppSettingsViewController, buttonTappedFor specifier: IASKSpecifier) {
        
        //if(specifier.key() == "Burn_settings")
        //{
        //    self.Burn_settings_clicked()
        //}
    }
    
    func updateOptions(){
        let Interpolation_enabled = UserDefaults.standard.bool(forKey: "Interpolation_enabled")
        let FFT_enabled = UserDefaults.standard.bool(forKey: "FFT_enabled")
        let Advanced_enabled = UserDefaults.standard.bool(forKey: "Advanced_enabled")
        if (Interpolation_enabled && FFT_enabled && Advanced_enabled)
        {
            let keys = Set<NSObject>();
            self.setHiddenKeys(keys, animated: true)
        }
            
        else if(Interpolation_enabled && !FFT_enabled && Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("FFT_settings" as NSObject)
            keys.insert("Apodization_function" as NSObject)
            keys.insert("Zero_padding" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
            
        else if(Interpolation_enabled && FFT_enabled && !Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("Advanced_settings" as NSObject)
            keys.insert("Add_new_optical_gain" as NSObject)
            keys.insert("Wavelength_correction_group" as NSObject)
            keys.insert("Wavelength_correction" as NSObject)
            keys.insert("Burn_settings_group" as NSObject)
            keys.insert("Burn_settings" as NSObject)
            keys.insert("Restore_default_settings_group" as NSObject)
            keys.insert("Restore_default_settings" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
            
        else if(Interpolation_enabled && !FFT_enabled && !Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("FFT_settings" as NSObject)
            keys.insert("Apodization_function" as NSObject)
            keys.insert("Zero_padding" as NSObject)
            keys.insert("Advanced_settings" as NSObject)
            keys.insert("Add_new_optical_gain" as NSObject)
            keys.insert("Wavelength_correction_group" as NSObject)
            keys.insert("Wavelength_correction" as NSObject)
            keys.insert("Burn_settings_group" as NSObject)
            keys.insert("Burn_settings" as NSObject)
            keys.insert("Restore_default_settings_group" as NSObject)
            keys.insert("Restore_default_settings" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
        else if(!Interpolation_enabled && FFT_enabled && Advanced_enabled)
        {
            var keys = Set<NSObject>();
            keys.insert("Data_points_group" as NSObject)
            keys.insert("Number_data_points" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
            
        else if(!Interpolation_enabled && !FFT_enabled && Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("Data_points_group" as NSObject)
            keys.insert("Number_data_points" as NSObject)
            keys.insert("FFT_settings" as NSObject)
            keys.insert("Apodization_function" as NSObject)
            keys.insert("Zero_padding" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
        else if(!Interpolation_enabled && FFT_enabled && !Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("Data_points_group" as NSObject)
            keys.insert("Number_data_points" as NSObject)
            keys.insert("Advanced_settings" as NSObject)
            keys.insert("Add_new_optical_gain" as NSObject)
            keys.insert("Wavelength_correction_group" as NSObject)
            keys.insert("Wavelength_correction" as NSObject)
            keys.insert("Burn_settings_group" as NSObject)
            keys.insert("Burn_settings" as NSObject)
            keys.insert("Restore_default_settings_group" as NSObject)
            keys.insert("Restore_default_settings" as NSObject)
            self.setHiddenKeys(keys, animated: true)
        }
        else if(!Interpolation_enabled && !FFT_enabled && !Advanced_enabled){
            var keys = Set<NSObject>();
            keys.insert("Data_points_group" as NSObject)
            keys.insert("Number_data_points" as NSObject)
            keys.insert("FFT_settings" as NSObject)
            keys.insert("Apodization_function" as NSObject)
            keys.insert("Zero_padding" as NSObject)
            keys.insert("Advanced_settings" as NSObject)
            keys.insert("Add_new_optical_gain" as NSObject)
            keys.insert("Wavelength_correction_group" as NSObject)
            keys.insert("Wavelength_correction" as NSObject)
            keys.insert("Burn_settings_group" as NSObject)
            keys.insert("Burn_settings" as NSObject)
            keys.insert("Restore_default_settings_group" as NSObject)
            keys.insert("Restore_default_settings" as NSObject)
            self.setHiddenKeys(keys, animated: true)
            
        }
        
    }
    
    func settingsViewControllerDidEnd(_ sender : IASKAppSettingsViewController ) {
        self.dismiss(animated: true, completion: nil)
    }
}
