//
//  RunSelfCorrectionViewController.swift
//  NeoSpectraMicroSwift
//
//  Created by Si-Ware on 11/13/17.
//  Copyright © 2017 siware. All rights reserved.
//

import UIKit

class RunSelfCorrectionViewController: UIViewController , NSBluetoothManagerDelegate{
    
    @IBOutlet weak var textLabel: UILabel!
    
    
    //MARK: - View Properties
    var doubledata: [Double] = [Double]()
    var floatdata: [Float] = [Float]()
    var sender = AppDelegate.MainViews.RUNSELFCORR
    var skipBoardError = 0
    var Iteration = 1
    var scan_time = 0.0
    var loadingActivityIndicator: UIActivityIndicatorView!
    var viewActivityIndicator: UIView!
    var loading = false
    
    func didConnectPeripheral(deviceName aName: String) {
        
    }
    
    func didDisconnectPeripheral() {
        let alertController = UIAlertController(title: "Error", message:
            "Connection Lost.", preferredStyle: UIAlertControllerStyle.alert)
        alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: nil))
        DispatchQueue.main.async {
            self.skipBoardError = 0
            self.Iteration = 1
            if(self.loading){
                self.removeLoading()
                self.present(alertController, animated: true, completion: nil)
            }
            
        }
    }
    
    func receivedDoubleData(allData: [Double], sender: AppDelegate.MainViews) {
        self.floatdata = []
        self.doubledata = allData
        if self.doubledata.count == 1 {
            DispatchQueue.main.async {
                //if(self.skipBoardError > 0){
                //    self.skipBoardError = 0
                //}
                if(self.Iteration == 1){
                    self.Iteration = 2
                    self.runSelfCorrection()
                }else{
                    self.Iteration = 1
                    self.removeLoading()
                    self.textLabel.text = "Calibration Succeeded"
                    self.textLabel.sizeToFit()
                    self.textLabel.center = self.view.center
                    self.textLabel.isHidden = false
                }
            }
        }
    }
    
    func receivedFloatData(allData: [Float], sender: AppDelegate.MainViews) {
        
    }
    
    func reportError(error: UInt8, sender: AppDelegate.MainViews) {
        if(self.skipBoardError < 3){
            //let delayInSeconds = 2.0
            //DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + delayInSeconds) {
            DispatchQueue.main.async {
                self.skipBoardError += 1
                print(self.skipBoardError)
                self.Iteration = 1
                self.runSelfCorrection()
            }
        }else{
            let alertController = UIAlertController(title: "Error", message:
                self.getErrorMessage(error: error), preferredStyle: UIAlertControllerStyle.alert)
            alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: nil))
            let delayInSeconds = 2.0
            DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + delayInSeconds) {
                //DispatchQueue.main.async {
                if(self.skipBoardError > 0){
                    self.skipBoardError = 0
                }
                self.Iteration = 1
                if(self.loading)
                {
                    self.removeLoading()
                    self.textLabel.isHidden = false
                }
                self.present(alertController, animated: true, completion: nil)
            }
        }
    }
    
    func getErrorMessage(error:UInt8) -> String
    {
        if(error == 101){
            return "Timeout!"
        }else if(error == 102){
            return "No background!"
        }else{
            return String(format: "Error number: %d" , error)
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        if(AppDelegate.bluetoothManager != nil && Constants.BlueToothConnected == true){
        
            let appDelegate = UIApplication.shared.delegate as! AppDelegate
            appDelegate.runSelfCorrDelegate = self
        
            //scanning view
            let width: CGFloat = 200.0
            let height: CGFloat = 50.0
            let x = self.view.frame.width/2.0 - width/2.0
            let y = self.view.frame.height/2.0 - height/2.0
        
            self.viewActivityIndicator = UIView(frame: CGRect(x: x, y: y, width: width, height: height))
            self.viewActivityIndicator.backgroundColor = UIColor(red: 0.0/255.0, green: 0.0/255.0, blue: 0.0/255.0, alpha: 0.7)
            self.viewActivityIndicator.layer.cornerRadius = 10
        
            self.loadingActivityIndicator = UIActivityIndicatorView(frame: CGRect(x: 0, y: 0, width: 50, height: 50))
            self.loadingActivityIndicator.color = UIColor.white
            self.loadingActivityIndicator.hidesWhenStopped = false
        
            let titleLabel = UILabel(frame: CGRect(x: 60, y: 0, width: 200, height: 50))
            titleLabel.text = "Scanning..."
            titleLabel.textColor = UIColor.white
        
            self.viewActivityIndicator.addSubview(self.loadingActivityIndicator)
            self.viewActivityIndicator.addSubview(titleLabel)
        
            self.textLabel.isHidden = true
        
            self.getScanTime()
        }else {
            self.textLabel.text = "No NeoSpectraMicro Kit is Connected"
            self.textLabel.sizeToFit()
            self.textLabel.center = self.view.center
            self.textLabel.isHidden = false
        }
    }
    
    func runSelfCorrection(){
        if(AppDelegate.bluetoothManager != nil && Constants.BlueToothConnected == true){
            if(self.Iteration == 1){
                if(self.loading == false){
                    self.addLoading()
                }
                let data = Data(bytes: self.setOpticalGainBytes())
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }else{
                let data = Data(bytes: self.getSELFCBytes())
                AppDelegate.bluetoothManager?.send(data: data, sender: self.sender)
            }
        }
    }
    
    func setOpticalGainBytes() -> [UInt8]
    {
        //append Command
        var bytes = [UInt8]()
        bytes.append(UInt8(27))
        
        //append Optical Settings Value
        let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
        if(selectedOption != nil){
            if(UserDefaults.standard.object(forKey: "Optical_gain_settings_options") != nil){
                let kitID = Constants.SelectedDeviceName.components(separatedBy: "_")[1]
                let currentOptions = UserDefaults.standard.object(forKey: "Optical_gain_settings_options") as! [String : String]
                var selectedValue = ""
                if(selectedOption == "Default"){
                    selectedValue = currentOptions[selectedOption!]!
                }else{
                    selectedValue = currentOptions[selectedOption! + "_" + kitID]!
                }
                let value = UInt16(selectedValue)
                let Valuebytes = self.toByteArray(value)
                bytes.append(Valuebytes[0])
                bytes.append(Valuebytes[1])
            }else{
                bytes.append(UInt8(0))
                bytes.append(UInt8(0))
            }
        }else{
            bytes.append(UInt8(0))
            bytes.append(UInt8(0))
        }
        
        return bytes
    }
    
    func getSELFCBytes() -> [UInt8]
    {
        var bytes = [UInt8]()
        bytes.append(UInt8(0x0A))
        let st  = Int(self.scan_time * 1000)
        let scanTime = toByteArray(st)
        bytes.append(scanTime[0])
        bytes.append(scanTime[1])
        bytes.append(scanTime[2])
        
        //get Common WL Value
        if(UserDefaults.standard.bool(forKey: "Interpolation_enabled")){
            if(UserDefaults.standard.integer(forKey: "Number_data_points") == 0){
                bytes.append(UInt8(5))
            }else{
                bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Number_data_points")))
            }
        }else{
            bytes.append(UInt8(0))
        }
        
        //get Optical Settings Value
        let selectedOption = UserDefaults.standard.string(forKey: "Optical_gain_settings_title")
        if(selectedOption != nil){
            if(selectedOption == "Default"){
                bytes.append(UInt8(0))
            }else{
                bytes.append(UInt8(2))
            }
        }else{
            bytes.append(UInt8(0))
        }
        
        //get Apodization Window Value
        bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Apodization_function")))
        
        //get zero Padding Value
        if(UserDefaults.standard.integer(forKey: "Zero_padding") == 0){
            bytes.append(UInt8(1))
        }else{
            bytes.append(UInt8(UserDefaults.standard.integer(forKey: "Zero_padding")))
        }
        
        //get Run Mode
        bytes.append(UInt8(0))
        
        return bytes
    }
    
    func toByteArray<T>(_ value: T) -> [UInt8] {
        var value = value
        return withUnsafePointer(to: &value) {
            $0.withMemoryRebound(to: UInt8.self, capacity: MemoryLayout<T>.size) {
                Array(UnsafeBufferPointer(start: $0, count: MemoryLayout<T>.size))
            }
        }
    }
    
    func getScanTime(){
        let alertController = UIAlertController(title: "Scan Time", message:
            "Please enter the scan time for wavelength self-correction in seconds.", preferredStyle: UIAlertControllerStyle.alert)
        
        alertController.addTextField { (configurationTextField) in
            //configure here your textfield
            configurationTextField.textColor = UIColor.black
            configurationTextField.keyboardType = UIKeyboardType.decimalPad
        }
        
        alertController.addAction(UIAlertAction(title: "Proceed", style: UIAlertActionStyle.default,handler: { (UIAlertAction)in
            let textField = (alertController.textFields![0]) as UITextField
            self.isValidDoubleNumber(value: textField.text!)
        }))
        
        alertController.addAction(UIAlertAction(title: "Cancel", style: UIAlertActionStyle.default, handler:{ (UIAlertAction)in
            self.textLabel.isHidden = false
        }))
        
        DispatchQueue.main.async {
            self.present(alertController, animated: true, completion: nil)
        }
    }

    func isValidDoubleNumber(value: String)
    {
        var error_message = ""
        if(value == "") {
           error_message =  "Please fill Scan Time value."
        }else{
        
            let instance = NumberFormatter()
            if((instance.number(from: value)?.doubleValue) == nil) {
                error_message =  "Please provide a valid scan time."
            }else if(Double(value)! < 0.01){
                error_message = "Scan Time should be greater than 10 ms."
            }
        }
        if error_message != ""
        {
            let alertController = UIAlertController(title: "Error", message:
                error_message, preferredStyle: UIAlertControllerStyle.alert)
            alertController.addAction(UIAlertAction(title: "Dismiss", style: UIAlertActionStyle.default,handler: { (UIAlertAction)in
                self.getScanTime()
            }))
            
            DispatchQueue.main.async {
                self.present(alertController, animated: true, completion: nil)
            }
        }else{
            self.scan_time = Double(value)!
            self.showWarningMessage()
        }
    }
    
    func showWarningMessage()
    {
        let alertController = UIAlertController(title: "Self-Correction", message:
            "Please inject NIR broadband light for reference light measurement.", preferredStyle: UIAlertControllerStyle.alert)
        
        alertController.addAction(UIAlertAction(title: "Proceed", style: UIAlertActionStyle.default,handler: { (UIAlertAction)in
            self.runSelfCorrection()
        }))
        
        alertController.addAction(UIAlertAction(title: "Cancel", style: UIAlertActionStyle.default, handler:{ (UIAlertAction)in
            self.textLabel.isHidden = false
        }))
        
        DispatchQueue.main.async {
            self.present(alertController, animated: true, completion: nil)
        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */
    
    //MARK: ViewLoading
    func removeLoading() -> Void {
        loading = false
        self.loadingActivityIndicator.stopAnimating()
        UIApplication.shared.endIgnoringInteractionEvents()
        self.viewActivityIndicator.removeFromSuperview()
    }
    
    func addLoading() -> Void {
        self.view.addSubview(self.viewActivityIndicator)
        self.loadingActivityIndicator.startAnimating()
        UIApplication.shared.beginIgnoringInteractionEvents()
        loading = true
        self.skipBoardError = 0
    }

}
