//
//  FileListTableView.swift
//  NeoSpectraMicroSwift
//
//  Created by Si-Ware on 1/30/18.
//  Copyright © 2018 siware. All rights reserved.
//

import Foundation

extension FileListViewController: UITableViewDataSource, UITableViewDelegate {
    
    //MARK: UITableViewDataSource, UITableViewDelegate
    
    func numberOfSections(in tableView: UITableView) -> Int {
        if searchController.isActive {
            return 1
        }
        return sections.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if searchController.isActive {
            return filteredFiles.count
        }
        return sections[section].count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellIdentifier = "FileCell"
        var cell = UITableViewCell(style: .subtitle, reuseIdentifier: cellIdentifier)
        if let reuseCell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier) {
            cell = reuseCell
        }
        cell.selectionStyle = .blue
        let selectedFile = fileForIndexPath(indexPath)
        cell.textLabel?.text = selectedFile.displayName
        cell.imageView?.image = selectedFile.type.image()
        if(self.selectAll && !selectedFile.isDirectory){
            cell.accessoryType = UITableViewCellAccessoryType.checkmark
            if(!self.selectedFiles.contains(selectedFile.filePath)){
                self.selectedFiles.append(selectedFile.filePath)
            }
        }else if(!self.selectAll && !selectedFile.isDirectory){
            cell.accessoryType = UITableViewCellAccessoryType.none
            if(self.selectedFiles.contains(selectedFile.filePath)){
                let index = self.selectedFiles.index(of: selectedFile.filePath)
                self.selectedFiles.remove(at: index!)
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let selectedFile = fileForIndexPath(indexPath)
        searchController.isActive = false
        if selectedFile.isDirectory {
            var fileListViewController : FileListViewController
            if(self.save_load == "save"){
                fileListViewController = FileListViewController(initialPath: selectedFile.filePath, save_load: "save", selectAll: false)
            }else if(self.save_load == "load"){
                fileListViewController = FileListViewController(initialPath: selectedFile.filePath, save_load: "load", selectAll: false)
            }else{
                fileListViewController = FileListViewController(initialPath: selectedFile.filePath, save_load: "", selectAll: false)
            }
            fileListViewController.didSelectFile = didSelectFile
            fileListViewController.allowEditing = true
            fileListViewController.navigationItem.leftItemsSupplementBackButton = true
            fileListViewController.chartView = self.chartView
            fileListViewController.PSDView = self.PSDView
            fileListViewController.SpectrumView = self.SpectrumView
            self.navigationController?.pushViewController(fileListViewController, animated: true)
        }
        else {
            if(self.save_load == "load"){
                let cell = tableView.cellForRow(at: IndexPath(row: indexPath.row, section: indexPath.section))
                if(cell?.accessoryType == UITableViewCellAccessoryType.checkmark){
                    self.selectAll = false
                    cell?.accessoryType = UITableViewCellAccessoryType.none
                    if(self.selectedFiles.contains(selectedFile.filePath)){
                        let index = self.selectedFiles.index(of: selectedFile.filePath)
                        self.selectedFiles.remove(at: index!)
                    }
                }else{
                    cell?.accessoryType = UITableViewCellAccessoryType.checkmark
                    if(!self.selectedFiles.contains(selectedFile.filePath)){
                        self.selectedFiles.append(selectedFile.filePath)
                    }
                }
                tableView.deselectRow(at: indexPath, animated: true)
            }else{
                if let didSelectFile = didSelectFile {
                    self.dismiss()
                    didSelectFile(selectedFile)
                }
                else {
                    let filePreview = previewManager.previewViewControllerForFile(selectedFile, fromNavigation: true)
                    self.navigationController?.pushViewController(filePreview, animated: true)
                }
            }
        }
        tableView.deselectRow(at: indexPath, animated: true)
    }
    
    func tableView(_ tableView: UITableView, titleForHeaderInSection section: Int) -> String? {
        if searchController.isActive {
            return nil
        }
        if sections[section].count > 0 {
            return collation.sectionTitles[section]
        }
        else {
            return nil
        }
    }
    
    func sectionIndexTitles(for tableView: UITableView) -> [String]? {
        if searchController.isActive {
            return nil
        }
        return collation.sectionIndexTitles
    }
    
    func tableView(_ tableView: UITableView, sectionForSectionIndexTitle title: String, at index: Int) -> Int {
        if searchController.isActive {
            return 0
        }
        return collation.section(forSectionIndexTitle: index)
    }
    
    func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCellEditingStyle, forRowAt indexPath: IndexPath) {
        if (editingStyle == UITableViewCellEditingStyle.delete) {
            let selectedFile = fileForIndexPath(indexPath)
            selectedFile.delete()
            
            prepareData()
            tableView.reloadSections([indexPath.section], with: UITableViewRowAnimation.automatic)
        }
    }
    
    func tableView(_ tableView: UITableView, canEditRowAt indexPath: IndexPath) -> Bool {
        return allowEditing
    }
    
    
}
