//
//  Constants.swift
//  NeoSpectraSwift
//
//  Created by doda on 11/9/16.
//  Copyright © 2016 siware. All rights reserved.
//

import Foundation
import DeviceKit

class Constants: NSObject {    
    static var AdvancedView_Input_ST = Int64(2000)
    static let COMMON_WL_VALUES = ["Disabled", "65 pts", "129 pts", "257 pts", "513 pts", "1024 pts", "2048 pts", "4096 pts"]
    static let OPTICAL_GAIN_VALUES = ["Default", "Calculated", "External"]
    static let APPODIZATION_W_VALUES = ["Boxcar","Gaussian","Happ-Genzel","Lorenz"]
    static let ZERO_PADDING_VALUES = ["0","1","3"]
    static let OPTICAL_GAIN_COMMAND = Data(bytes: [0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let BURN_GAIN_COMMAND = Data(bytes: [0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let BURN_SELF_COMMAND = Data(bytes: [0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let BURN_REF_MAT_COMMAND = Data(bytes: [0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let RESTORE_COMMAND = Data(bytes: [0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let LIGHT_ON_COMMAND = Data(bytes: [0x07, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let LIGHT_OFF_COMMAND = Data(bytes: [0x08, 0x00, 0x00, 0x00, 0x00, 0x00])
    static let BATTERY_STATUS_COMMAND = Data(bytes: [0x09, 0x00, 0x00, 0x00, 0x00, 0x00])
    static var BlueToothConnected = false
    static var WaitToStartBluetoothConnection = true
    static var SelectedDeviceName = ""
    static var kitInUsePSD = false
    static var kitInUseSpectrum = false
    static var PSDdoubledata: [[Double]] = [[Double]]()
    static var Spectrumdoubledata: [[Double]] = [[Double]]()
    static var PSDcaptureRequested = false
    static var PSDstartingDataCount = 0
    static var SpectrumcaptureRequested = false
    static var SpectrumstartingDataCount = 0
    static var reportedError = UInt8(0)
    static var save_load = ""
    static let deviceType = Device()
}
