/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.SamplingXYLineRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYLineChart {
    private ChartPanel chartPanel;
    private DefaultXYDataset dataset;
    private double upper;
    private double lower;
    private double minXLimit;
    private double maxXLimit;
    private double minYLimit;
    private double maxYLimit;
    private Color[] colors = new Color[]{new Color(0, 0, 255), new Color(255, 20, 147), new Color(255, 215, 0), new Color(0, 255, 0), new Color(0, 128, 128), new Color(106, 90, 205), new Color(210, 105, 30), new Color(154, 205, 50), new Color(0, 255, 255), new Color(255, 140, 0), new Color(139, 0, 0), new Color(124, 252, 0), new Color(138, 43, 226), new Color(105, 105, 105), new Color(102, 205, 170), new Color(255, 69, 0), new Color(0, 0, 0), new Color(106, 90, 205), new Color(255, 255, 0), new Color(50, 205, 50), new Color(25, 25, 112), new Color(255, 0, 0), new Color(128, 128, 0), new Color(139, 69, 19), new Color(148, 0, 211), new Color(0, 100, 0), new Color(47, 79, 79), new Color(178, 34, 34), new Color(30, 144, 255), new Color(0, 128, 0), new Color(255, 105, 180)};

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public XYLineChart(String string, Comparable<String> comparable, String string2, String string3, double[][] dArray) {
        this.dataset = new DefaultXYDataset();
        this.addSeries(comparable, dArray);
        JFreeChart jFreeChart = this.createXYLineChart((XYDataset)this.dataset, string, string2, string3, 0.0, 0.0, 0.0, 0.0);
        this.chartPanel = new ChartPanel(jFreeChart);
        this.upper = 0.0;
        this.lower = 0.0;
    }

    public XYLineChart(String string, Comparable<String> comparable, String string2, String string3, double[][] dArray, boolean bl) {
        this.dataset = new DefaultXYDataset();
        this.addSeries(comparable, dArray);
        JFreeChart jFreeChart = this.createXYLineChart((XYDataset)this.dataset, string, string2, string3, 0.0, 0.0, 0.0, 0.0);
        this.chartPanel = new ChartPanel(jFreeChart);
        if (bl) {
            this.upper = Double.MIN_VALUE;
            this.lower = Double.MAX_VALUE;
            this.updateLowerUpper(this.dataset);
            this.ReScale();
        }
    }

    public XYLineChart(String string, Comparable<String> comparable, String string2, String string3, double[][] dArray, double d, double d2, double d3, double d4) {
        this.dataset = new DefaultXYDataset();
        this.addSeries(comparable, dArray);
        this.minXLimit = d;
        this.maxXLimit = d2;
        this.minYLimit = d3;
        this.maxYLimit = d4;
        JFreeChart jFreeChart = this.createXYLineChart((XYDataset)this.dataset, string, string2, string3, d, d2, d3, d4);
        jFreeChart.addChangeListener(new ChartChangeListener(){

            public void chartChanged(ChartChangeEvent chartChangeEvent) {
                if (chartChangeEvent.getChart() != null) {
                    XYLineChart.this.chartChangeHandeling(chartChangeEvent);
                }
            }
        });
        this.chartPanel = new ChartPanel(jFreeChart);
        this.upper = d4;
        this.lower = d3;
    }

    private void chartChangeHandeling(ChartChangeEvent chartChangeEvent) {
        if (this.dataset.getSeriesCount() == 1 && this.dataset.getItemCount(0) == 1) {
            if (chartChangeEvent.getChart().getXYPlot().getDomainAxis().getRange().getLowerBound() != this.minXLimit && chartChangeEvent.getChart().getXYPlot().getDomainAxis().getRange().getUpperBound() != this.maxXLimit) {
                chartChangeEvent.getChart().getXYPlot().getDomainAxis().setRange(this.minXLimit, this.maxXLimit);
            }
            if (chartChangeEvent.getChart().getXYPlot().getRangeAxis().getRange().getLowerBound() != this.minYLimit && chartChangeEvent.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound() != this.maxYLimit) {
                chartChangeEvent.getChart().getXYPlot().getRangeAxis().setRange(this.minYLimit, this.maxYLimit);
            }
        }
    }

    public void addSeries(Comparable<String> comparable, double[][] dArray) {
        this.addSeries(comparable, dArray, false);
    }

    public void addSeries(Comparable<String> comparable, double[][] dArray, boolean bl) {
        int n;
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset();
        defaultXYDataset.addSeries(comparable, dArray);
        for (n = 0; n < this.dataset.getSeriesCount(); ++n) {
            Comparable comparable2 = this.dataset.getSeriesKey(n);
            if (comparable2.equals(comparable)) continue;
            defaultXYDataset.addSeries(comparable2, this.getDataOfSeries(this.dataset, n));
        }
        this.clearDataSet();
        for (n = 0; n < defaultXYDataset.getSeriesCount(); ++n) {
            this.dataset.addSeries(defaultXYDataset.getSeriesKey(n), this.getDataOfSeries(defaultXYDataset, n));
        }
        if (bl) {
            this.updateLowerUpper(this.dataset);
            this.ReScale();
        }
    }

    private double[][] getDataOfSeries(DefaultXYDataset defaultXYDataset, int n) {
        double[][] dArrayArray = new double[][]{new double[defaultXYDataset.getItemCount(n)], new double[defaultXYDataset.getItemCount(n)]};
        for (int i = 0; i < defaultXYDataset.getItemCount(n); ++i) {
            dArrayArray[0][i] = defaultXYDataset.getXValue(n, i);
            dArrayArray[1][i] = defaultXYDataset.getYValue(n, i);
        }
        return dArrayArray;
    }

    private void clearDataSet() {
        while (this.dataset.getSeriesCount() != 0) {
            this.dataset.removeSeries(this.dataset.getSeriesKey(0));
        }
    }

    private void updateLowerUpper(DefaultXYDataset defaultXYDataset) {
        this.upper = Double.MIN_VALUE;
        this.lower = Double.MAX_VALUE;
        for (int i = 0; i < defaultXYDataset.getSeriesCount(); ++i) {
            double[][] dArray = this.getDataOfSeries(defaultXYDataset, i);
            double d = this.maxDouble(dArray[1]);
            double d2 = this.minDouble(dArray[1]);
            if (d > this.upper) {
                this.upper = d;
                this.upper += this.upper * 0.02;
            }
            if (!(d2 < this.lower)) continue;
            this.lower = d2;
            this.lower -= this.upper * 0.02;
        }
    }

    private void ReScale() {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        valueAxis.setLowerBound(this.lower);
        valueAxis.setUpperBound(this.upper);
    }

    private JFreeChart createXYLineChart(XYDataset xYDataset, String string, String string2, String string3, double d, double d2, double d3, double d4) {
        Object object;
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)string, (String)string2, (String)string3, (XYDataset)xYDataset);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint((Paint)Color.white);
        xYPlot.setRangeGridlinePaint((Paint)Color.black);
        xYPlot.setDomainGridlinePaint((Paint)Color.black);
        if (d != 0.0) {
            object = xYPlot.getDomainAxis();
            object.setLowerBound(d);
        }
        if (d2 != 0.0) {
            object = xYPlot.getDomainAxis();
            object.setUpperBound(d2);
        }
        if (d3 != 0.0) {
            object = xYPlot.getRangeAxis();
            object.setLowerBound(d3);
        }
        if (d4 != 0.0) {
            object = xYPlot.getRangeAxis();
            object.setUpperBound(d4);
        }
        object = new SamplingXYLineRenderer(){
            private static final long serialVersionUID = 1L;

            public Paint getSeriesPaint(int n) {
                XYDataset xYDataset = this.getPlot().getDataset();
                String string = xYDataset.getSeriesKey(n).toString();
                Matcher matcher = Pattern.compile("\\d+").matcher(string);
                int n2 = 0;
                if (matcher.find()) {
                    n2 = Integer.parseInt(matcher.group());
                    --n2;
                } else if (string.contains("Neg")) {
                    n2 = 0;
                } else if (string.contains("Pos")) {
                    n2 = 1;
                }
                return XYLineChart.this.colors[n2 %= XYLineChart.this.colors.length];
            }

            public LegendItem getLegendItem(int n, int n2) {
                XYDataset xYDataset = this.getPlot().getDataset(n);
                String string = xYDataset.getSeriesKey(n2).toString();
                LegendItem legendItem = new LegendItem(string, this.lookupSeriesPaint(n2));
                legendItem.setLine((Shape)new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0));
                return legendItem;
            }
        };
        xYPlot.setRenderer((XYItemRenderer)object);
        return jFreeChart;
    }

    public void removeSeries(String string) {
        this.removeSeries(string);
    }

    private double maxDouble(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double minDouble(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public double[][] getGraphData(String string) {
        return this.getDataOfSeries(this.dataset, this.dataset.indexOf((Comparable)((Object)string)));
    }

    public String[] getSeriesKeys() {
        String[] stringArray = new String[this.dataset.getSeriesCount()];
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            stringArray[i] = this.dataset.getSeriesKey(i).toString();
        }
        return stringArray;
    }
}

