/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import sws.p3AppManager_micro.utils.p3AppManagerNotification;
import sws.p3AppManager_micro.utils.p3Enumerations;
import sws.spectromost.InterSpecPanel;
import sws.spectromost.SpectroscopyPanel;
import sws.spectromost.UserInterface;

public class WL_WN_CalibrationPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(WL_WN_CalibrationPanel.class);
    private static String runTime = null;
    private static String resolution = null;
    private static String opticalSettings = null;
    private static String commonWVN = null;
    private static String tabPrefix = null;
    private static String apodizationIndex = null;
    private static String zeroPaddingMultiplier = null;
    static JFrame frmWL_Calib;
    public static JRadioButton rdbtn_Self_Calib;
    public static JRadioButton rdbtn_RM_Corr;
    static JButton btn_Proceed_WL_Calib;
    static JButton btn_Close_WL_Calib;
    static JLabel lbl_Progress_Details_WL_Calib;
    static JComboBox<String> cmb_StandardCalibrator_WL_Calib;
    static JButton btn_LoadStandardCalibrator_WL_Calib;
    private static String[] panelActionNamesSelfCalib;
    private static WL_WN_Calib_Actions[] panelActionsSelfCalib;
    private static String[] panelActionNamesRM;
    private static WL_WN_Calib_Actions[] panelActionsRM;

    public WL_WN_CalibrationPanel(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        runTime = string;
        resolution = string2;
        opticalSettings = string3;
        apodizationIndex = string4;
        zeroPaddingMultiplier = string5;
        commonWVN = string6;
        tabPrefix = string7;
        this.initialize();
    }

    public void initialize() {
        Object object;
        Serializable serializable;
        int n;
        frmWL_Calib = new JFrame();
        frmWL_Calib.setAlwaysOnTop(true);
        for (n = 0; n < panelActionsSelfCalib.length; ++n) {
            WL_WN_CalibrationPanel.panelActionsSelfCalib[n] = new WL_WN_Calib_Actions(panelActionNamesSelfCalib[n]);
        }
        for (n = 0; n < panelActionsRM.length; ++n) {
            WL_WN_CalibrationPanel.panelActionsRM[n] = new WL_WN_Calib_Actions(panelActionNamesRM[n]);
        }
        try {
            serializable = new File(UserInterface.ICON_PATH);
            if (((File)serializable).exists()) {
                object = ImageIO.read((File)serializable);
                frmWL_Calib.setIconImage((Image)object);
            } else {
                JOptionPane.showMessageDialog(frmWL_Calib, "Icon doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(frmWL_Calib, "Error loading Icon:" + iOException.getMessage(), "Loading icon", 0);
        }
        frmWL_Calib.setBackground(new Color(176, 196, 222));
        frmWL_Calib.getContentPane().setBackground(new Color(176, 196, 222));
        frmWL_Calib.setVisible(true);
        frmWL_Calib.setName("SpecFrame");
        frmWL_Calib.setMinimumSize(new Dimension(360, 300));
        frmWL_Calib.setMaximumSize(new Dimension(360, 300));
        frmWL_Calib.setPreferredSize(new Dimension(360, 300));
        frmWL_Calib.setLocation((int)(UserInterface.screenSize.getWidth() / 2.0 - 150.0), (int)(UserInterface.screenSize.getHeight() / 2.0 - 150.0));
        frmWL_Calib.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WL_WN_CalibrationPanel.this.onCloseOperation();
            }
        });
        frmWL_Calib.setTitle("Wavelength & Wavenumber Correction");
        frmWL_Calib.setDefaultCloseOperation(0);
        frmWL_Calib.setResizable(false);
        frmWL_Calib.setFont(new Font("Dialog", 0, 12));
        frmWL_Calib.setBackground(new Color(176, 196, 222));
        frmWL_Calib.getContentPane().setLayout((LayoutManager)new MigLayout("", "[90.00:90.00][45.00:45.00][grow,fill]", "[][][][][][grow][]"));
        rdbtn_Self_Calib.setFont(new Font("Dialog", 0, 12));
        frmWL_Calib.getContentPane().add((Component)rdbtn_Self_Calib, "cell 0 0 1 1,growx");
        rdbtn_Self_Calib.setSelected(true);
        rdbtn_Self_Calib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                for (n = 0; n < panelActionsSelfCalib.length; ++n) {
                    panelActionsSelfCalib[n].setSucceeded(false);
                }
                for (n = 0; n < panelActionsRM.length; ++n) {
                    panelActionsRM[n].setSucceeded(false);
                }
                lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
                if (tabPrefix.equals("_Spec_")) {
                    cmb_StandardCalibrator_WL_Calib.setEnabled(false);
                    btn_LoadStandardCalibrator_WL_Calib.setEnabled(false);
                }
            }
        });
        if (tabPrefix.equals("_Spec_")) {
            rdbtn_RM_Corr.setFont(new Font("Dialog", 0, 12));
            frmWL_Calib.getContentPane().add((Component)rdbtn_RM_Corr, "cell 0 1 1 1,growx");
            rdbtn_RM_Corr.setSelected(false);
            rdbtn_RM_Corr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    for (n = 0; n < panelActionsSelfCalib.length; ++n) {
                        panelActionsSelfCalib[n].setSucceeded(false);
                    }
                    for (n = 0; n < panelActionsRM.length; ++n) {
                        panelActionsRM[n].setSucceeded(false);
                    }
                    lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
                    cmb_StandardCalibrator_WL_Calib.setEnabled(true);
                    btn_LoadStandardCalibrator_WL_Calib.setEnabled(true);
                }
            });
        }
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(rdbtn_Self_Calib);
        if (tabPrefix.equals("_Spec_")) {
            ((ButtonGroup)serializable).add(rdbtn_RM_Corr);
        }
        if (tabPrefix.equals("_Spec_")) {
            cmb_StandardCalibrator_WL_Calib = new JComboBox();
            cmb_StandardCalibrator_WL_Calib.setEnabled(false);
            cmb_StandardCalibrator_WL_Calib.setFont(new Font("Dialog", 1, 12));
            cmb_StandardCalibrator_WL_Calib.setMaximumSize(new Dimension(220, WL_WN_CalibrationPanel.cmb_StandardCalibrator_WL_Calib.getPreferredSize().height));
            frmWL_Calib.getContentPane().add(cmb_StandardCalibrator_WL_Calib, "cell 0 2 3 1,growx");
            cmb_StandardCalibrator_WL_Calib.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    UserInterface.displayStandardCalibrators();
                }
            });
            btn_LoadStandardCalibrator_WL_Calib = new JButton("");
            btn_LoadStandardCalibrator_WL_Calib.setFont(new Font("Dialog", 0, 10));
            btn_LoadStandardCalibrator_WL_Calib.setEnabled(false);
            btn_LoadStandardCalibrator_WL_Calib.setText("Add New");
            btn_LoadStandardCalibrator_WL_Calib.setVerticalTextPosition(0);
            btn_LoadStandardCalibrator_WL_Calib.setHorizontalTextPosition(0);
            btn_LoadStandardCalibrator_WL_Calib.setToolTipText("Add New Standard Calibrator");
            btn_LoadStandardCalibrator_WL_Calib.setMaximumSize(new Dimension(110, WL_WN_CalibrationPanel.btn_LoadStandardCalibrator_WL_Calib.getPreferredSize().height));
            btn_LoadStandardCalibrator_WL_Calib.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    logger.info((Object)"NewStandardCalibrator Started");
                    String string = (String)JOptionPane.showInputDialog(frmWL_Calib, "Please enter new standard calibrator as:\nStandard_Calibrator_Name{wavelength1_nm,wavelength2_nm}\nExample: Methylene_Cloride{1367.5,1417.5}\nNOTE: Spaces are not allowed", "New Standard Calibrator", -1, null, null, "Standard_Calibrator_Name{WL1_nm,WL2_nm}");
                    if (null == string) {
                        return;
                    }
                    if (!string.equals("")) {
                        if (UserInterface.addNewStandardCalibrator(string)) {
                            JOptionPane.showMessageDialog(frmWL_Calib, "New Standard Calibrator Saved Successfully", "New Standard Calibrator", 1);
                        } else {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Wrong format. Failed to save!", "New Standard Calibrator", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(frmWL_Calib, "Failed to save!", "New Standard Calibrator", 0);
                    }
                }
            });
            frmWL_Calib.getContentPane().add((Component)btn_LoadStandardCalibrator_WL_Calib, "cell 2 3 1 1,growx");
        }
        object = new Label("Progress");
        ((Component)object).setFont(new Font("Dialog", 1, 12));
        frmWL_Calib.getContentPane().add((Component)object, "cell 0 4 3 1,growx");
        lbl_Progress_Details_WL_Calib = new JLabel();
        lbl_Progress_Details_WL_Calib.setFont(new Font("Dialog", 0, 12));
        Border border = BorderFactory.createEtchedBorder(1);
        lbl_Progress_Details_WL_Calib.setBorder(border);
        lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
        lbl_Progress_Details_WL_Calib.setVerticalAlignment(1);
        lbl_Progress_Details_WL_Calib.setVerticalTextPosition(1);
        lbl_Progress_Details_WL_Calib.setAlignmentY(0.0f);
        frmWL_Calib.getContentPane().add((Component)lbl_Progress_Details_WL_Calib, "cell 0 5 3 1,grow");
        btn_Proceed_WL_Calib = new JButton("");
        btn_Proceed_WL_Calib.setFont(new Font("Dialog", 0, 12));
        btn_Proceed_WL_Calib.setText("Proceed >>");
        btn_Proceed_WL_Calib.setVerticalTextPosition(0);
        btn_Proceed_WL_Calib.setHorizontalTextPosition(0);
        btn_Proceed_WL_Calib.setToolTipText("Proceed");
        btn_Proceed_WL_Calib.setMaximumSize(new Dimension(110, WL_WN_CalibrationPanel.btn_Proceed_WL_Calib.getPreferredSize().height));
        btn_Proceed_WL_Calib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (rdbtn_RM_Corr.isSelected()) {
                    for (n = 0; n < panelActionsRM.length && panelActionsRM[n].getSucceeded().booleanValue(); ++n) {
                    }
                } else {
                    for (n = 0; n < panelActionsSelfCalib.length && panelActionsSelfCalib[n].getSucceeded().booleanValue(); ++n) {
                    }
                }
                if (rdbtn_RM_Corr.isSelected()) {
                    switch (n) {
                        case 0: {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Please inject light from NIR wide band light source.", "Wavenumber Calibration", 1);
                            logger.info((Object)"WavelengthCalibrationBG Started");
                            WL_WN_CalibrationPanel.this.wavelengthCalibrationBG_Sequence();
                            break;
                        }
                        case 1: {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Please insert your sample.", "Wavenumber Calibration", 1);
                            logger.info((Object)"WavelengthCalibration Started");
                            WL_WN_CalibrationPanel.this.wavelengthCalibrationSequence();
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Unsupported Action!", "Wavelength & Wavenumber Correction", 0);
                            break;
                        }
                    }
                } else {
                    switch (n) {
                        case 0: {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Please place a reference material with a flat spectral response at the front face of the light source.", "Self-Correction", 1);
                            logger.info((Object)"Self_Correction_Factors_Calc Started");
                            WL_WN_CalibrationPanel.this.selfCorrCalibSequence();
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(frmWL_Calib, "Unsupported Action!", "Wavelength & Wavenumber Correction", 0);
                        }
                    }
                }
            }
        });
        frmWL_Calib.getContentPane().add((Component)btn_Proceed_WL_Calib, "cell 0 6 3 1,growx, alignx right");
        btn_Close_WL_Calib = new JButton("");
        btn_Close_WL_Calib.setFont(new Font("Dialog", 0, 12));
        btn_Close_WL_Calib.setText("Close");
        btn_Close_WL_Calib.setToolTipText("Close");
        btn_Close_WL_Calib.setMaximumSize(new Dimension(110, WL_WN_CalibrationPanel.btn_Close_WL_Calib.getPreferredSize().height));
        btn_Close_WL_Calib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WL_WN_CalibrationPanel.this.onCloseOperation();
            }
        });
        frmWL_Calib.getContentPane().add((Component)btn_Close_WL_Calib, "cell 0 6 3 1,growx, alignx right");
    }

    private void onCloseOperation() {
        UserInterface.stopEnablingButtons = false;
        UserInterface.checkDeviceStatusThreadStop = false;
        UserInterface.boardReadyRoutine(true);
        frmWL_Calib.dispose();
    }

    private static String getActionsString() {
        String string = "<html>";
        int n = 0;
        if (rdbtn_RM_Corr.isSelected()) {
            for (int i = 0; i < panelActionsRM.length; ++i) {
                if (0 == n) {
                    if (panelActionsRM[i].getSucceeded().booleanValue()) {
                        string = string + "<font color='green'>" + panelActionsRM[i].getActionName() + " &#10004; </font><br />";
                        continue;
                    }
                    ++n;
                    string = string + "<font color='black'>" + panelActionsRM[i].getActionName() + "</font><br />";
                    continue;
                }
                string = string + "<font color='gray'>" + panelActionsRM[i].getActionName() + "</font><br />";
            }
        } else {
            for (int i = 0; i < panelActionsSelfCalib.length; ++i) {
                if (0 == n) {
                    if (panelActionsSelfCalib[i].getSucceeded().booleanValue()) {
                        string = string + "<font color='green'>" + panelActionsSelfCalib[i].getActionName() + " &#10004; </font><br />";
                        continue;
                    }
                    ++n;
                    string = string + "<font color='black'>" + panelActionsSelfCalib[i].getActionName() + "</font><br />";
                    continue;
                }
                string = string + "<font color='gray'>" + panelActionsSelfCalib[i].getActionName() + "</font><br />";
            }
        }
        string = string + "</html>";
        return string;
    }

    private void wavelengthCalibrationBG_Sequence() {
        try {
            UserInterface.checkDeviceStatusThreadStop = true;
            try {
                SpectroscopyPanel.lastResolutionSelected = resolution;
                SpectroscopyPanel.lastZeroPaddingSelected = zeroPaddingMultiplier;
                SpectroscopyPanel.lastWindowSelected = apodizationIndex;
                InterSpecPanel.lastResolutionSelected = resolution;
                if ("Choose Material ...".equals(cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString()) || cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString() == null || cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString() == "") {
                    JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start: Please select standard calibrator.", "Wavelength Calibration", 0);
                    UserInterface.checkDeviceStatusThreadStop = false;
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start. Module setup failed!", "Wavelength Calibration", 0);
                UserInterface.checkDeviceStatusThreadStop = false;
                return;
            }
            UserInterface.progressTime = Double.parseDouble(runTime);
            UserInterface.progressPar.setValue(0);
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.wavelengthCalibrationBG(new String[]{runTime, apodizationIndex, zeroPaddingMultiplier, opticalSettings, commonWVN, resolution});
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    UserInterface.checkDeviceStatusThreadStop = false;
                }
                JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Wavelength Calibration", 0);
                UserInterface.releaseDeviceToken();
            } else {
                WL_WN_CalibrationPanel.panelReadyRoutine(false);
                UserInterface.statusLabel.setText("Background measurement started. Please wait...");
                UserInterface.colorLabel.setForeground(Color.yellow);
                UserInterface.colorLabel.setBackground(Color.yellow);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frmWL_Calib, "Run failed to start. Please check inputs.", "Run NeoSpectra Micro", 0);
        }
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
    }

    private void wavelengthCalibrationSequence() {
        try {
            UserInterface.checkDeviceStatusThreadStop = true;
            try {
                if ("Choose Material ...".equals(cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString()) || cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString() == null || cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString() == "") {
                    JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start: Please select standard calibrator.", "Wavelength Calibration", 0);
                    UserInterface.checkDeviceStatusThreadStop = false;
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start. Module setup failed!", "Wavelength Calibration", 0);
                UserInterface.checkDeviceStatusThreadStop = false;
                return;
            }
            UserInterface.progressTime = Double.parseDouble(runTime);
            UserInterface.progressPar.setValue(0);
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.wavelengthCalibration(new String[]{runTime, cmb_StandardCalibrator_WL_Calib.getSelectedItem().toString(), apodizationIndex, zeroPaddingMultiplier, opticalSettings, commonWVN, resolution});
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    UserInterface.checkDeviceStatusThreadStop = false;
                }
                JOptionPane.showMessageDialog(frmWL_Calib, "Wavelength calibration failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Wavelength Calibration", 0);
                UserInterface.releaseDeviceToken();
            } else {
                WL_WN_CalibrationPanel.panelReadyRoutine(false);
                UserInterface.statusLabel.setText("Wavelength calibration started. Please wait...");
                UserInterface.colorLabel.setForeground(Color.yellow);
                UserInterface.colorLabel.setBackground(Color.yellow);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frmWL_Calib, "Run failed to start. Please check inputs.", "Run NeoSpectra Micro", 0);
        }
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
    }

    private void selfCorrCalibSequence() {
        logger.info((Object)"selfCorrCalibSequence function started");
        try {
            UserInterface.checkDeviceStatusThreadStop = true;
            try {
                logger.info((Object)"setSettings function (reg file rewrite) started");
                logger.info((Object)"setSettings function (reg file rewrite) finished");
                SpectroscopyPanel.lastResolutionSelected = "two_points_corr";
                SpectroscopyPanel.lastZeroPaddingSelected = zeroPaddingMultiplier;
                SpectroscopyPanel.lastWindowSelected = apodizationIndex;
                InterSpecPanel.lastResolutionSelected = "two_points_corr";
                logger.info((Object)"Setting Optical Settings started");
                logger.info((Object)"Setting Optical Settings finished");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(frmWL_Calib, "Run failed to start. Module setup failed!", "Self-Correction", 0);
                UserInterface.checkDeviceStatusThreadStop = false;
                return;
            }
            UserInterface.progressTime = Double.parseDouble(runTime);
            UserInterface.progressPar.setValue(0);
            logger.info((Object)"runInterSpec function started");
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.runCalibCorr(new String[]{runTime, apodizationIndex, zeroPaddingMultiplier, opticalSettings, commonWVN});
            logger.info((Object)"runInterSpec function finished");
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    UserInterface.checkDeviceStatusThreadStop = false;
                }
                JOptionPane.showMessageDialog(frmWL_Calib, "Run failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Self-Correction", 0);
                UserInterface.releaseDeviceToken();
            } else {
                logger.info((Object)"disabling GUI fields started");
                WL_WN_CalibrationPanel.panelReadyRoutine(false);
                logger.info((Object)"disabling GUI fields finished");
                UserInterface.statusLabel.setText("Calibration started. Please wait...");
                UserInterface.colorLabel.setForeground(Color.yellow);
                UserInterface.colorLabel.setBackground(Color.yellow);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frmWL_Calib, "Run failed to start. Please check inputs.", "Self-Correction", 0);
        }
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
    }

    public static void update(Object object) {
        if (object instanceof p3AppManagerNotification) {
            logger.info((Object)"update method started");
            p3AppManagerNotification p3AppManagerNotification2 = (p3AppManagerNotification)object;
            switch (p3AppManagerNotification2.getAction()) {
                case 25: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        panelActionsSelfCalib[0].setSucceeded(true);
                        panelActionsSelfCalib[1].setSucceeded(true);
                        lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
                        UserInterface.statusLabel.setText("Calibration is completed successfully!");
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                        JOptionPane.showMessageDialog(frmWL_Calib, "Calibration Succeeded!", "Wavelength & Wavenumber Correction", -1);
                    } else {
                        UserInterface.colorLabel.setForeground(Color.red);
                        UserInterface.colorLabel.setBackground(Color.red);
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                        JOptionPane.showMessageDialog(frmWL_Calib, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Wavelength & Wavenumber Correction", 0);
                    }
                    logger.info((Object)"switching actuation off started");
                    logger.info((Object)"switching actuation off finished");
                    logger.info((Object)"enabling panel GUI fields started");
                    WL_WN_CalibrationPanel.panelReadyRoutine(true);
                    logger.info((Object)"enabling panel GUI fields finished");
                    btn_Proceed_WL_Calib.setEnabled(false);
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    break;
                }
                case 26: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        panelActionsRM[1].setSucceeded(true);
                        panelActionsRM[2].setSucceeded(true);
                        lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
                        UserInterface.statusLabel.setText("Calibration is completed successfully!");
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                        JOptionPane.showMessageDialog(frmWL_Calib, "Calibration Succeeded!", "Wavelength & Wavenumber Correction", -1);
                    } else {
                        UserInterface.colorLabel.setForeground(Color.red);
                        UserInterface.colorLabel.setBackground(Color.red);
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                        JOptionPane.showMessageDialog(frmWL_Calib, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Wavelength & Wavenumber Correction", 0);
                    }
                    logger.info((Object)"switching actuation off started");
                    logger.info((Object)"switching actuation off finished");
                    logger.info((Object)"enabling panel GUI fields started");
                    WL_WN_CalibrationPanel.panelReadyRoutine(true);
                    logger.info((Object)"enabling panel GUI fields finished");
                    btn_Proceed_WL_Calib.setEnabled(false);
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    break;
                }
                case 30: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        panelActionsRM[0].setSucceeded(true);
                        lbl_Progress_Details_WL_Calib.setText(WL_WN_CalibrationPanel.getActionsString());
                        UserInterface.statusLabel.setText("BG measurement is completed successfully!");
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                    } else {
                        UserInterface.colorLabel.setForeground(Color.red);
                        UserInterface.colorLabel.setBackground(Color.red);
                        UserInterface.progressTime = -1.0;
                        UserInterface.progressPar.setValue(100);
                        JOptionPane.showMessageDialog(frmWL_Calib, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Wavelength & Wavenumber Correction", 0);
                    }
                    logger.info((Object)"switching actuation off started");
                    logger.info((Object)"switching actuation off finished");
                    logger.info((Object)"enabling panel GUI fields started");
                    WL_WN_CalibrationPanel.panelReadyRoutine(true);
                    logger.info((Object)"enabling panel GUI fields finished");
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    break;
                }
            }
        }
    }

    public static void panelReadyRoutine(boolean bl) {
        if (bl) {
            btn_Proceed_WL_Calib.setEnabled(true);
            btn_Close_WL_Calib.setEnabled(true);
        } else {
            btn_Proceed_WL_Calib.setEnabled(false);
            btn_Close_WL_Calib.setEnabled(false);
        }
    }

    static {
        rdbtn_Self_Calib = new JRadioButton("Self-Correction");
        rdbtn_RM_Corr = new JRadioButton("Correction Using Reference Material");
        panelActionNamesSelfCalib = new String[]{"Step 1: Reference light measurement", "Step 2: Process self-correction"};
        panelActionsSelfCalib = new WL_WN_Calib_Actions[panelActionNamesSelfCalib.length];
        panelActionNamesRM = new String[]{"Step 1: Reference light measurement", "Step 2: Reference material measurement", "Step 3: Process self-correction"};
        panelActionsRM = new WL_WN_Calib_Actions[panelActionNamesRM.length];
    }

    private class WL_WN_Calib_Actions {
        private final String actionName;
        private boolean succeeded;

        WL_WN_Calib_Actions(String string) {
            this.actionName = string;
            this.succeeded = false;
        }

        public String getActionName() {
            return this.actionName;
        }

        public Boolean getSucceeded() {
            return this.succeeded;
        }

        public void setSucceeded(boolean bl) {
            this.succeeded = bl;
        }
    }
}

