/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import sws.p3AppManager_micro.p3AppManagerImpl;
import sws.p3AppManager_micro.p3AppManager_micro;
import sws.p3AppManager_micro.utils.p3AppManagerNotification;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.p3AppManager_micro.utils.p3Constants;
import sws.p3AppManager_micro.utils.p3Enumerations;
import sws.spectromost.About;
import sws.spectromost.InterSpecPanel;
import sws.spectromost.SaveOpticalGainPanel;
import sws.spectromost.SpectroscopyPanel;
import sws.spectromost.WL_WN_CalibrationPanel;

public class UserInterface
implements Observer {
    private static Logger logger = Logger.getLogger(UserInterface.class);
    static JFrame frmMain;
    public static boolean switchingDeviceFinished;
    public static final long switchingDeviceTimeOut = 2000L;
    public static String regFileToWrite;
    public static boolean stopEnablingButtons;
    public static boolean actState;
    public static boolean isContinuousRun;
    public static boolean stopContinuousRun;
    public static String APPLICATION_WORKING_DIRECTORY;
    public static final String IMAGES_DIRECTORY;
    public static final String LOGO_IMAGE_PATH;
    public static final String RUN_IMAGE_PATH;
    public static final String RUN_BG_IMAGE_PATH;
    public static final String SAVE_IMAGE_PATH;
    public static final String LOAD_IMAGE_PATH;
    public static final String CAPTURE_IMAGE_PATH;
    public static final String DELETE_IMAGE_PATH;
    public static final String STOP_IMAGE_PATH;
    public static final String ICON_PATH;
    public static final String GRAPH_FILES_FOLDER_PATH;
    public static final String OPTIONS_PATH;
    public static String defaultDirectorySaveLoad;
    public static String fileNameToSave;
    public static JCheckBoxMenuItem chb_Advanced_menuBar;
    public static JCheckBoxMenuItem chb_SleepAction_menuBar;
    public static JCheckBoxMenuItem chb_PowerOff_menuBar;
    public static String moduleID;
    private static boolean DeviceToken;
    static final int SCALE = 25;
    static final int SMALL_SCALE = 20;
    static p3AppManager_micro applicationManager;
    static JLabel colorLabel;
    static JLabel statusLabel;
    static JProgressBar progressPar;
    static InterSpecPanel pnl_Inter_Spec;
    static SpectroscopyPanel pnl_Spectroscopy;
    private JTabbedPane tabbedPane;
    static boolean checkDeviceStatusThreadStop;
    static double progressTime;
    static final int THREAD_SLEEP_TIME = 1000;
    static boolean boardRestarted;
    static Dimension screenSize;
    Thread checkDeviceStatusThread = new Thread(){

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    if (!checkDeviceStatusThreadStop) {
                        while (!UserInterface.acquireDeviceToken()) {
                        }
                        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.checkDeviceStatus(new String[0]);
                        UserInterface.releaseDeviceToken();
                        if (p3Enumerations.p3AppManagerStatus.NO_ERROR == p3AppManagerStatus2) {
                            if (!statusLabel.getText().equals("Background Measurement completed successfully!")) {
                                statusLabel.setText("NeoSpectra Micro kit is Ready!");
                                colorLabel.setForeground(Color.green.darker());
                                colorLabel.setBackground(Color.green.darker());
                                if (About.DVKVersion.equals("")) {
                                    while (!UserInterface.acquireDeviceToken()) {
                                    }
                                    String[] stringArray = applicationManager.getSoftwareVersion();
                                    UserInterface.releaseDeviceToken();
                                    About.DVKVersion = stringArray[0];
                                    About.PiVersion = stringArray[1];
                                }
                            }
                            if (!stopEnablingButtons) {
                                UserInterface.boardReadyRoutine(true);
                            }
                        } else {
                            progressPar.setValue(0);
                            boardRestarted = true;
                            if (p3Enumerations.p3AppManagerStatus.INITIALIZATION_IN_PROGRESS == p3AppManagerStatus2) {
                                statusLabel.setText("Initializing NeoSpectra Micro kit. Please wait...");
                                colorLabel.setForeground(Color.yellow);
                                colorLabel.setBackground(Color.yellow);
                            } else if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
                                statusLabel.setText("NeoSpectra Micro kit is connected");
                                colorLabel.setForeground(Color.yellow);
                                colorLabel.setBackground(Color.yellow);
                            } else if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2) {
                                statusLabel.setText("SpectroMOST Micro does not detect any connected NeoSpectra Micro kit");
                                SpectroscopyPanel.lbl_moduleID_Spec.setText("");
                                InterSpecPanel.lbl_ModuleID_Inter_Spec.setText("");
                                SpectroscopyPanel.cmb_Optical_Settings_Spec.removeAllItems();
                                InterSpecPanel.cmb_Optical_Settings_Inter_Spec.removeAllItems();
                                InterSpecPanel.lastResolutionSelected = "";
                                SpectroscopyPanel.lastResolutionSelected = "";
                                SpectroscopyPanel.lastZeroPaddingSelected = "";
                                SpectroscopyPanel.lastWindowSelected = "";
                                SpectroscopyPanel.lastCommonWavenumberSelected = "";
                                SpectroscopyPanel.lastOpticalSettingsSelected = "";
                                InterSpecPanel.lastOpticalSettingsSelected = "";
                                About.DVKVersion = "";
                                About.PiVersion = "";
                                colorLabel.setForeground(Color.gray);
                                colorLabel.setBackground(Color.gray);
                            } else {
                                colorLabel.setForeground(Color.red);
                                colorLabel.setBackground(Color.red);
                                statusLabel.setText(UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2) + ".");
                            }
                            UserInterface.boardReadyRoutine(false);
                            InterSpecPanel.btn_SaveGraphs_Inter_Spec.setEnabled(true);
                            InterSpecPanel.btn_LoadGraphs_Inter_Spec.setEnabled(true);
                            InterSpecPanel.btn_ClearGraphs_Inter_Spec.setEnabled(true);
                            SpectroscopyPanel.btn_SaveGraphs_Spec.setEnabled(true);
                            SpectroscopyPanel.btn_LoadGraphs_Spec.setEnabled(true);
                            SpectroscopyPanel.btn_ClearGraphs_Spec.setEnabled(true);
                            SpectroscopyPanel.btn_Stop_Spec.setEnabled(false);
                            InterSpecPanel.btn_Stop_Inter_Spec.setEnabled(false);
                        }
                        frmMain.revalidate();
                        frmMain.repaint();
                        continue;
                    }
                    if (progressTime == -1.0) continue;
                    if ((int)(1000.0 / progressTime * 100.0) != 0) {
                        progressPar.setValue(progressPar.getValue() + (int)(1000.0 / progressTime * 100.0));
                        continue;
                    }
                    progressPar.setValue(progressPar.getValue() + (int)Math.ceil(1000.0 / progressTime * 100.0));
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
                return;
            }
        }
    };

    public static synchronized boolean acquireDeviceToken() {
        if (DeviceToken) {
            return false;
        }
        DeviceToken = true;
        return true;
    }

    public static synchronized void releaseDeviceToken() {
        DeviceToken = false;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"Starting Application.....");
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    UserInterface userInterface = new UserInterface();
                    frmMain.setVisible(true);
                    p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.initializeCore(new String[0]);
                    if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        logger.error((Object)("error happen while trying to run current initialize \n" + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2)));
                    }
                    userInterface.checkDeviceStatusThread.start();
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                }
            }
        });
    }

    public UserInterface() {
        this.initialize();
        applicationManager = new p3AppManagerImpl();
        applicationManager.addObserver((Observer)this);
    }

    private void initialize() {
        Object object;
        Serializable serializable;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frmMain = new JFrame();
        try {
            serializable = new File(ICON_PATH);
            if (((File)serializable).exists()) {
                object = ImageIO.read((File)serializable);
                frmMain.setIconImage((Image)object);
            } else {
                JOptionPane.showMessageDialog(null, "Icon doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading Icon:" + iOException.getMessage(), "Loading icon", 0);
        }
        p3AppManagerUtils.removeDir((String)p3Constants.getPath((String)GRAPH_FILES_FOLDER_PATH));
        p3AppManagerUtils.createDir((String)p3Constants.getPath((String)GRAPH_FILES_FOLDER_PATH));
        frmMain.setBackground(new Color(176, 196, 222));
        frmMain.getContentPane().setBackground(new Color(176, 196, 222));
        frmMain.setVisible(true);
        frmMain.setName("frame1");
        frmMain.setMinimumSize(new Dimension(UserInterface.screenSize.width - 70, UserInterface.screenSize.height - 70));
        frmMain.setMaximumSize(new Dimension(UserInterface.screenSize.width - 70, UserInterface.screenSize.height - 70));
        frmMain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UserInterface.this.UserInterface_closeForm();
            }
        });
        frmMain.addComponentListener(new ComponentListener(){
            int state = 0;

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (this.state == 1) {
                    return;
                }
                ++this.state;
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.state = 0;
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                System.out.println("--------------------------------------------------------------------------");
            }
        });
        frmMain.setTitle("SpectroMOST Micro\u2122");
        frmMain.setDefaultCloseOperation(0);
        frmMain.setResizable(true);
        frmMain.setExtendedState(6);
        serializable = new JMenuBar();
        frmMain.getContentPane().add((Component)serializable, "North");
        object = new JMenu("Spectrometer");
        ((JMenuBar)serializable).add((JMenu)object);
        chb_Advanced_menuBar = new JCheckBoxMenuItem("Advanced / FFT Settings", false);
        chb_Advanced_menuBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.ShowAdvancedSettings();
            }
        });
        ((JMenu)object).add(chb_Advanced_menuBar);
        chb_SleepAction_menuBar = new JCheckBoxMenuItem("Sleep", false);
        chb_SleepAction_menuBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.runSleepAction();
            }
        });
        ((JMenu)object).add(chb_SleepAction_menuBar);
        chb_PowerOff_menuBar = new JCheckBoxMenuItem("Power off", false);
        chb_PowerOff_menuBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.runPowerOff();
            }
        });
        ((JMenu)object).add(chb_PowerOff_menuBar);
        JMenuItem jMenuItem = new JMenuItem("Exit                   ");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.this.UserInterface_closeForm();
            }
        });
        ((JMenu)object).add(jMenuItem);
        JMenu jMenu = new JMenu("Help");
        ((JMenuBar)serializable).add(jMenu);
        JMenuItem jMenuItem2 = new JMenuItem("User Manual");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        File file = new File(APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Data" + File.separatorChar + "User Manual.pdf");
                        Desktop.getDesktop().open(file);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(null, "Unable to find the User Manual.\r\nFor more help, please contact Si-Ware Systems.", "Failed to open User Manual", 0);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(null, "Unable to find the User Manual.\r\nFor more help, please contact Si-Ware Systems.", "Failed to open User Manual", 0);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "No application registered to view a PDF file.", "Failed to open User Manual", 0);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Unable to open the User Manual.\r\nFor more help, please contact Si-Ware Systems.", "Failed to open User Manual", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Unable to open the User Manual.\r\nFor more help, please contact Si-Ware Systems.", "Failed to open User Manual", 0);
                }
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("About");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                About about = new About();
                about.setDefaultCloseOperation(2);
                about.setVisible(true);
            }
        });
        jMenu.add(jMenuItem3);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(new Font("DejaVu Serif Condensed", 1, 13));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    if (UserInterface.this.tabbedPane.getSelectedIndex() == 1) {
                        InterSpecPanel.txt_RunTime_Inter_Spec.setText(SpectroscopyPanel.txt_RunTime_Spec.getText());
                        InterSpecPanel.rdbtn_SingleRun_Inter_Spec.setSelected(SpectroscopyPanel.rdbtn_SingleRun_Spec.isSelected());
                        InterSpecPanel.rdbtn_ContRun_Inter_Spec.setSelected(SpectroscopyPanel.rdbtn_ContRun_Spec.isSelected());
                        InterSpecPanel.btn_Capture_Interfero.setEnabled(SpectroscopyPanel.btn_Capture_Spec.isEnabled());
                    } else if (UserInterface.this.tabbedPane.getSelectedIndex() == 0) {
                        SpectroscopyPanel.txt_RunTime_Spec.setText(InterSpecPanel.txt_RunTime_Inter_Spec.getText());
                        SpectroscopyPanel.rdbtn_SingleRun_Spec.setSelected(InterSpecPanel.rdbtn_SingleRun_Inter_Spec.isSelected());
                        SpectroscopyPanel.rdbtn_ContRun_Spec.setSelected(InterSpecPanel.rdbtn_ContRun_Inter_Spec.isSelected());
                        SpectroscopyPanel.btn_Capture_Spec.setEnabled(InterSpecPanel.btn_Capture_Interfero.isEnabled());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        frmMain.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new BevelBorder(1));
        frmMain.getContentPane().add((Component)jPanel, "South");
        jPanel.setPreferredSize(new Dimension(frmMain.getWidth(), 20));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel(" Data transfer progress");
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        progressPar = new JProgressBar(0);
        progressPar.setAlignmentX(2.0f);
        progressPar.setMaximumSize(new Dimension(220, (int)progressPar.getPreferredSize().getHeight()));
        progressPar.setOpaque(true);
        jPanel.add(progressPar);
        JLabel jLabel2 = new JLabel("  Status");
        jLabel2.setHorizontalAlignment(2);
        jPanel.add(jLabel2);
        colorLabel = new JLabel("                                 ");
        colorLabel.setHorizontalAlignment(2);
        colorLabel.setVerticalAlignment(0);
        colorLabel.setMaximumSize(new Dimension(220, (int)(colorLabel.getPreferredSize().getHeight() + 2.0)));
        colorLabel.setOpaque(true);
        colorLabel.setForeground(Color.gray);
        colorLabel.setBackground(Color.gray);
        jPanel.add(colorLabel);
        statusLabel = new JLabel("");
        statusLabel.setHorizontalAlignment(2);
        jPanel.add(statusLabel);
        pnl_Spectroscopy = new SpectroscopyPanel();
        this.tabbedPane.addTab("Spectrum", null, pnl_Spectroscopy, null);
        pnl_Inter_Spec = new InterSpecPanel();
        this.tabbedPane.addTab("PSD", null, pnl_Inter_Spec, null);
    }

    private void UserInterface_closeForm() {
        int n = 0;
        int n2 = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit?", "Exit!", n);
        if (n2 == 0) {
            p3AppManagerUtils.removeDir((String)p3Constants.getPath((String)GRAPH_FILES_FOLDER_PATH));
            System.exit(0);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof p3AppManagerNotification) {
            p3AppManagerNotification p3AppManagerNotification2 = (p3AppManagerNotification)object;
            switch (p3AppManagerNotification2.getAction()) {
                case 0: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Initialization of NeoSpectra Micro kit completed successfully!");
                        UserInterface.initializationPostAction();
                        break;
                    }
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                    statusLabel.setText(UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()));
                    break;
                }
                case 1: {
                    pnl_Inter_Spec.update(object);
                    break;
                }
                case 2: {
                    pnl_Spectroscopy.update(object);
                    break;
                }
                case 3: {
                    pnl_Spectroscopy.update(object);
                    break;
                }
                case 4: {
                    if (p3AppManagerNotification2.getStatus() != 0) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "switch device", 0);
                    } else {
                        switchingDeviceFinished = true;
                    }
                    UserInterface.releaseDeviceToken();
                    checkDeviceStatusThreadStop = false;
                    break;
                }
                case 23: {
                    try {
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        if (p3AppManagerNotification2.getStatus() == 0) {
                            statusLabel.setText("Gain Adjusment completed successfully.");
                            colorLabel.setForeground(Color.green.darker());
                            colorLabel.setBackground(Color.green.darker());
                            boardRestarted = false;
                        } else {
                            colorLabel.setForeground(Color.red);
                            colorLabel.setBackground(Color.red);
                            JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Run NeoSpectra Micro", 0);
                        }
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                        UserInterface.boardReadyRoutine(true);
                    }
                    catch (Exception exception) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        JOptionPane.showMessageDialog(null, "Failed to save gain settings.", "Gain Adjustment", 0);
                        logger.info((Object)"enabling GUI fields started");
                        UserInterface.boardReadyRoutine(true);
                        logger.info((Object)"enabling GUI fields finished");
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                    }
                    break;
                }
                case 25: {
                    try {
                        WL_WN_CalibrationPanel.update(object);
                    }
                    catch (Exception exception) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Self Calibration", 0);
                        logger.info((Object)"switching actuation off started");
                        logger.info((Object)"switching actuation off finished");
                        logger.info((Object)"enabling GUI fields started");
                        UserInterface.boardReadyRoutine(true);
                        logger.info((Object)"enabling GUI fields finished");
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                    }
                    break;
                }
                case 26: {
                    try {
                        WL_WN_CalibrationPanel.update(object);
                    }
                    catch (Exception exception) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Wavenumber Calibration", 0);
                        logger.info((Object)"switching actuation off started");
                        logger.info((Object)"switching actuation off finished");
                        logger.info((Object)"enabling GUI fields started");
                        UserInterface.boardReadyRoutine(true);
                        logger.info((Object)"enabling GUI fields finished");
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                    }
                    break;
                }
                case 28: {
                    try {
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        if (p3AppManagerNotification2.getStatus() == 0) {
                            statusLabel.setText("Gain Adjusment completed successfully.");
                            colorLabel.setForeground(Color.green.darker());
                            colorLabel.setBackground(Color.green.darker());
                            boardRestarted = false;
                            double[][] dArray = applicationManager.getGainAdjustSpecData();
                            SaveOpticalGainPanel saveOpticalGainPanel = new SaveOpticalGainPanel((int)dArray[0][0]);
                            SaveOpticalGainPanel.frmSaveOpticalGain.setVisible(true);
                            break;
                        }
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Run Gain Adjusment", 0);
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                        UserInterface.boardReadyRoutine(true);
                    }
                    catch (Exception exception) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        JOptionPane.showMessageDialog(null, "Failed to save gain settings.", "Gain Adjustment", 0);
                        logger.info((Object)"enabling GUI fields started");
                        UserInterface.boardReadyRoutine(true);
                        logger.info((Object)"enabling GUI fields finished");
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                    }
                    break;
                }
                case 30: {
                    try {
                        WL_WN_CalibrationPanel.update(object);
                    }
                    catch (Exception exception) {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        progressTime = -1.0;
                        progressPar.setValue(100);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Wavenumber Calibration", 0);
                        logger.info((Object)"switching actuation off started");
                        logger.info((Object)"switching actuation off finished");
                        logger.info((Object)"enabling GUI fields started");
                        UserInterface.boardReadyRoutine(true);
                        logger.info((Object)"enabling GUI fields finished");
                        UserInterface.releaseDeviceToken();
                        checkDeviceStatusThreadStop = false;
                    }
                    break;
                }
                case 33: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Restoring to default completed successfully!");
                        colorLabel.setForeground(Color.green.darker());
                        colorLabel.setBackground(Color.green.darker());
                    } else {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        JOptionPane.showMessageDialog(null, "Restore default settings has error: " + p3AppManagerNotification2.getStatus(), "Restore Default Settings", 0);
                    }
                    UserInterface.boardReadyRoutine(true);
                    UserInterface.displayInterSpecOpticalSettings();
                    UserInterface.displaySpecOpticalSettings();
                    UserInterface.releaseDeviceToken();
                    checkDeviceStatusThreadStop = false;
                    break;
                }
                case 34: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Burn Setting completed successfully!");
                        colorLabel.setForeground(Color.green.darker());
                        colorLabel.setBackground(Color.green.darker());
                    } else {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        JOptionPane.showMessageDialog(null, "Burn settings has error: " + p3AppManagerNotification2.getStatus(), "Burn settings", 0);
                    }
                    UserInterface.boardReadyRoutine(true);
                    UserInterface.releaseDeviceToken();
                    checkDeviceStatusThreadStop = false;
                    break;
                }
                case 36: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Sleep Action completed successfully!");
                        chb_SleepAction_menuBar.setEnabled(true);
                        colorLabel.setForeground(Color.blue.darker());
                        colorLabel.setBackground(Color.blue.darker());
                    } else {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        UserInterface.boardReadyRoutine(true);
                        checkDeviceStatusThreadStop = false;
                        chb_SleepAction_menuBar.setSelected(false);
                        JOptionPane.showMessageDialog(null, "Sleep action has error: " + p3AppManagerNotification2.getStatus(), "Sleep action", 0);
                    }
                    UserInterface.releaseDeviceToken();
                    break;
                }
                case 37: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Wake up Action completed successfully!");
                        colorLabel.setForeground(Color.green.darker());
                        colorLabel.setBackground(Color.green.darker());
                        UserInterface.boardReadyRoutine(true);
                        checkDeviceStatusThreadStop = false;
                    } else {
                        statusLabel.setText("Wake up Action failed!");
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        chb_SleepAction_menuBar.setEnabled(true);
                        chb_SleepAction_menuBar.setSelected(true);
                        JOptionPane.showMessageDialog(null, "Wake up action has error: " + p3AppManagerNotification2.getStatus(), "Wake up action", 0);
                    }
                    UserInterface.releaseDeviceToken();
                    break;
                }
                case 38: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Power Off completed successfully!");
                        chb_PowerOff_menuBar.setEnabled(true);
                        colorLabel.setForeground(Color.blue.darker());
                        colorLabel.setBackground(Color.blue.darker());
                    } else {
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        UserInterface.boardReadyRoutine(true);
                        checkDeviceStatusThreadStop = false;
                        chb_PowerOff_menuBar.setSelected(false);
                        JOptionPane.showMessageDialog(null, "Power off has error: " + p3AppManagerNotification2.getStatus(), "Power off", 0);
                    }
                    UserInterface.releaseDeviceToken();
                    break;
                }
                case 39: {
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        statusLabel.setText("Power on completed successfully!");
                        colorLabel.setForeground(Color.green.darker());
                        colorLabel.setBackground(Color.green.darker());
                        UserInterface.boardReadyRoutine(true);
                        checkDeviceStatusThreadStop = false;
                    } else {
                        statusLabel.setText("Power on failed!");
                        colorLabel.setForeground(Color.red);
                        colorLabel.setBackground(Color.red);
                        chb_PowerOff_menuBar.setEnabled(true);
                        chb_PowerOff_menuBar.setSelected(true);
                        JOptionPane.showMessageDialog(null, "Power on has error: " + p3AppManagerNotification2.getStatus(), "Power on", 0);
                    }
                    UserInterface.releaseDeviceToken();
                    break;
                }
            }
            frmMain.revalidate();
            frmMain.repaint();
        }
    }

    public static void initializationPostAction() {
        try {
            moduleID = applicationManager.getDeviceId();
            SpectroscopyPanel.lbl_moduleID_Spec.setText(moduleID);
            InterSpecPanel.lbl_ModuleID_Inter_Spec.setText(moduleID);
            String string = p3AppManagerUtils.formatString((String)p3Constants.getPath((String)p3Constants.OPTICAL_SETTINGS_FILE_PATH), (Object[])new Object[]{moduleID});
            File file = new File(string);
            String string2 = p3Constants.Original_APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Conf_Files" + File.separatorChar + moduleID;
            File file2 = new File(string2);
            String string3 = p3Constants.Original_APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Conf_Files";
            File file3 = new File(string3);
            if (file3.exists()) {
                if (file2.exists()) {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                } else {
                    file2.mkdir();
                    file.createNewFile();
                }
            } else {
                file3.mkdir();
                file2.mkdir();
                file.createNewFile();
            }
            UserInterface.displayInterSpecOpticalSettings();
            UserInterface.displaySpecOpticalSettings();
            UserInterface.displayStandardCalibrators();
            if (SpectroscopyPanel.cmb_Optical_Settings_Spec.getItemCount() > 0) {
                SpectroscopyPanel.cmb_Optical_Settings_Spec.setSelectedIndex(0);
            }
            if (InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getItemCount() > 0) {
                InterSpecPanel.cmb_Optical_Settings_Inter_Spec.setSelectedIndex(0);
            }
            SpectroscopyPanel.cmb_Apodization_Spec.setSelectedIndex(0);
            InterSpecPanel.cmb_Apodization_Inter_Spec.setSelectedIndex(0);
            SpectroscopyPanel.cmb_ZeroPadding_Spec.setSelectedIndex(1);
            InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setSelectedIndex(1);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
        }
        colorLabel.setForeground(Color.green.darker());
        colorLabel.setBackground(Color.green.darker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOpticalGainValue(String string) {
        try {
            String string2 = p3AppManagerUtils.formatString((String)p3Constants.getPath((String)p3Constants.OPTICAL_SETTINGS_FILE_PATH), (Object[])new Object[]{moduleID});
            File file = new File(string2);
            if (!file.exists()) return "-1";
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                String string3 = null;
                do {
                    if ((string3 = bufferedReader.readLine()) == null) return "-1";
                } while (!string3.contains(":") || !string3.split(":")[0].equals(string));
                String string4 = string3.split(":")[1];
                return string4;
            }
            catch (Exception exception) {
                String string5 = null;
                return string5;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int saveOpticalGainRoutine(String string, int n) {
        try {
            Object object;
            String string2 = p3AppManagerUtils.formatString((String)p3Constants.getPath((String)p3Constants.OPTICAL_SETTINGS_FILE_PATH), (Object[])new Object[]{moduleID});
            ArrayList<String> arrayList = new ArrayList<String>();
            File file = new File(string2);
            if (!file.exists()) return 0;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                object = null;
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)object).split(":")[0].trim().equals(string)) {
                        int n2 = 1;
                        return n2;
                    }
                    arrayList.add((String)object);
                }
            }
            catch (Exception exception) {
                int n3 = -1;
                return n3;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    return -1;
                }
            }
            object = null;
            try {
                object = new BufferedWriter(new FileWriter(string2, false));
                for (String string3 : arrayList) {
                    ((Writer)object).write(string3 + "\r\n");
                }
                ((Writer)object).write(string + ":" + Integer.toString(n) + "\r\n");
                return 0;
            }
            catch (Exception exception) {
                int n4 = -1;
                return n4;
            }
            finally {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            return -1;
        }
    }

    public static void updateSelectedOpticalSetting() {
        InterSpecPanel.cmb_Optical_Settings_Inter_Spec.setSelectedIndex(InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getItemCount() - 1);
        SpectroscopyPanel.cmb_Optical_Settings_Spec.setSelectedIndex(SpectroscopyPanel.cmb_Optical_Settings_Spec.getItemCount() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeGraphFile(double[] dArray, double[] dArray2, String string, String string2) {
        Writer writer = null;
        try {
            int n;
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "utf-8"));
            writer.write(string2);
            writer.write("\n");
            int n2 = dArray.length < dArray2.length ? dArray.length : dArray2.length;
            for (n = 0; n < n2; ++n) {
                writer.write(Double.toString(dArray[n]) + "\t" + Double.toString(dArray2[n]));
                writer.write("\n");
            }
            n = 1;
            return n != 0;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
    }

    static double[] switch_NM_CM(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = 1.0E7 / dArray[i];
        }
        return dArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double[][] loadGraphDataFromFile(String string) {
        int n;
        Object object;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = bufferedReader.readLine();
            if (((String)object).contains("y_Axis:Absorbance")) {
                SpectroscopyPanel.rdbtn_Absorbance.setSelected(true);
                SpectroscopyPanel.rdbtn_Refl_Trans.setSelected(false);
            } else if (((String)object).contains("y_Axis:%Transmittance") || ((String)object).contains("y_Axis:%Reflectance")) {
                SpectroscopyPanel.rdbtn_Refl_Trans.setSelected(true);
                SpectroscopyPanel.rdbtn_Absorbance.setSelected(false);
            }
            if (((String)object).contains("x_Axis:Wavenumber (cm-1)")) {
                SpectroscopyPanel.rdbtn_cm_Spec.setSelected(true);
                SpectroscopyPanel.rdbtn_nm_Spec.setSelected(false);
                InterSpecPanel.rdbtn_cm_Inter_Spec.setSelected(true);
                InterSpecPanel.rdbtn_nm_Inter_Spec.setSelected(false);
            } else if (((String)object).contains("x_Axis:Wavelength (nm)")) {
                SpectroscopyPanel.rdbtn_nm_Spec.setSelected(true);
                SpectroscopyPanel.rdbtn_nm_Spec.setSelected(false);
                InterSpecPanel.rdbtn_nm_Inter_Spec.setSelected(true);
                InterSpecPanel.rdbtn_cm_Inter_Spec.setSelected(false);
            }
            while ((object = bufferedReader.readLine()) != null) {
                String[] stringArray = ((String)object).split("\t");
                if (stringArray.length != 2) continue;
                arrayList.add(Double.parseDouble(stringArray[0]));
                arrayList2.add(Double.parseDouble(stringArray[1]));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            JOptionPane.showMessageDialog(null, exception.getMessage(), "Load error", 0);
            double[][] dArray = null;
            return dArray;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        object = new double[2][];
        object[0] = new double[arrayList.size()];
        object[1] = new double[arrayList2.size()];
        for (n = 0; n < ((Object)object[0]).length; ++n) {
            object[0][n] = (Double)arrayList.get(n);
        }
        for (n = 0; n < ((Object)object[1]).length; ++n) {
            object[1][n] = (Double)arrayList2.get(n);
        }
        arrayList = null;
        arrayList2 = null;
        return object;
    }

    public static boolean checkEmptyDirectory(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return file.list().length <= 0;
        }
        return false;
    }

    public static double[] convertRefltoAbs(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = -Math.log10(dArray[i] / 100.0);
        }
        return dArray2;
    }

    public static double[] convertAbstoRefl(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = 100.0 * Math.pow(10.0, -dArray[i]);
        }
        return dArray2;
    }

    public static double[] convertDataToT(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] * 100.0;
        }
        return dArray2;
    }

    public static String[] readOptions() {
        String[] stringArray;
        block5: {
            String[] stringArray2 = null;
            stringArray = null;
            try {
                if (!moduleID.equals("")) {
                    int n;
                    String string = p3Constants.getPath((String)OPTIONS_PATH) + File.separatorChar + moduleID;
                    File file = new File(string);
                    File[] fileArray = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() && !file.getName().equals(".svn");
                        }
                    });
                    stringArray2 = new String[fileArray.length];
                    for (n = 0; n < fileArray.length; ++n) {
                        stringArray2[n] = fileArray[n].getName();
                    }
                    string = string + File.separatorChar + stringArray2[0];
                    file = new File(string);
                    fileArray = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() && !file.getName().equals(".svn");
                        }
                    });
                    stringArray = new String[fileArray.length];
                    n = 0;
                    for (int i = fileArray.length - 1; i >= 0; --i) {
                        stringArray[n] = fileArray[i].getName();
                        ++n;
                    }
                    break block5;
                }
                return new String[]{""};
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readOpticalSettings() {
        try {
            String string = p3AppManagerUtils.formatString((String)p3Constants.getPath((String)p3Constants.OPTICAL_SETTINGS_FILE_PATH), (Object[])new Object[]{moduleID});
            ArrayList<String> arrayList = new ArrayList<String>();
            File file = new File(string);
            if (!file.exists()) return arrayList.toArray(new String[arrayList.size()]);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains(":")) continue;
                    string2 = string2.split(":")[0];
                    arrayList.add(string2);
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            catch (Exception exception) {
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception4) {
                    return null;
                }
            }
        }
        catch (Exception exception3) {
            logger.error((Object)exception3.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOpticalSetting(String string) {
        try {
            String string2 = p3AppManagerUtils.formatString((String)p3Constants.getPath((String)p3Constants.OPTICAL_SETTINGS_FILE_PATH), (Object[])new Object[]{moduleID});
            ArrayList<String> arrayList = new ArrayList<String>();
            File file = new File(string2);
            if (file.exists()) {
                Object object;
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(string2));
                    object = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        if (((String)object).split(":")[0].trim().equals(string)) continue;
                        arrayList.add((String)object);
                    }
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                object = null;
                try {
                    object = new BufferedWriter(new FileWriter(string2, false));
                    for (String string3 : arrayList) {
                        ((Writer)object).write(string3 + "\r\n");
                    }
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    try {
                        ((BufferedWriter)object).close();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
            if (InterSpecPanel.lastOpticalSettingsSelected.equals(string) || SpectroscopyPanel.lastOpticalSettingsSelected.equals(string)) {
                InterSpecPanel.lastOpticalSettingsSelected = "";
                SpectroscopyPanel.lastOpticalSettingsSelected = "";
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
        }
    }

    public static String[] readStandardCalibrators() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            String string = p3Constants.getPath((String)p3Constants.STANDARD_CALIBRATORS_FOLDER_PATH);
            File file = new File(string);
            File[] fileArray = file.listFiles();
            stringArray = new String[fileArray.length];
            int n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].getName().contains(".txt")) continue;
                stringArray[n] = fileArray[i].getName().replace(".txt", "");
                ++n;
            }
            stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
        }
        return stringArray2;
    }

    public static void boardReadyRoutine(boolean bl) {
        if (bl) {
            SpectroscopyPanel.cmb_Optical_Settings_Spec.setEnabled(true);
            SpectroscopyPanel.cmb_Resolution_Spec.setEnabled(true);
            SpectroscopyPanel.btn_Run_Background.setEnabled(true);
            SpectroscopyPanel.btn_Run_Spec.setEnabled(true);
            SpectroscopyPanel.btn_Stop_Spec.setEnabled(true);
            SpectroscopyPanel.rdbtn_SingleRun_Spec.setEnabled(true);
            SpectroscopyPanel.rdbtn_ContRun_Spec.setEnabled(true);
            SpectroscopyPanel.btn_DeleteOpticalOption_Spec.setEnabled(true);
            SpectroscopyPanel.btn_SaveGraphs_Spec.setEnabled(true);
            SpectroscopyPanel.btn_LoadGraphs_Spec.setEnabled(true);
            InterSpecPanel.cmb_Optical_Settings_Inter_Spec.setEnabled(true);
            InterSpecPanel.cmb_Resolution_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_Run_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_Stop_Inter_Spec.setEnabled(true);
            InterSpecPanel.rdbtn_SingleRun_Inter_Spec.setEnabled(true);
            InterSpecPanel.rdbtn_ContRun_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_DeleteOpticalOption_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_SaveGraphs_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_LoadGraphs_Inter_Spec.setEnabled(true);
            InterSpecPanel.cmb_Apodization_Inter_Spec.setEnabled(true);
            InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_GainAdjustmentPanel_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_WavelengthWavenumberCalibration_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_WriteSettings_Inter_Spec.setEnabled(true);
            InterSpecPanel.btn_RestoreDefault_Inter_Spec.setEnabled(true);
            SpectroscopyPanel.cmb_Apodization_Spec.setEnabled(true);
            SpectroscopyPanel.cmb_ZeroPadding_Spec.setEnabled(true);
            SpectroscopyPanel.btn_GainAdjustmentPanel_Spec.setEnabled(true);
            SpectroscopyPanel.btn_WavelengthWavenumberCalibration_Spec.setEnabled(true);
            SpectroscopyPanel.btn_WriteSettings_Spec.setEnabled(true);
            SpectroscopyPanel.btn_RestoreDefault_spec.setEnabled(true);
            chb_SleepAction_menuBar.setEnabled(true);
            chb_PowerOff_menuBar.setEnabled(true);
        } else {
            SpectroscopyPanel.cmb_Optical_Settings_Spec.setEnabled(false);
            SpectroscopyPanel.cmb_Resolution_Spec.setEnabled(false);
            SpectroscopyPanel.btn_Run_Background.setEnabled(false);
            SpectroscopyPanel.btn_Run_Spec.setEnabled(false);
            SpectroscopyPanel.rdbtn_SingleRun_Spec.setEnabled(false);
            SpectroscopyPanel.rdbtn_ContRun_Spec.setEnabled(false);
            SpectroscopyPanel.cmb_Apodization_Spec.setEnabled(false);
            SpectroscopyPanel.cmb_ZeroPadding_Spec.setEnabled(false);
            SpectroscopyPanel.btn_GainAdjustmentPanel_Spec.setEnabled(false);
            SpectroscopyPanel.btn_WavelengthWavenumberCalibration_Spec.setEnabled(false);
            SpectroscopyPanel.btn_WriteSettings_Spec.setEnabled(false);
            SpectroscopyPanel.btn_RestoreDefault_spec.setEnabled(false);
            SpectroscopyPanel.btn_DeleteOpticalOption_Spec.setEnabled(false);
            SpectroscopyPanel.btn_SaveGraphs_Spec.setEnabled(false);
            SpectroscopyPanel.btn_LoadGraphs_Spec.setEnabled(false);
            InterSpecPanel.cmb_Optical_Settings_Inter_Spec.setEnabled(false);
            InterSpecPanel.cmb_Resolution_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_Run_Inter_Spec.setEnabled(false);
            InterSpecPanel.rdbtn_SingleRun_Inter_Spec.setEnabled(false);
            InterSpecPanel.rdbtn_ContRun_Inter_Spec.setEnabled(false);
            InterSpecPanel.cmb_Apodization_Inter_Spec.setEnabled(false);
            InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_GainAdjustmentPanel_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_WavelengthWavenumberCalibration_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_WriteSettings_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_RestoreDefault_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_DeleteOpticalOption_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_SaveGraphs_Inter_Spec.setEnabled(false);
            InterSpecPanel.btn_LoadGraphs_Inter_Spec.setEnabled(false);
            chb_SleepAction_menuBar.setEnabled(false);
            chb_PowerOff_menuBar.setEnabled(false);
        }
        UserInterface.ShowAdvancedSettings();
    }

    public static void displayInterSpecOpticalSettings() {
        logger.info((Object)"Reading InterSpec optical settings");
        InterSpecPanel.cmb_Optical_Settings_Inter_Spec.removeAllItems();
        InterSpecPanel.cmb_Optical_Settings_Inter_Spec.addItem("Default");
        String[] stringArray = UserInterface.readOpticalSettings();
        if (stringArray != null) {
            for (String string : stringArray) {
                InterSpecPanel.cmb_Optical_Settings_Inter_Spec.addItem(string);
            }
        }
    }

    public static void displaySpecOpticalSettings() {
        logger.info((Object)"Reading Spec optical settings");
        SpectroscopyPanel.cmb_Optical_Settings_Spec.removeAllItems();
        SpectroscopyPanel.cmb_Optical_Settings_Spec.addItem("Default");
        String[] stringArray = UserInterface.readOpticalSettings();
        if (stringArray != null) {
            for (String string : stringArray) {
                SpectroscopyPanel.cmb_Optical_Settings_Spec.addItem(string);
            }
        }
    }

    public static void displayCommonWVN() {
        String[] stringArray = p3Constants.commonWavenumberOptions;
        SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.removeAllItems();
        InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.removeAllItems();
        for (String string : stringArray) {
            SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.addItem(string);
            InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.addItem(string);
        }
    }

    public static void displayStandardCalibrators() {
        String[] stringArray = UserInterface.readStandardCalibrators();
        if (stringArray != null) {
            try {
                WL_WN_CalibrationPanel.cmb_StandardCalibrator_WL_Calib.removeAllItems();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                WL_WN_CalibrationPanel.cmb_StandardCalibrator_WL_Calib.addItem("Choose Material ...");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String string : stringArray) {
                try {
                    WL_WN_CalibrationPanel.cmb_StandardCalibrator_WL_Calib.addItem(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                WL_WN_CalibrationPanel.cmb_StandardCalibrator_WL_Calib.setSelectedIndex(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean addNewStandardCalibrator(String string) {
        string = string.replace(" ", "");
        if (!(string = string.replace("\t", "")).contains("{") || !string.contains("}")) {
            return false;
        }
        int n = string.indexOf("{");
        int n2 = string.indexOf("}");
        String string2 = string.substring(0, n);
        if (!p3AppManagerUtils.isFilenameValid((String)string2)) {
            return false;
        }
        String string3 = string.substring(n + 1, n2);
        String[] stringArray = string3.split(",");
        for (String string4 : stringArray) {
            try {
                Double.parseDouble(string4);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(p3Constants.getPath((String)p3Constants.STANDARD_CALIBRATORS_FOLDER_PATH) + File.separatorChar + string2 + ".txt"));
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i] + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public static void restoreSequence() {
        checkDeviceStatusThreadStop = true;
        while (!UserInterface.acquireDeviceToken()) {
        }
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.restoreDefaultSettings(new String[]{"All"});
        if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
            JOptionPane.showMessageDialog(null, "Restore to default failed to start: : " + p3AppManagerStatus2, "Restore Default Settings", 0);
            if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                checkDeviceStatusThreadStop = false;
                colorLabel.setForeground(Color.red);
                colorLabel.setBackground(Color.red);
            }
            UserInterface.releaseDeviceToken();
        } else {
            statusLabel.setText("Restoring to default started. Please wait...");
            colorLabel.setForeground(Color.yellow);
            colorLabel.setBackground(Color.yellow);
            UserInterface.boardReadyRoutine(false);
        }
        frmMain.revalidate();
        frmMain.repaint();
    }

    public static void burnSequence() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Burn Gain Settings");
        JRadioButton jRadioButton2 = new JRadioButton("Burn Self Correction Settings");
        JRadioButton jRadioButton3 = new JRadioButton("Burn Reference Material Correction Settings");
        JRadioButton jRadioButton4 = new JRadioButton("Burn All Settings");
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][][]", ""));
        jPanel.add((Component)jRadioButton, "cell 0 0 1 1");
        jPanel.add((Component)jRadioButton2, "cell 0 1 1 1");
        jPanel.add((Component)jRadioButton3, "cell 0 2 1 1");
        jPanel.add((Component)jRadioButton4, "cell 0 3 1 1");
        int n = JOptionPane.showConfirmDialog(null, jPanel, "Burn Settings", 2);
        String[] stringArray = new String[1];
        if (jRadioButton.isSelected()) {
            stringArray[0] = "0";
        } else if (jRadioButton2.isSelected()) {
            stringArray[0] = "1";
        } else if (jRadioButton3.isSelected()) {
            stringArray[0] = "2";
        } else if (jRadioButton4.isSelected()) {
            stringArray[0] = "3";
        }
        if (n == 0) {
            checkDeviceStatusThreadStop = true;
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.burnSpecificSettings(stringArray);
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                JOptionPane.showMessageDialog(null, "Burn Settings failed to start: : " + p3AppManagerStatus2, "Burn Settings", 0);
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                UserInterface.releaseDeviceToken();
            } else {
                statusLabel.setText("Burn Settings started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
                UserInterface.boardReadyRoutine(false);
            }
            frmMain.revalidate();
            frmMain.repaint();
        }
    }

    public static void GainAdjustment() {
        logger.info((Object)"GainAdjustment function started");
        try {
            checkDeviceStatusThreadStop = true;
            progressTime = 10.0;
            progressPar.setValue(0);
            logger.info((Object)"runSpecGainAdjBG function started");
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.runSpecGainAdjBG(new String[]{Double.toString(10.0)});
            logger.info((Object)"runSpecGainAdjBG function finished");
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                JOptionPane.showMessageDialog(null, "Run failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Gain Adjustment", 0);
                UserInterface.releaseDeviceToken();
            } else {
                logger.info((Object)"disabling panel GUI fields started");
                UserInterface.boardReadyRoutine(false);
                logger.info((Object)"disabling panel GUI fields finished");
                statusLabel.setText(" Gain Adjustment function started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
            }
        }
        catch (Exception exception) {
            colorLabel.setForeground(Color.red);
            colorLabel.setBackground(Color.red);
            JOptionPane.showMessageDialog(null, "Run failed to start. Please check inputs.", "Gain Adjustment", 0);
        }
        frmMain.revalidate();
        frmMain.repaint();
    }

    public static String convertErrorCodesToMessages(int n) {
        switch (n) {
            case 1: {
                return "Error Code : " + n + "\n NeoSpectra Micro kit is busy. \n Please wait until the current operation is done.";
            }
            case 2: {
                return "Error Code : " + n + "\n SpectroMOST Micro does not detect any connected NeoSpectra Micro kit.";
            }
            case 3: {
                return "Error Code : " + n + "\n NeoSpectra Micro kit is not initialized. \n Please disconnect and reconnect your kit.";
            }
            case 4: {
                return "Error Code : " + n + "\n Unknown error. \n Please contact Si-Ware Systems.";
            }
            case 7: {
                return "Error Code : " + n + "\n Error in loading configuration files. \n Please contact Si-Ware Systems.";
            }
            case 8: {
                return "Error Code : " + n + "\n Error in configuration files' format. \n Please contact Si-Ware Systems.";
            }
            case 11: {
                return "Error Code : " + n + "\n Invalid scan time. \n Please type a valid entry between 10 milliseconds and 28 seconds.";
            }
            case 23: {
                return "Error Code : " + n + "\n Error in configuration files' format. \n Please contact Si-Ware Systems.";
            }
            case 24: {
                return "Error Code : " + n + "\n Internal error in DSP. \n Please contact Si-Ware Systems.";
            }
            case 25: {
                return "Error Code : " + n + "\n Internal error in DSP. \n Please contact Si-Ware Systems.";
            }
            case 26: {
                return "Error Code : " + n + "\n Internal error in DSP. \n Please contact Si-Ware Systems.";
            }
            case 27: {
                return "Error Code : " + n + "\n Internal error in DSP. \n Please contact Si-Ware Systems.";
            }
            case 28: {
                return "Error Code : " + n + "\n Error in updating configuration files.\n Please contact Si-Ware Systems.";
            }
            case 29: {
                return "Error Code : " + n + "\n Error in saving data of background measurement. \n Please retry.";
            }
            case 30: {
                return "Error Code : " + n + "\n Internal error in DSP. \n Please contact Si-Ware Systems.";
            }
            case 31: {
                return "Error Code : " + n + "\n Invalid run parameters. \n Please use valid entries.";
            }
            case 32: {
                return "Error Code : " + n + "\n The scan time of the background is different than the scan time of sample measurement. \n Please take a new background measurement.";
            }
            case 33: {
                return "Error Code : " + n + "\n No valid background measurement found. \n Please take a new background measurement.";
            }
            case 34: {
                return "Error Code : " + n + "\n Error occurred during saving data. \n Please try saving in a different directory.";
            }
            case 35: {
                return "Error Code : " + n + "\n Error occurred during saving PSD data.\n Please try saving in a different directory.";
            }
            case 36: {
                return "Error Code : " + n + "\n Error occurred during saving spectrum data.\n Please try saving in a different directory.";
            }
            case 37: {
                return "Error Code : " + n + "\n Error occurred while creating folder to save measurement data. \n Please try creating the folder in a different directory.";
            }
            case 38: {
                return "Error Code : " + n + "\n Invalid Apodization Window. \n Please use a valid apodization window.";
            }
            case 42: {
                return "Error Code : " + n + "\n Error occurred during initialization of NeoSpectra Micro kit. \n Please disconnect and reconnect your kit.";
            }
            case 43: {
                return "Error Code : " + n + "\n Error occurred during initialization of NeoSpectra Micro kit. \n Please disconnect and reconnect your kit.";
            }
            case 50: {
                return "Error Code : " + n + "\n Error occurred during streaming from NeoSpectra Micro kit. \n Please disconnect and reconnect your kit.";
            }
            case 51: {
                return "Error Code : " + n + "\n Error occurred during streaming from NeoSpectra Micro kit. \n Please disconnect and reconnect your kit.";
            }
            case 52: {
                return "Error Code : " + n + "\n Error occurred during result return. \n Please make a new measurement.";
            }
            case 53: {
                return "Error Code : " + n + "\n Invalid action !!";
            }
            case 54: {
                return "Error Code : " + n + "\n Invalid device is connected.";
            }
            case 55: {
                return "Error Code : " + n + "\n Internal threading error occurred. \n Please make a new measurement. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 60: {
                return "Error Code : " + n + "\n Error occurred during the setup of actuation settings. \n Please make a new measurement. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 61: {
                return "Error Code : " + n + "\n Actuation setting is turned off. \n Please make a new measurement. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 62: {
                return "Error Code : " + n + "\n Internal error occurred. \n Please contact Si-Ware Systems.";
            }
            case 110: {
                return "Error Code : " + n + "\n Internal error occurred while running adaptive gain. \n Please contact Si-Ware Systems.";
            }
            case 111: {
                return "Error Code : " + n + "\n Internal error occurred during reading registers from ASIC chip. \n Please contact Si-Ware Systems.";
            }
            case 112: {
                return "Error Code : " + n + " Failed to start. \nCorrection profile doesn't exist. \nPlease contact Si-Ware Systems.";
            }
            case 113: {
                return "Error Code : " + n + "Failed to write optical gain settings. \n Please try again. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 114: {
                return "Error Code : " + n + "Failed to create optical gain settings file. \n Please try again. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 115: {
                return "Error Code : " + n + "Failed to load standard calibrator file. \n Please try again. \n If the error persists, please contact Si-Ware Systems.";
            }
            case 116: {
                return "Error Code : " + n + "\n Internal error occurred while running wavelength calibration. \n Please contact Si-Ware Systems.";
            }
            case 117: {
                return "Error Code : " + n + "SpectroMOST Micro didn't find any data to update. \n Please take a measurement first.";
            }
            case 118: {
                return "Error Code : " + n + "Internal error while updating results after changing FFT settings. \n Please contact Si-Ware Systems.";
            }
            case 119: {
                return "Error Code : " + n + "\nSpectroMOST Micro didn't find the selected Optical gain option. \nPlease contact Si-Ware Systems.";
            }
        }
        return "Error Code : " + n + "\nError occurred during result return.";
    }

    public static String convertErrorCodesToMessages(p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        return UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2.getNumVal());
    }

    public static void ShowAdvancedSettings() {
        if (chb_Advanced_menuBar.isSelected()) {
            SpectroscopyPanel.lbl_Apodization_Spec.setVisible(true);
            SpectroscopyPanel.lbl_ZeroPadding_Spec.setVisible(true);
            SpectroscopyPanel.separatorV1_Spec.setVisible(true);
            SpectroscopyPanel.lbl_FFT_Settings_Spec.setVisible(true);
            SpectroscopyPanel.lbl_advancedSettings_Spec.setVisible(true);
            SpectroscopyPanel.cmb_Apodization_Spec.setVisible(true);
            SpectroscopyPanel.cmb_ZeroPadding_Spec.setVisible(true);
            SpectroscopyPanel.btn_GainAdjustmentPanel_Spec.setVisible(true);
            SpectroscopyPanel.btn_WavelengthWavenumberCalibration_Spec.setVisible(true);
            SpectroscopyPanel.btn_WriteSettings_Spec.setVisible(true);
            SpectroscopyPanel.btn_RestoreDefault_spec.setVisible(true);
            InterSpecPanel.lbl_Apodization_Inter_Spec.setVisible(true);
            InterSpecPanel.lbl_ZeroPadding_Inter_Spec.setVisible(true);
            InterSpecPanel.separatorV1_Inter_Spec.setVisible(true);
            InterSpecPanel.lbl_FFT_Settings_Inter_Spec.setVisible(true);
            InterSpecPanel.lbl_advancedSettings_Inter_Spec.setVisible(true);
            InterSpecPanel.cmb_Apodization_Inter_Spec.setVisible(true);
            InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setVisible(true);
            InterSpecPanel.btn_GainAdjustmentPanel_Inter_Spec.setVisible(true);
            InterSpecPanel.btn_WavelengthWavenumberCalibration_Inter_Spec.setVisible(true);
            InterSpecPanel.btn_WriteSettings_Inter_Spec.setVisible(true);
            InterSpecPanel.btn_RestoreDefault_Inter_Spec.setVisible(true);
        } else {
            SpectroscopyPanel.lbl_Apodization_Spec.setVisible(false);
            SpectroscopyPanel.lbl_ZeroPadding_Spec.setVisible(false);
            SpectroscopyPanel.separatorV1_Spec.setVisible(false);
            SpectroscopyPanel.lbl_FFT_Settings_Spec.setVisible(false);
            SpectroscopyPanel.lbl_advancedSettings_Spec.setVisible(false);
            SpectroscopyPanel.cmb_Apodization_Spec.setVisible(false);
            SpectroscopyPanel.cmb_ZeroPadding_Spec.setVisible(false);
            SpectroscopyPanel.btn_GainAdjustmentPanel_Spec.setVisible(false);
            SpectroscopyPanel.btn_WavelengthWavenumberCalibration_Spec.setVisible(false);
            SpectroscopyPanel.btn_WriteSettings_Spec.setVisible(false);
            SpectroscopyPanel.btn_RestoreDefault_spec.setVisible(false);
            InterSpecPanel.lbl_Apodization_Inter_Spec.setVisible(false);
            InterSpecPanel.lbl_ZeroPadding_Inter_Spec.setVisible(false);
            InterSpecPanel.separatorV1_Inter_Spec.setVisible(false);
            InterSpecPanel.lbl_FFT_Settings_Inter_Spec.setVisible(false);
            InterSpecPanel.lbl_advancedSettings_Inter_Spec.setVisible(false);
            InterSpecPanel.cmb_Apodization_Inter_Spec.setVisible(false);
            InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setVisible(false);
            InterSpecPanel.btn_GainAdjustmentPanel_Inter_Spec.setVisible(false);
            InterSpecPanel.btn_WavelengthWavenumberCalibration_Inter_Spec.setVisible(false);
            InterSpecPanel.btn_WriteSettings_Inter_Spec.setVisible(false);
            InterSpecPanel.btn_RestoreDefault_Inter_Spec.setVisible(false);
        }
    }

    public static void runSleepAction() {
        if (chb_SleepAction_menuBar.isSelected()) {
            checkDeviceStatusThreadStop = true;
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.sleepAction();
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                JOptionPane.showMessageDialog(null, "Sleep Action failed to start: : " + p3AppManagerStatus2, "Sleep Action", 0);
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                UserInterface.releaseDeviceToken();
            } else {
                statusLabel.setText("Sleep Action started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
                UserInterface.boardReadyRoutine(false);
            }
            frmMain.revalidate();
            frmMain.repaint();
        } else {
            checkDeviceStatusThreadStop = true;
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus3 = applicationManager.wakeUpAction();
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus3) {
                JOptionPane.showMessageDialog(null, "Wake up Action failed to start: : " + p3AppManagerStatus3, "Wake up Action", 0);
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus3) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                UserInterface.releaseDeviceToken();
            } else {
                statusLabel.setText("Wake up Action started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
                UserInterface.boardReadyRoutine(false);
            }
            frmMain.revalidate();
            frmMain.repaint();
        }
    }

    public static void runPowerOff() {
        if (chb_PowerOff_menuBar.isSelected()) {
            checkDeviceStatusThreadStop = true;
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = applicationManager.powerOff();
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                JOptionPane.showMessageDialog(null, "Power off failed to start: : " + p3AppManagerStatus2, "Power off", 0);
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                UserInterface.releaseDeviceToken();
            } else {
                statusLabel.setText("Power Off started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
                UserInterface.boardReadyRoutine(false);
            }
            frmMain.revalidate();
            frmMain.repaint();
        } else {
            checkDeviceStatusThreadStop = true;
            while (!UserInterface.acquireDeviceToken()) {
            }
            p3Enumerations.p3AppManagerStatus p3AppManagerStatus3 = applicationManager.powerOn();
            if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus3) {
                JOptionPane.showMessageDialog(null, "Power on failed to start: : " + p3AppManagerStatus3, "Power on", 0);
                if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus3) {
                    checkDeviceStatusThreadStop = false;
                    colorLabel.setForeground(Color.red);
                    colorLabel.setBackground(Color.red);
                }
                UserInterface.releaseDeviceToken();
            } else {
                statusLabel.setText("Power on started. Please wait...");
                colorLabel.setForeground(Color.yellow);
                colorLabel.setBackground(Color.yellow);
                UserInterface.boardReadyRoutine(false);
            }
            frmMain.revalidate();
            frmMain.repaint();
        }
    }

    static {
        switchingDeviceFinished = false;
        regFileToWrite = "";
        stopEnablingButtons = false;
        actState = false;
        isContinuousRun = false;
        stopContinuousRun = false;
        APPLICATION_WORKING_DIRECTORY = p3Constants.Original_APPLICATION_WORKING_DIRECTORY;
        IMAGES_DIRECTORY = APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Data" + File.separatorChar + "Images";
        LOGO_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "NeoSpectraLogo.png";
        RUN_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "run_new.png";
        RUN_BG_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "run_bg.png";
        SAVE_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "save.png";
        LOAD_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "load.png";
        CAPTURE_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "capture.png";
        DELETE_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "delete.png";
        STOP_IMAGE_PATH = IMAGES_DIRECTORY + File.separatorChar + "stop_new.png";
        ICON_PATH = IMAGES_DIRECTORY + File.separatorChar + "Icon.png";
        GRAPH_FILES_FOLDER_PATH = APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Temp_Graphs";
        OPTIONS_PATH = APPLICATION_WORKING_DIRECTORY + File.separatorChar + "Conf_Files";
        defaultDirectorySaveLoad = "";
        fileNameToSave = "";
        moduleID = "";
        DeviceToken = false;
        checkDeviceStatusThreadStop = false;
        progressTime = -1.0;
        boardRestarted = true;
    }
}

