/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import sws.p3AppManager_micro.utils.p3AppManagerException;
import sws.p3AppManager_micro.utils.p3AppManagerNotification;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.p3AppManager_micro.utils.p3Constants;
import sws.p3AppManager_micro.utils.p3Enumerations;
import sws.spectromost.InterSpecPanel;
import sws.spectromost.SaveGraphsPanel;
import sws.spectromost.UserInterface;
import sws.spectromost.WL_WN_CalibrationPanel;
import sws.spectromost.jfreechart.XYLineChart;

public class SpectroscopyPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(SpectroscopyPanel.class);
    public static final String SPECTRUM_REFL_PATH_TEMPLATE = p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH) + File.separatorChar + "Measurement_Perc_{0}.Spectrum";
    public static final String SPECTRUM_ABS_PATH_TEMPLATE = p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH) + File.separatorChar + "Measurement_Abs_{0}.Spectrum";
    public static final String SPECTRUM_FILE_X_AXIS_CM = "x_Axis:Wavenumber (cm-1)";
    public static final String SPECTRUM_FILE_X_AXIS_NM = "x_Axis:Wavelength (nm)";
    public static final String SPECTRUMFILE_Y_AXIS_R_T = "y_Axis:%Reflectance or Transmittance";
    public static final String SPECTRUMFILE_Y_AXIS_A = "y_Axis:Absorbance";
    public static boolean capture_Displayed_Spectroscopy = false;
    private static boolean clearingGraphsInProgress = false;
    static String backgroundTime;
    public static String lastResolutionSelected;
    public static String lastOpticalSettingsSelected;
    public static String lastZeroPaddingSelected;
    public static String lastWindowSelected;
    public static String lastCommonWavenumberSelected;
    private String AutoSavePath_Spectroscopy = "";
    static Label lbl_moduleID_Spec;
    public static final JCheckBox chb_AutoSave_Spectroscopy;
    public static final JCheckBox chb_EnableLinearInterpolation_Spectroscopy;
    public static JRadioButton rdbtn_Absorbance;
    public static JRadioButton rdbtn_Refl_Trans;
    public static JRadioButton rdbtn_nm_Spec;
    public static JRadioButton rdbtn_cm_Spec;
    public static JRadioButton rdbtn_SingleRun_Spec;
    public static JRadioButton rdbtn_ContRun_Spec;
    static XYLineChart spectroscopyChartReflTrans_NM;
    static XYLineChart spectroscopyChartAbs_NM;
    static XYLineChart spectroscopyChartReflTrans_CM;
    static XYLineChart spectroscopyChartAbs_CM;
    static ChartPanel spectroscopyChartPanel;
    static JButton btn_Run_Spec;
    static JButton btn_Capture_Spec;
    static JButton btn_ClearGraphs_Spec;
    static JButton btn_LoadGraphs_Spec;
    static JButton btn_Run_Background;
    static JButton btn_SaveGraphs_Spec;
    static JButton btn_Stop_Spec;
    static JButton btn_GainAdjustmentPanel_Spec;
    static JButton btn_WavelengthWavenumberCalibration_Spec;
    static JButton btn_WriteSettings_Spec;
    static JButton btn_RestoreDefault_spec;
    static JButton btn_DeleteOpticalOption_Spec;
    static JComboBox<String> cmb_Apodization_Spec;
    static JComboBox<String> cmb_ZeroPadding_Spec;
    static JComboBox<String> cmb_Optical_Settings_Spec;
    static JComboBox<String> cmb_Resolution_Spec;
    static JComboBox<String> cmb_Wavenumber_No_Of_Points_Spec;
    static JFormattedTextField txt_RunTime_Spec;
    static Component horizontalSpring;
    static Label lbl_FFT_Settings_Spec;
    static Label lbl_advancedSettings_Spec;
    static JSeparator separatorV1_Spec;
    static Label lbl_Apodization_Spec;
    static Label lbl_ZeroPadding_Spec;
    public static final double SPECTRUM_X_NM_MIN = 1285.0;
    public static final double SPECTRUM_X_NM_MAX = 2615.0;
    public static final double SPECTRUM_X_CM_MIN = 3700.0;
    public static final double SPECTRUM_X_CM_MAX = 7795.0;
    public static final double SPECTRUM_Y_REF_MIN = 90.0;
    public static final double SPECTRUM_Y_REF_MAX = 110.0;
    public static final double SPECTRUM_Y_ABS_MIN = 0.0;
    public static final double SPECTRUM_Y_ABS_MAX = 1.2;
    private static int measurementCount_Spectroscopy;
    private boolean genuineAction = false;

    public SpectroscopyPanel() {
        this.initialize();
    }

    public void initialize() {
        BufferedImage bufferedImage;
        Image image;
        File file;
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(new Color(176, 196, 222));
        this.setLayout((LayoutManager)new MigLayout("", "[90.00:90.00:90.00][45.00:45.00:45.00][45.00:45.00:45.00][30.00:30.00:30.00][30.00:30.00:30.00][30.00:30.00:30.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00][grow,fill][][][][][grow,fill]", "[][][][][][][][][][][][][][][][][][25.00:25.00:25.00][20:n][][][][][][][][][][][][grow,fill]"));
        Label label = new Label("NeoSpectra Micro kit Info");
        label.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label, "cell 0 0 6 1");
        Label label2 = new Label("Kit ID");
        label2.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label2, "cell 0 1 2 1,growx");
        lbl_moduleID_Spec = new Label(UserInterface.moduleID);
        lbl_moduleID_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_moduleID_Spec, "cell 2 1 2 1,alignx right");
        JSeparator jSeparator = new JSeparator();
        this.add((Component)jSeparator, "cell 0 2 6 1,growx");
        Label label3 = new Label("Measurement Parameters");
        label3.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label3, "cell 0 3 6 1,growx");
        Label label4 = new Label("Scan Time");
        label4.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label4, "cell 0 4,growx");
        txt_RunTime_Spec = new JFormattedTextField();
        txt_RunTime_Spec.setEditable(true);
        txt_RunTime_Spec.setFont(new Font("Dialog", 1, 10));
        txt_RunTime_Spec.setText("2");
        txt_RunTime_Spec.setMinimumSize(new Dimension(110, SpectroscopyPanel.txt_RunTime_Spec.getPreferredSize().height));
        txt_RunTime_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.txt_RunTime_Spec.getPreferredSize().height));
        txt_RunTime_Spec.setPreferredSize(new Dimension(110, SpectroscopyPanel.txt_RunTime_Spec.getPreferredSize().height));
        this.add((Component)txt_RunTime_Spec, "cell 2 4 3 1,alignx left,growy");
        Label label5 = new Label("s");
        label5.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label5, "cell 5 4,growx");
        Label label6 = new Label("Optical Gain Settings");
        label6.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label6, "cell 0 5,growx");
        cmb_Optical_Settings_Spec = new JComboBox();
        cmb_Optical_Settings_Spec.setEnabled(false);
        cmb_Optical_Settings_Spec.setEditable(false);
        cmb_Optical_Settings_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Optical_Settings_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.cmb_Optical_Settings_Spec.getPreferredSize().height));
        this.add(cmb_Optical_Settings_Spec, "cell 2 5 3 1,growx");
        cmb_Optical_Settings_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                InterSpecPanel.cmb_Optical_Settings_Inter_Spec.setSelectedIndex(cmb_Optical_Settings_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                UserInterface.displaySpecOpticalSettings();
                UserInterface.displayInterSpecOpticalSettings();
            }
        });
        btn_DeleteOpticalOption_Spec = new JButton("");
        btn_DeleteOpticalOption_Spec.setEnabled(false);
        btn_DeleteOpticalOption_Spec.setVisible(true);
        btn_DeleteOpticalOption_Spec.setToolTipText("Delete the selected optical gain setting");
        btn_DeleteOpticalOption_Spec.setMaximumSize(new Dimension(30, SpectroscopyPanel.cmb_Optical_Settings_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Spec.setMinimumSize(new Dimension(30, SpectroscopyPanel.cmb_Optical_Settings_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Spec.setPreferredSize(new Dimension(30, SpectroscopyPanel.cmb_Optical_Settings_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (cmb_Optical_Settings_Spec.getSelectedItem().toString().equals("Default")) {
                    JOptionPane.showMessageDialog(null, "Default Option cannot be deleted!", "Delete optical gain", 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + cmb_Optical_Settings_Spec.getSelectedItem().toString() + " ?", "Delete optical gain", 0) == 1) {
                    return;
                }
                UserInterface.deleteOpticalSetting(cmb_Optical_Settings_Spec.getSelectedItem().toString());
                UserInterface.displaySpecOpticalSettings();
                UserInterface.displayInterSpecOpticalSettings();
            }
        });
        this.add((Component)btn_DeleteOpticalOption_Spec, "cell 5 5,grow");
        Label label7 = new Label("Resolution");
        label7.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label7, "cell 0 6,growx");
        cmb_Resolution_Spec = new JComboBox();
        cmb_Resolution_Spec.setEnabled(false);
        cmb_Resolution_Spec.setEditable(false);
        cmb_Resolution_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Resolution_Spec.addItem("16 nm");
        cmb_Resolution_Spec.addItem("10 nm");
        cmb_Resolution_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.cmb_Resolution_Spec.getPreferredSize().height));
        this.add(cmb_Resolution_Spec, "cell 2 6 3 1,growx");
        cmb_Resolution_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                InterSpecPanel.cmb_Resolution_Inter_Spec.setSelectedIndex(cmb_Resolution_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        Label label8 = new Label("Run Mode");
        label8.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label8, "cell 0 7,growx");
        ButtonGroup buttonGroup = new ButtonGroup();
        btn_Run_Background = new JButton("");
        btn_Run_Background.setEnabled(false);
        btn_Run_Background.setFont(new Font("Dialog", 0, 10));
        btn_Run_Background.setText("Background");
        btn_Run_Background.setVerticalTextPosition(3);
        btn_Run_Background.setHorizontalTextPosition(0);
        btn_Run_Background.setToolTipText("Run Background");
        btn_Run_Background.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    backgroundTime = String.valueOf(Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0);
                    UserInterface.checkDeviceStatusThreadStop = true;
                    try {
                        lastZeroPaddingSelected = String.valueOf(cmb_ZeroPadding_Spec.getSelectedIndex());
                        n = 0;
                        if (chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                            n = cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex() + 1;
                        }
                        lastCommonWavenumberSelected = String.valueOf(n);
                        lastWindowSelected = String.valueOf(cmb_Apodization_Spec.getSelectedIndex());
                        lastOpticalSettingsSelected = cmb_Optical_Settings_Spec.getSelectedItem().toString();
                        lastResolutionSelected = String.valueOf(cmb_Resolution_Spec.getSelectedIndex());
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage());
                        JOptionPane.showMessageDialog(null, "Run failed to start. Module setup failed!", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        return;
                    }
                    UserInterface.progressTime = Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0;
                    UserInterface.progressPar.setValue(0);
                    n = 0;
                    if (chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                        n = cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex() + 1;
                    }
                    while (!UserInterface.acquireDeviceToken()) {
                    }
                    p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.runSpec(new String[]{backgroundTime, "false", String.valueOf(cmb_Apodization_Spec.getSelectedIndex()), String.valueOf(cmb_ZeroPadding_Spec.getSelectedIndex()), UserInterface.getOpticalGainValue((String)cmb_Optical_Settings_Spec.getSelectedItem()), String.valueOf(n), Integer.toString(rdbtn_ContRun_Spec.isSelected() ? 1 : 0), Integer.toString(cmb_Resolution_Spec.getSelectedIndex())});
                    if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                        if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                            UserInterface.checkDeviceStatusThreadStop = false;
                        }
                        JOptionPane.showMessageDialog(null, "Run failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Run NeoSpectra Micro", 0);
                        UserInterface.releaseDeviceToken();
                    } else {
                        UserInterface.boardReadyRoutine(false);
                        UserInterface.statusLabel.setText("Run started. Please wait...");
                        UserInterface.colorLabel.setForeground(Color.yellow);
                        UserInterface.colorLabel.setBackground(Color.yellow);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    JOptionPane.showMessageDialog(null, "Run failed to start. \n Please make sure that the entries in measurement parameters are valid.", "Run NeoSpectra Micro", 0);
                }
                UserInterface.frmMain.revalidate();
                UserInterface.frmMain.repaint();
            }
        });
        rdbtn_SingleRun_Spec = new JRadioButton("Single");
        rdbtn_SingleRun_Spec.setEnabled(false);
        rdbtn_SingleRun_Spec.setFont(new Font("Dialog", 0, 10));
        rdbtn_SingleRun_Spec.setSelected(true);
        rdbtn_SingleRun_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                btn_Capture_Spec.setEnabled(false);
            }
        });
        this.add((Component)rdbtn_SingleRun_Spec, "cell 1 7 2 1,growx");
        buttonGroup.add(rdbtn_SingleRun_Spec);
        rdbtn_ContRun_Spec = new JRadioButton("Cont.");
        rdbtn_ContRun_Spec.setEnabled(false);
        rdbtn_ContRun_Spec.setFont(new Font("Dialog", 0, 10));
        rdbtn_ContRun_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                btn_Capture_Spec.setEnabled(true);
            }
        });
        this.add((Component)rdbtn_ContRun_Spec, "cell 3 7 3 1,growx");
        buttonGroup.add(rdbtn_ContRun_Spec);
        this.add((Component)btn_Run_Background, "cell 0 8,growx");
        btn_Run_Spec = new JButton();
        btn_Run_Spec.setEnabled(false);
        btn_Run_Spec.setFont(new Font("Dialog", 0, 10));
        btn_Run_Spec.setText("Run");
        btn_Run_Spec.setVerticalTextPosition(3);
        btn_Run_Spec.setHorizontalTextPosition(0);
        btn_Run_Spec.setToolTipText("Run");
        btn_Run_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.this.RunSampleSequence();
                try {
                    logger.info((Object)("Run_Spec Finished (With PowerUp) - Scan Time = " + String.valueOf(Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.add((Component)btn_Run_Spec, "cell 1 8 2 1,growx");
        btn_Stop_Spec = new JButton();
        btn_Stop_Spec.setEnabled(false);
        btn_Stop_Spec.setFont(new Font("Dialog", 0, 10));
        btn_Stop_Spec.setText("Stop");
        btn_Stop_Spec.setVerticalTextPosition(3);
        btn_Stop_Spec.setHorizontalTextPosition(0);
        btn_Stop_Spec.setToolTipText("Stop");
        btn_Stop_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopContinuousRun = true;
                UserInterface.isContinuousRun = false;
                UserInterface.statusLabel.setText("Stopping NeoSpectra Micro kit. Please wait...");
            }
        });
        this.add((Component)btn_Stop_Spec, "cell 3 8 3 1,growx");
        JSeparator jSeparator2 = new JSeparator();
        this.add((Component)jSeparator2, "cell 0 9 6 1,growx");
        Label label9 = new Label("Plots");
        label9.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label9, "cell 0 10,growx");
        btn_SaveGraphs_Spec = new JButton("");
        btn_SaveGraphs_Spec.setFont(new Font("Dialog", 0, 10));
        btn_SaveGraphs_Spec.setText("Save");
        btn_SaveGraphs_Spec.setVerticalTextPosition(3);
        btn_SaveGraphs_Spec.setHorizontalTextPosition(0);
        btn_SaveGraphs_Spec.setToolTipText("Save Plots");
        btn_SaveGraphs_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopEnablingButtons = true;
                UserInterface.boardReadyRoutine(false);
                btn_ClearGraphs_Spec.setEnabled(false);
                String[] stringArray = spectroscopyChartReflTrans_NM.getSeriesKeys();
                int n = stringArray.length;
                for (String string : stringArray) {
                    double[][] dArray = spectroscopyChartReflTrans_NM.getGraphData(string);
                    double[][] dArray2 = spectroscopyChartAbs_NM.getGraphData(string);
                    double[][] dArray3 = spectroscopyChartReflTrans_CM.getGraphData(string);
                    double[][] dArray4 = spectroscopyChartAbs_CM.getGraphData(string);
                    if (rdbtn_nm_Spec.isSelected()) {
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavelength (nm)\ty_Axis:%Reflectance or Transmittance");
                        UserInterface.writeGraphFile(dArray2[0], dArray2[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavelength (nm)\ty_Axis:Absorbance");
                    } else {
                        UserInterface.writeGraphFile(dArray3[0], dArray3[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavenumber (cm-1)\ty_Axis:%Reflectance or Transmittance");
                        UserInterface.writeGraphFile(dArray4[0], dArray4[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavenumber (cm-1)\ty_Axis:Absorbance");
                    }
                    --n;
                }
                SaveGraphsPanel saveGraphsPanel = new SaveGraphsPanel("_Spec_");
                SaveGraphsPanel.frmSaveGraphs.setVisible(true);
            }
        });
        chb_AutoSave_Spectroscopy.setFont(new Font("Dialog", 0, 10));
        chb_AutoSave_Spectroscopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser(){

                    @Override
                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (!UserInterface.checkEmptyDirectory(file.getAbsolutePath())) {
                            int n = JOptionPane.showConfirmDialog(this, "The chosen directory is not empty. Overwritting might occur, Are you sure you want to proceed?", "Directory not empty", 0);
                            switch (n) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case -1: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                            }
                        }
                        super.approveSelection();
                    }
                } : new JFileChooser(UserInterface.defaultDirectorySaveLoad){

                    @Override
                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (!UserInterface.checkEmptyDirectory(file.getAbsolutePath())) {
                            int n = JOptionPane.showConfirmDialog(this, "The chosen directory is not empty. Overwritting might occur, Are you sure you want to proceed?", "Directory not empty", 0);
                            switch (n) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case -1: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                            }
                        }
                        super.approveSelection();
                    }
                };
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setApproveButtonText("Save");
                jFileChooser.setDialogTitle("Save");
                if (chb_AutoSave_Spectroscopy.isSelected()) {
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        SpectroscopyPanel.this.AutoSavePath_Spectroscopy = jFileChooser.getSelectedFile().getAbsolutePath();
                        UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getAbsolutePath();
                    } else {
                        chb_AutoSave_Spectroscopy.setSelected(false);
                    }
                } else {
                    SpectroscopyPanel.this.AutoSavePath_Spectroscopy = "";
                }
            }
        });
        this.add((Component)chb_AutoSave_Spectroscopy, "cell 1 10 2 1,growx");
        this.add((Component)btn_SaveGraphs_Spec, "cell 0 11,growx");
        btn_LoadGraphs_Spec = new JButton("");
        btn_LoadGraphs_Spec.setFont(new Font("Dialog", 0, 10));
        btn_LoadGraphs_Spec.setText("Load");
        btn_LoadGraphs_Spec.setVerticalTextPosition(3);
        btn_LoadGraphs_Spec.setHorizontalTextPosition(0);
        btn_LoadGraphs_Spec.setToolTipText("Load Plot");
        btn_LoadGraphs_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!capture_Displayed_Spectroscopy && measurementCount_Spectroscopy != 0) {
                    measurementCount_Spectroscopy--;
                }
                capture_Displayed_Spectroscopy = false;
                JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setFileFilter(new FileNameExtensionFilter("Spectrum plot (*.Spectrum)", "Spectrum"));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    for (File file : jFileChooser.getSelectedFiles()) {
                        double[][] dArray = UserInterface.loadGraphDataFromFile(file.getAbsolutePath());
                        if (dArray == null) {
                            return;
                        }
                        SpectroscopyPanel.this.LoadCharts(dArray);
                    }
                    UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getParentFile().getAbsolutePath();
                }
            }
        });
        this.add((Component)btn_LoadGraphs_Spec, "cell 1 11 2 1,growx");
        btn_Capture_Spec = new JButton("Capture");
        btn_Capture_Spec.setEnabled(false);
        btn_Capture_Spec.setToolTipText("Capture Plot");
        btn_Capture_Spec.setFont(new Font("Dialog", 0, 10));
        btn_Capture_Spec.setVerticalTextPosition(3);
        btn_Capture_Spec.setHorizontalTextPosition(0);
        btn_Capture_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!capture_Displayed_Spectroscopy) {
                    capture_Displayed_Spectroscopy = true;
                    if (!SpectroscopyPanel.this.AutoSavePath_Spectroscopy.equals("") && capture_Displayed_Spectroscopy) {
                        try {
                            String string;
                            int n;
                            p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                            File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                            File[] fileArray = file.listFiles();
                            BufferedReader bufferedReader = null;
                            if (rdbtn_Refl_Trans.isSelected() && fileArray.length != 0) {
                                for (n = 0; n < fileArray.length; ++n) {
                                    if (!fileArray[n].isFile() || !fileArray[n].getAbsolutePath().endsWith(".Spectrum")) continue;
                                    p3AppManagerUtils.createDir((String)SpectroscopyPanel.this.AutoSavePath_Spectroscopy);
                                    bufferedReader = new BufferedReader(new FileReader(fileArray[n].getAbsolutePath()));
                                    string = bufferedReader.readLine();
                                    if (!string.contains("y_Axis:%Reflectance") && !string.contains("y_Axis:%Transmittance")) continue;
                                    Files.copy(fileArray[n].toPath(), new File(SpectroscopyPanel.this.AutoSavePath_Spectroscopy + File.separatorChar + fileArray[n].getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            if (rdbtn_Absorbance.isSelected() && fileArray.length != 0) {
                                for (n = 0; n < fileArray.length; ++n) {
                                    if (!fileArray[n].isFile() || !fileArray[n].getAbsolutePath().endsWith(".Spectrum")) continue;
                                    p3AppManagerUtils.createDir((String)SpectroscopyPanel.this.AutoSavePath_Spectroscopy);
                                    bufferedReader = new BufferedReader(new FileReader(fileArray[n].getAbsolutePath()));
                                    string = bufferedReader.readLine();
                                    if (!string.contains(SpectroscopyPanel.SPECTRUMFILE_Y_AXIS_A)) continue;
                                    Files.copy(fileArray[n].toPath(), new File(SpectroscopyPanel.this.AutoSavePath_Spectroscopy + File.separatorChar + fileArray[n].getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.add((Component)btn_Capture_Spec, "cell 1 12 2 1,growx");
        btn_ClearGraphs_Spec = new JButton("");
        btn_ClearGraphs_Spec.setFont(new Font("Dialog", 0, 10));
        btn_ClearGraphs_Spec.setText("Clear");
        btn_ClearGraphs_Spec.setVerticalTextPosition(3);
        btn_ClearGraphs_Spec.setHorizontalTextPosition(0);
        btn_ClearGraphs_Spec.setToolTipText("Clear Plots");
        btn_ClearGraphs_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File[] fileArray;
                clearingGraphsInProgress = true;
                p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                for (File file2 : fileArray = file.listFiles()) {
                    if (!file2.getAbsolutePath().endsWith(".Spectrum")) continue;
                    file2.delete();
                }
                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{{1285.0}, {90.0}}, 1285.0, 2615.0, 90.0, 110.0);
                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{{3700.0}, {90.0}}, 3700.0, 7795.0, 90.0, 110.0);
                spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavelength (nm)", "Absorbance units", new double[][]{{1285.0}, {0.0}}, 1285.0, 2615.0, 0.0, 1.2);
                spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{{3700.0}, {0.0}}, 3700.0, 7795.0, 0.0, 1.2);
                SpectroscopyPanel.this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = null;
                spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartReflTrans_NM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                spectroscopyChartPanel.getChart().removeLegend();
                spectroscopyChartPanel.repaint();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                SpectroscopyPanel.this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                measurementCount_Spectroscopy = 0;
                rdbtn_Refl_Trans.setSelected(true);
                rdbtn_Absorbance.setSelected(false);
                SpectroscopyPanel.this.AutoSavePath_Spectroscopy = "";
                if (chb_AutoSave_Spectroscopy.isSelected()) {
                    chb_AutoSave_Spectroscopy.setSelected(false);
                    JOptionPane.showMessageDialog(null, "Auto-save is disabled, please rechoose saving directory", "Auto-save disabled!", 0);
                }
                UserInterface.frmMain.revalidate();
                UserInterface.frmMain.repaint();
                clearingGraphsInProgress = false;
            }
        });
        this.add((Component)btn_ClearGraphs_Spec, "cell 3 11 3 1,growx");
        JSeparator jSeparator3 = new JSeparator();
        this.add((Component)jSeparator3, "cell 0 13 6 1,growx");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Label label10 = new Label("Data Display");
        label10.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label10, "cell 0 16,growx");
        Label label11 = new Label("Number of Data Points");
        label11.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label11, "cell 0 18,growx");
        cmb_Wavenumber_No_Of_Points_Spec = new JComboBox();
        cmb_Wavenumber_No_Of_Points_Spec.setEnabled(false);
        cmb_Wavenumber_No_Of_Points_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Wavenumber_No_Of_Points_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.getPreferredSize().height));
        cmb_Wavenumber_No_Of_Points_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.setSelectedIndex(cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.add(cmb_Wavenumber_No_Of_Points_Spec, "cell 2 18 3 1,growx");
        chb_EnableLinearInterpolation_Spectroscopy.setFont(new Font("Dialog", 0, 10));
        this.add((Component)chb_EnableLinearInterpolation_Spectroscopy, "cell 0 17 3 1,growx");
        chb_EnableLinearInterpolation_Spectroscopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterSpecPanel.chb_EnableLinearInterpolation_Inter_Spec.setSelected(chb_EnableLinearInterpolation_Spectroscopy.isSelected());
                if (chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                    cmb_Wavenumber_No_Of_Points_Spec.setEnabled(true);
                    UserInterface.displayCommonWVN();
                    cmb_Wavenumber_No_Of_Points_Spec.setSelectedIndex(4);
                    InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.setEnabled(true);
                    InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.setSelectedIndex(4);
                } else {
                    cmb_Wavenumber_No_Of_Points_Spec.setEnabled(false);
                    cmb_Wavenumber_No_Of_Points_Spec.removeAllItems();
                    InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.setEnabled(false);
                    InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.removeAllItems();
                }
            }
        });
        ButtonGroup buttonGroup3 = new ButtonGroup();
        rdbtn_nm_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = null;
                spectroscopyChartPanel = rdbtn_Absorbance.isSelected() ? spectroscopyChartAbs_NM.getChartPanel() : spectroscopyChartReflTrans_NM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                if (measurementCount_Spectroscopy == 0) {
                    spectroscopyChartPanel.getChart().removeLegend();
                }
                spectroscopyChartPanel.repaint();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                SpectroscopyPanel.this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                SpectroscopyPanel.this.revalidate();
                SpectroscopyPanel.this.repaint();
            }
        });
        Label label12 = new Label("X-Axis:");
        label12.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label12, "cell 0 19,growx,aligny top");
        Label label13 = new Label("Y-Axis:");
        label13.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label13, "cell 0 20,growx,aligny top");
        rdbtn_nm_Spec.setSelected(true);
        rdbtn_nm_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_nm_Spec, "flowx,cell 1 19 2 1,aligny top");
        buttonGroup2.add(rdbtn_nm_Spec);
        rdbtn_cm_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = null;
                spectroscopyChartPanel = rdbtn_Absorbance.isSelected() ? spectroscopyChartAbs_CM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                if (measurementCount_Spectroscopy == 0) {
                    spectroscopyChartPanel.getChart().removeLegend();
                }
                spectroscopyChartPanel.repaint();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                SpectroscopyPanel.this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                SpectroscopyPanel.this.revalidate();
                SpectroscopyPanel.this.repaint();
            }
        });
        rdbtn_cm_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_cm_Spec, "cell 3 19 3 1,aligny top");
        buttonGroup2.add(rdbtn_cm_Spec);
        rdbtn_Refl_Trans.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_Refl_Trans, "flowx,cell 1 20 2 1,aligny top");
        rdbtn_Refl_Trans.setSelected(true);
        rdbtn_Refl_Trans.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = null;
                spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartReflTrans_NM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                spectroscopyChartPanel.repaint();
                spectroscopyChartPanel.revalidate();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                SpectroscopyPanel.this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                SpectroscopyPanel.this.revalidate();
                SpectroscopyPanel.this.repaint();
            }
        });
        buttonGroup3.add(rdbtn_Refl_Trans);
        rdbtn_Absorbance.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_Absorbance, "cell 3 20 3 1,aligny top");
        rdbtn_Absorbance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = null;
                spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartAbs_NM.getChartPanel() : spectroscopyChartAbs_CM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                if (measurementCount_Spectroscopy == 0) {
                    spectroscopyChartPanel.getChart().removeLegend();
                }
                spectroscopyChartPanel.repaint();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                SpectroscopyPanel.this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                SpectroscopyPanel.this.revalidate();
                SpectroscopyPanel.this.repaint();
            }
        });
        buttonGroup3.add(rdbtn_Absorbance);
        lbl_advancedSettings_Spec = new Label("Advanced Settings");
        lbl_advancedSettings_Spec.setVisible(false);
        lbl_advancedSettings_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)lbl_advancedSettings_Spec, "cell 6 22 2 1,growx");
        btn_WavelengthWavenumberCalibration_Spec = new JButton("");
        btn_WavelengthWavenumberCalibration_Spec.setVisible(false);
        btn_WavelengthWavenumberCalibration_Spec.setEnabled(false);
        btn_WavelengthWavenumberCalibration_Spec.setFont(new Font("Dialog", 0, 10));
        btn_WavelengthWavenumberCalibration_Spec.setText("<html><center>Wavelength Correction</center></html>");
        btn_WavelengthWavenumberCalibration_Spec.setVerticalTextPosition(0);
        btn_WavelengthWavenumberCalibration_Spec.setHorizontalTextPosition(0);
        btn_WavelengthWavenumberCalibration_Spec.setToolTipText("Wavelength & Wavenumber Correction");
        btn_WavelengthWavenumberCalibration_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopEnablingButtons = true;
                UserInterface.boardReadyRoutine(false);
                try {
                    int n = 0;
                    if (chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                        n = cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex() + 1;
                    }
                    WL_WN_CalibrationPanel wL_WN_CalibrationPanel = new WL_WN_CalibrationPanel(String.valueOf(Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0), String.valueOf(cmb_Resolution_Spec.getSelectedIndex()), UserInterface.getOpticalGainValue((String)cmb_Optical_Settings_Spec.getSelectedItem()), String.valueOf(cmb_Apodization_Spec.getSelectedIndex()), String.valueOf(cmb_ZeroPadding_Spec.getSelectedIndex()), String.valueOf(n), "_Spec_");
                    WL_WN_CalibrationPanel.frmWL_Calib.setVisible(true);
                }
                catch (Exception exception) {
                    UserInterface.stopEnablingButtons = false;
                    UserInterface.boardReadyRoutine(true);
                    JOptionPane.showMessageDialog(null, "Failed to start. \n Please make sure that entries in measurement parameters are valid.", "Wavelength & Wavenumber Correction", 0);
                }
            }
        });
        this.add((Component)btn_WavelengthWavenumberCalibration_Spec, "cell 8 23 2 1,grow");
        lbl_FFT_Settings_Spec = new Label("FFT Settings");
        lbl_FFT_Settings_Spec.setVisible(false);
        lbl_FFT_Settings_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)lbl_FFT_Settings_Spec, "cell 12 22,growx");
        btn_GainAdjustmentPanel_Spec = new JButton("");
        btn_GainAdjustmentPanel_Spec.setVisible(false);
        btn_GainAdjustmentPanel_Spec.setEnabled(false);
        btn_GainAdjustmentPanel_Spec.setFont(new Font("Dialog", 0, 10));
        btn_GainAdjustmentPanel_Spec.setText("<html><center>Add New Optical Gain Setting</center></html>");
        btn_GainAdjustmentPanel_Spec.setVerticalTextPosition(0);
        btn_GainAdjustmentPanel_Spec.setHorizontalTextPosition(0);
        btn_GainAdjustmentPanel_Spec.setToolTipText("Add new optical gain setting");
        btn_GainAdjustmentPanel_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"OK"};
                int n = JOptionPane.showOptionDialog(null, "Please make sure that your sample is in the light path!", "Warning!", 0, 2, null, objectArray, objectArray[0]);
                if (n == -1) {
                    return;
                }
                if (n == 0) {
                    UserInterface.GainAdjustment();
                }
            }
        });
        this.add((Component)btn_GainAdjustmentPanel_Spec, "cell 6 23 2 1,grow");
        lbl_Apodization_Spec = new Label("Apodization Function");
        lbl_Apodization_Spec.setVisible(false);
        lbl_Apodization_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_Apodization_Spec, "cell 12 23,growx");
        separatorV1_Spec = new JSeparator();
        separatorV1_Spec.setVisible(false);
        separatorV1_Spec.setOrientation(1);
        this.add((Component)separatorV1_Spec, "cell 11 22 1 5,growy");
        btn_WriteSettings_Spec = new JButton("");
        btn_WriteSettings_Spec.setVisible(false);
        btn_WriteSettings_Spec.setEnabled(false);
        btn_WriteSettings_Spec.setFont(new Font("Dialog", 0, 10));
        btn_WriteSettings_Spec.setText("Burn Settings");
        btn_WriteSettings_Spec.setVerticalTextPosition(0);
        btn_WriteSettings_Spec.setHorizontalTextPosition(0);
        btn_WriteSettings_Spec.setToolTipText("Burn current settings in kit's ROM");
        btn_WriteSettings_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.burnSequence();
            }
        });
        this.add((Component)btn_WriteSettings_Spec, "cell 6 24 2 1,growx");
        cmb_Apodization_Spec = new JComboBox();
        cmb_Apodization_Spec.setEnabled(false);
        cmb_Apodization_Spec.setVisible(false);
        cmb_Apodization_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Apodization_Spec.setModel(new DefaultComboBoxModel<String>(p3Constants.apodizationOptions));
        cmb_Apodization_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.cmb_Apodization_Spec.getPreferredSize().height));
        cmb_Apodization_Spec.setMinimumSize(new Dimension(110, SpectroscopyPanel.cmb_Apodization_Spec.getPreferredSize().height));
        cmb_Apodization_Spec.setPreferredSize(new Dimension(110, SpectroscopyPanel.cmb_Apodization_Spec.getPreferredSize().height));
        this.add(cmb_Apodization_Spec, "flowx,cell 13 23 3 1,growx");
        cmb_Apodization_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                InterSpecPanel.cmb_Apodization_Inter_Spec.setSelectedIndex(cmb_Apodization_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                cmb_Apodization_Spec.setModel(new DefaultComboBoxModel<String>(p3Constants.apodizationOptions));
                SpectroscopyPanel.this.genuineAction = true;
            }
        });
        cmb_Apodization_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                File file = null;
                if (SpectroscopyPanel.this.genuineAction) {
                    SpectroscopyPanel.this.genuineAction = false;
                    object = null;
                    if (cmb_Apodization_Spec.getSelectedItem().toString().startsWith("External Function")) {
                        JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
                        jFileChooser.setMultiSelectionEnabled(false);
                        jFileChooser.setFileFilter(new FileNameExtensionFilter("Apodization window coefficients (*.txt)", "txt"));
                        if (jFileChooser.showOpenDialog(null) == 0) {
                            file = jFileChooser.getSelectedFile();
                            object = p3AppManagerUtils.loadLongDataFile((String)file.getAbsolutePath());
                            long l = 0L;
                            for (Object object2 : object) {
                                l += object2;
                            }
                            if (object == null || ((Object)object).length > 20 || ((Object)object).length == 0 || l == 0L) {
                                cmb_Apodization_Spec.setSelectedIndex(0);
                                InterSpecPanel.cmb_Apodization_Inter_Spec.setSelectedIndex(cmb_Apodization_Spec.getSelectedIndex());
                                JOptionPane.showMessageDialog(null, "Invalid apodization window. \nPlease select a valid window coefficients between 1~20 coefficients", "Apodization window", 0);
                                object = null;
                                return;
                            }
                            UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getParentFile().getAbsolutePath();
                        }
                        UserInterface.applicationManager.setExternalApodizationWindow((long[])object);
                        lastWindowSelected = "-1";
                    }
                }
                if (file != null) {
                    object = file.getName().replace(".txt", "");
                    cmb_Apodization_Spec.removeItemAt(cmb_Apodization_Spec.getItemCount() - 1);
                    cmb_Apodization_Spec.addItem((String)object);
                    cmb_Apodization_Spec.setSelectedIndex(cmb_Apodization_Spec.getItemCount() - 1);
                    InterSpecPanel.cmb_Apodization_Inter_Spec.removeItemAt(InterSpecPanel.cmb_Apodization_Inter_Spec.getItemCount() - 1);
                    InterSpecPanel.cmb_Apodization_Inter_Spec.addItem((String)object);
                    InterSpecPanel.cmb_Apodization_Inter_Spec.setSelectedIndex(InterSpecPanel.cmb_Apodization_Inter_Spec.getItemCount() - 1);
                } else {
                    InterSpecPanel.cmb_Apodization_Inter_Spec.setSelectedIndex(cmb_Apodization_Spec.getSelectedIndex());
                }
            }
        });
        JLabel jLabel = new JLabel("");
        jLabel.setFont(new Font("Dialog", 1, 10));
        jLabel.setForeground(Color.WHITE);
        jLabel.setBackground(Color.WHITE);
        this.add((Component)jLabel, "flowx,cell 0 22 6 3,alignx left,aligny bottom");
        spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{{1285.0}, {90.0}}, 1285.0, 2615.0, 90.0, 110.0);
        spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{{3700.0}, {90.0}}, 3700.0, 7795.0, 90.0, 110.0);
        spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavelength (nm)", "Absorbance units", new double[][]{{1285.0}, {0.0}}, 1285.0, 2615.0, 0.0, 1.2);
        spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{{3700.0}, {0.0}}, 3700.0, 7795.0, 0.0, 1.2);
        spectroscopyChartPanel = spectroscopyChartReflTrans_NM.getChartPanel();
        spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
        spectroscopyChartPanel.getChart().removeLegend();
        spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
        this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
        lbl_ZeroPadding_Spec = new Label("Zero Padding");
        lbl_ZeroPadding_Spec.setVisible(false);
        lbl_ZeroPadding_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_ZeroPadding_Spec, "cell 12 24,growx");
        cmb_ZeroPadding_Spec = new JComboBox();
        cmb_ZeroPadding_Spec.setEnabled(false);
        cmb_ZeroPadding_Spec.setVisible(false);
        cmb_ZeroPadding_Spec.setFont(new Font("Dialog", 1, 10));
        for (int i = 0; i < p3Constants.paddingOptions.length; ++i) {
            cmb_ZeroPadding_Spec.addItem(p3Constants.paddingOptions[i] + " N");
        }
        cmb_ZeroPadding_Spec.setMaximumSize(new Dimension(110, SpectroscopyPanel.cmb_ZeroPadding_Spec.getPreferredSize().height));
        this.add(cmb_ZeroPadding_Spec, "flowx,cell 13 24 3 1,growx");
        btn_RestoreDefault_spec = new JButton("Restore Default Settings");
        btn_RestoreDefault_spec.setVisible(false);
        btn_RestoreDefault_spec.setFont(new Font("Dialog", 0, 10));
        btn_RestoreDefault_spec.setEnabled(false);
        btn_RestoreDefault_spec.setToolTipText("Restore Default Settings");
        btn_RestoreDefault_spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.restoreSequence();
            }
        });
        this.add((Component)btn_RestoreDefault_spec, "cell 8 24 2 1,growx");
        cmb_ZeroPadding_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                InterSpecPanel.cmb_ZeroPadding_Inter_Spec.setSelectedIndex(cmb_ZeroPadding_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        try {
            file = new File(UserInterface.DELETE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_ClearGraphs_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Clear plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading  plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.DELETE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(20, -1, 4);
                btn_DeleteOpticalOption_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Delete optical gain image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading  plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.SAVE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_SaveGraphs_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Save plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading save plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.LOAD_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_LoadGraphs_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Load plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading load plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.CAPTURE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Capture_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Capture image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading capture image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.LOGO_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(264, 66, 4);
                jLabel.setHorizontalTextPosition(2);
                jLabel.setText("   ");
                jLabel.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Logo image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.RUN_BG_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Run_Background.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Run image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.RUN_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Run_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Run image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.STOP_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Stop_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Stop image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
    }

    public void update(Object object) {
        if (object instanceof p3AppManagerNotification) {
            p3AppManagerNotification p3AppManagerNotification2 = (p3AppManagerNotification)object;
            switch (p3AppManagerNotification2.getAction()) {
                case 2: {
                    UserInterface.progressTime = -1.0;
                    UserInterface.progressPar.setValue(100);
                    if (p3AppManagerNotification2.getStatus() == 0) {
                        UserInterface.statusLabel.setText("Background measurement completed successfully.");
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                        UserInterface.boardRestarted = false;
                    } else {
                        UserInterface.colorLabel.setForeground(Color.red);
                        UserInterface.colorLabel.setBackground(Color.red);
                        JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Run NeoSpectra Micro", 0);
                    }
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    UserInterface.boardReadyRoutine(true);
                    break;
                }
                case 3: {
                    logger.info((Object)"Run_Spec Finished");
                    if (!UserInterface.stopContinuousRun) {
                        if (p3AppManagerNotification2.getStatus() == 0) {
                            logger.info((Object)"Get Data of Run_Spec Started");
                            double[][] dArray = UserInterface.applicationManager.getSpecData();
                            logger.info((Object)"Get Data of Run_Spec Finished");
                            double d = UserInterface.applicationManager.getErrorData();
                            double[] dArray2 = UserInterface.switch_NM_CM(dArray[2]);
                            double[] dArray3 = UserInterface.convertDataToT(dArray[3]);
                            for (int i = 0; i < dArray3.length; ++i) {
                                dArray3[i] = dArray3[i] / d;
                            }
                            double[] dArray4 = UserInterface.convertRefltoAbs(dArray3);
                            boolean bl = false;
                            if (!chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                                String string = String.valueOf((int)dArray[4][0]);
                                string = string + " pts";
                                InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.removeAllItems();
                                cmb_Wavenumber_No_Of_Points_Spec.removeAllItems();
                                cmb_Wavenumber_No_Of_Points_Spec.addItem(string);
                                InterSpecPanel.cmb_Wavenumber_No_Of_Points_Inter_Spec.addItem(string);
                            }
                            if (!clearingGraphsInProgress) {
                                try {
                                    if (measurementCount_Spectroscopy == 0) {
                                        bl = true;
                                    }
                                    if (!capture_Displayed_Spectroscopy && measurementCount_Spectroscopy != 0) {
                                        --measurementCount_Spectroscopy;
                                    }
                                    if (++measurementCount_Spectroscopy == 1 && bl) {
                                        spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray3}, true);
                                        spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray[2], dArray3}, true);
                                        spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", new double[][]{dArray2, dArray4}, true);
                                        spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{dArray[2], dArray4}, true);
                                        bl = false;
                                    } else {
                                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray3}, true);
                                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray[2], dArray3}, true);
                                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray4}, true);
                                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray[2], dArray4}, true);
                                    }
                                    this.remove((Component)spectroscopyChartPanel);
                                    spectroscopyChartPanel = null;
                                    if (rdbtn_Refl_Trans.isSelected()) {
                                        spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartReflTrans_NM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                                    } else if (rdbtn_Absorbance.isSelected()) {
                                        spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartAbs_NM.getChartPanel() : spectroscopyChartAbs_CM.getChartPanel();
                                    }
                                    capture_Displayed_Spectroscopy = false;
                                    spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                                    spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                                    this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                                    spectroscopyChartPanel.repaint();
                                }
                                catch (Exception exception) {
                                    logger.error((Object)exception.getMessage());
                                }
                                if (dArray != null) {
                                    this.writeRunDataFile(dArray);
                                }
                            }
                            dArray = null;
                            dArray2 = null;
                            dArray3 = null;
                            if (UserInterface.stopContinuousRun || !UserInterface.isContinuousRun || !rdbtn_ContRun_Spec.isSelected()) {
                                UserInterface.statusLabel.setText("Measurement completed successfully.");
                                UserInterface.colorLabel.setForeground(Color.green.darker());
                                UserInterface.colorLabel.setBackground(Color.green.darker());
                                UserInterface.progressTime = -1.0;
                                UserInterface.progressPar.setValue(100);
                            }
                        } else {
                            UserInterface.colorLabel.setForeground(Color.red);
                            UserInterface.colorLabel.setBackground(Color.red);
                            UserInterface.progressTime = -1.0;
                            UserInterface.progressPar.setValue(100);
                            JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Run NeoSpectra Micro", 0);
                            btn_Stop_Spec.doClick();
                        }
                    }
                    if (!UserInterface.stopContinuousRun && UserInterface.isContinuousRun && rdbtn_ContRun_Spec.isSelected()) {
                        UserInterface.releaseDeviceToken();
                        this.RunSampleSequence();
                        try {
                            logger.info((Object)("Run_Spec Finished (Without PowerUp) - Scan Time = " + String.valueOf(Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0)));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    if (rdbtn_ContRun_Spec.isSelected()) {
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                    }
                    UserInterface.boardReadyRoutine(true);
                    boolean bl = btn_Capture_Spec.isEnabled();
                    btn_Capture_Spec.setEnabled(true);
                    btn_Capture_Spec.doClick();
                    btn_Capture_Spec.setEnabled(bl);
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    break;
                }
            }
        }
    }

    public void deleteLastAbsChart() {
        p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File[] fileArray = file.listFiles();
        spectroscopyChartAbs_NM.removeSeries("Measurement No. " + measurementCount_Spectroscopy);
        spectroscopyChartAbs_CM.removeSeries("Measurement No. " + measurementCount_Spectroscopy);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().equals("Measurement_Abs_" + measurementCount_Spectroscopy + ".Spectrum")) continue;
            fileArray[i].delete();
        }
    }

    public void deleteLastReflChart() {
        p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File[] fileArray = file.listFiles();
        spectroscopyChartReflTrans_NM.removeSeries("Measurement No. " + measurementCount_Spectroscopy);
        spectroscopyChartReflTrans_CM.removeSeries("Measurement No. " + measurementCount_Spectroscopy);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().equals("Measurement_Refl_" + measurementCount_Spectroscopy + ".Spectrum")) continue;
            fileArray[i].delete();
        }
    }

    public void layoutResize(String string) {
        ((MigLayout)this.getLayout()).setColumnConstraints((Object)("[90.00:90.00:90.00][45.00:45.00:45.00][45.00:45.00:45.00][30.00:30.00:30.00][30.00:30.00:30.00][30.00:30.00:30.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00]" + string + "[][][][][grow,fill]"));
    }

    boolean writeRunDataFile(double[][] dArray) {
        double[] dArray2 = UserInterface.switch_NM_CM(dArray[2]);
        double[] dArray3 = UserInterface.convertDataToT(dArray[3]);
        double[] dArray4 = UserInterface.convertRefltoAbs(dArray3);
        double d = UserInterface.applicationManager.getErrorData();
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray3[i] / d;
        }
        if (rdbtn_nm_Spec.isSelected()) {
            if (!UserInterface.writeGraphFile(dArray2, dArray3, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:%Reflectance or Transmittance")) {
                throw new p3AppManagerException("Error while writing spectrum file    ", p3Enumerations.p3AppManagerStatus.SPECTRUM_FILE_CREATION_ERROR.getNumVal());
            }
            if (!UserInterface.writeGraphFile(dArray2, dArray4, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:Absorbance")) {
                throw new p3AppManagerException("Error while writing spectrum file    ", p3Enumerations.p3AppManagerStatus.SPECTRUM_FILE_CREATION_ERROR.getNumVal());
            }
        } else {
            if (!UserInterface.writeGraphFile(dArray[2], dArray3, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:%Reflectance or Transmittance")) {
                throw new p3AppManagerException("Error while writing spectrum file    ", p3Enumerations.p3AppManagerStatus.SPECTRUM_FILE_CREATION_ERROR.getNumVal());
            }
            if (!UserInterface.writeGraphFile(dArray[2], dArray4, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:Absorbance")) {
                throw new p3AppManagerException("Error while writing spectrum file    ", p3Enumerations.p3AppManagerStatus.SPECTRUM_FILE_CREATION_ERROR.getNumVal());
            }
        }
        dArray2 = null;
        dArray3 = null;
        return true;
    }

    private void RunSampleSequence() {
        UserInterface.stopContinuousRun = false;
        UserInterface.isContinuousRun = true;
        if (!UserInterface.stopContinuousRun) {
            try {
                UserInterface.checkDeviceStatusThreadStop = true;
                try {
                    if (UserInterface.boardRestarted) {
                        JOptionPane.showMessageDialog(null, "No valid background measurement. \n Please take background measurement first.", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                    if (!lastOpticalSettingsSelected.equals(cmb_Optical_Settings_Spec.getSelectedItem().toString())) {
                        JOptionPane.showMessageDialog(null, "You have changed the optical gain settings after your last background measurement. \nPlease retake a new background measurement", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                    if (!lastZeroPaddingSelected.equals(String.valueOf(cmb_ZeroPadding_Spec.getSelectedIndex()))) {
                        JOptionPane.showMessageDialog(null, "You have changed the zero padding settings after your last background measurement. \nPlease retake a new background measurement", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                    if (!lastResolutionSelected.equals(String.valueOf(cmb_Resolution_Spec.getSelectedIndex()))) {
                        JOptionPane.showMessageDialog(null, "You have changed the resolution after your last background measurement. \nPlease retake a new background measurement", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                    if (!lastWindowSelected.equals(String.valueOf(cmb_Apodization_Spec.getSelectedIndex()))) {
                        JOptionPane.showMessageDialog(null, "You have changed the apodization function after your last background measurement. \nPlease retake a new background measurement", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                    if (chb_EnableLinearInterpolation_Spectroscopy.isSelected() && !lastCommonWavenumberSelected.equals(String.valueOf(cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex() + 1)) || !chb_EnableLinearInterpolation_Spectroscopy.isSelected() && !lastCommonWavenumberSelected.equals("0")) {
                        JOptionPane.showMessageDialog(null, "You have changed the number of data points after your last background measurement. \nPlease retake a new background measurement", "Run NeoSpectra Micro", 0);
                        UserInterface.checkDeviceStatusThreadStop = false;
                        UserInterface.stopContinuousRun = true;
                        UserInterface.isContinuousRun = false;
                        return;
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Run failed to start. Module setup failed!. \n Please take another measurement. \nIf the error persists, please contact Si-Ware Systems.", "Run NeoSpectra Micro", 0);
                    UserInterface.checkDeviceStatusThreadStop = false;
                    UserInterface.stopContinuousRun = true;
                    UserInterface.isContinuousRun = false;
                    return;
                }
                UserInterface.progressTime = Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0;
                UserInterface.progressPar.setValue(0);
                int n = 0;
                if (chb_EnableLinearInterpolation_Spectroscopy.isSelected()) {
                    n = cmb_Wavenumber_No_Of_Points_Spec.getSelectedIndex() + 1;
                }
                while (!UserInterface.acquireDeviceToken()) {
                }
                p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.runSpec(new String[]{String.valueOf(Double.parseDouble(txt_RunTime_Spec.getText()) * 1000.0), "true", String.valueOf(cmb_Apodization_Spec.getSelectedIndex()), String.valueOf(cmb_ZeroPadding_Spec.getSelectedIndex()), UserInterface.getOpticalGainValue((String)cmb_Optical_Settings_Spec.getSelectedItem()), String.valueOf(n), Integer.toString(rdbtn_ContRun_Spec.isSelected() ? 1 : 0), Integer.toString(cmb_Resolution_Spec.getSelectedIndex())});
                if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                    if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                        UserInterface.checkDeviceStatusThreadStop = false;
                    }
                    JOptionPane.showMessageDialog(null, "Run failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Run NeoSpectra Micro", 0);
                    UserInterface.stopContinuousRun = true;
                    UserInterface.isContinuousRun = false;
                    UserInterface.releaseDeviceToken();
                } else {
                    UserInterface.boardReadyRoutine(false);
                    UserInterface.statusLabel.setText("Run started. Please wait...");
                    UserInterface.colorLabel.setForeground(Color.yellow);
                    UserInterface.colorLabel.setBackground(Color.yellow);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Run failed to start. \n Please make sure that the entries in measurement parameters are valid.", "Run NeoSpectra Micro", 0);
                UserInterface.stopContinuousRun = true;
                UserInterface.isContinuousRun = false;
                UserInterface.boardReadyRoutine(true);
                UserInterface.releaseDeviceToken();
                UserInterface.checkDeviceStatusThreadStop = false;
            }
        }
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
    }

    private void LoadCharts(double[][] dArray) {
        try {
            block41: {
                double[] dArray2;
                this.remove((Component)spectroscopyChartPanel);
                ++measurementCount_Spectroscopy;
                if (rdbtn_Absorbance.isSelected()) {
                    dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                    if (measurementCount_Spectroscopy == 1) {
                        if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", dArray);
                            spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{dArray2, dArray[1]});
                        } else {
                            spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", dArray);
                            spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", new double[][]{dArray2, dArray[1]});
                        }
                    } else if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray);
                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]});
                    } else {
                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray);
                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]});
                    }
                    if (rdbtn_nm_Spec.isSelected()) {
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:Absorbance");
                        spectroscopyChartPanel = spectroscopyChartAbs_NM.getChartPanel();
                    } else {
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:Absorbance");
                        spectroscopyChartPanel = spectroscopyChartAbs_CM.getChartPanel();
                    }
                    double[] dArray3 = UserInterface.convertAbstoRefl(dArray[1]);
                    double[] dArray4 = dArray[0];
                    if (rdbtn_nm_Spec.isSelected()) {
                        UserInterface.writeGraphFile(dArray4, dArray3, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:%Reflectance or Transmittance");
                    } else {
                        UserInterface.writeGraphFile(dArray4, dArray3, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:%Reflectance or Transmittance");
                    }
                    dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                    if (measurementCount_Spectroscopy == 1) {
                        try {
                            if (rdbtn_nm_Spec.isSelected()) {
                                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray4, dArray3}, true);
                                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray3}, true);
                                break block41;
                            }
                            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray4, dArray3}, true);
                            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray3}, true);
                        }
                        catch (Exception exception) {
                            if (rdbtn_nm_Spec.isSelected()) {
                                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray4, dArray3}, true);
                                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray3}, true);
                                break block41;
                            }
                            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray4, dArray3}, true);
                            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray3}, true);
                        }
                    } else if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray4, dArray3}, true);
                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray3}, true);
                    } else {
                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray4, dArray3}, true);
                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray3}, true);
                    }
                } else if (rdbtn_Refl_Trans.isSelected()) {
                    block42: {
                        dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                        if (measurementCount_Spectroscopy == 1) {
                            try {
                                if (rdbtn_nm_Spec.isSelected()) {
                                    spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", dArray, true);
                                    spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                                    break block42;
                                }
                                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", dArray, true);
                                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                            }
                            catch (Exception exception) {
                                if (rdbtn_nm_Spec.isSelected()) {
                                    spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", dArray, true);
                                    spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                                    break block42;
                                }
                                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", dArray, true);
                                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                            }
                        } else if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                            spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                        } else {
                            spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                            spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                        }
                    }
                    if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartPanel = spectroscopyChartReflTrans_NM.getChartPanel();
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:%Reflectance or Transmittance");
                    } else {
                        spectroscopyChartPanel = spectroscopyChartReflTrans_CM.getChartPanel();
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_REFL_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:%Reflectance or Transmittance");
                    }
                    double[] dArray5 = UserInterface.convertRefltoAbs(dArray[1]);
                    double[] dArray6 = dArray[0];
                    if (rdbtn_nm_Spec.isSelected()) {
                        UserInterface.writeGraphFile(dArray6, dArray5, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavelength (nm)\ty_Axis:Absorbance");
                    } else {
                        UserInterface.writeGraphFile(dArray6, dArray5, p3AppManagerUtils.formatString((String)p3Constants.getPath((String)SPECTRUM_ABS_PATH_TEMPLATE), (Object[])new Object[]{measurementCount_Spectroscopy}), "x_Axis:Wavenumber (cm-1)\ty_Axis:Absorbance");
                    }
                    dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                    if (measurementCount_Spectroscopy == 1) {
                        if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance", new double[][]{dArray6, dArray5}, true);
                            spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance", new double[][]{dArray2, dArray5}, true);
                        } else {
                            spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance", new double[][]{dArray6, dArray5}, true);
                            spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance", new double[][]{dArray2, dArray5}, true);
                        }
                    } else if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray6, dArray5}, true);
                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray5}, true);
                    } else {
                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray6, dArray5}, true);
                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray5}, true);
                    }
                }
            }
            boolean bl = btn_Capture_Spec.isEnabled();
            btn_Capture_Spec.setEnabled(true);
            btn_Capture_Spec.doClick();
            btn_Capture_Spec.setEnabled(bl);
            spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
            spectroscopyChartPanel.repaint();
            spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
            this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
            this.repaint();
            UserInterface.frmMain.revalidate();
            UserInterface.frmMain.repaint();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to save measurement data files in the temporary directory: " + exception.getMessage(), "Saving files", 0);
        }
    }

    public void changeOptionRoutine() {
        boolean bl = rdbtn_Absorbance.isSelected();
        File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        if (!file.exists()) {
            p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        }
        File[] fileArray = file.listFiles();
        measurementCount_Spectroscopy = 0;
        if (fileArray.length == 0) {
            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{{1285.0}, {90.0}}, 1285.0, 2615.0, 90.0, 110.0);
            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{{3700.0}, {90.0}}, 3700.0, 7795.0, 90.0, 110.0);
            if (rdbtn_Refl_Trans.isSelected()) {
                this.remove((Component)spectroscopyChartPanel);
                spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartReflTrans_NM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                spectroscopyChartPanel.getChart().removeLegend();
                spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
                this.repaint();
                UserInterface.frmMain.revalidate();
                UserInterface.frmMain.repaint();
            }
        } else {
            for (File file2 : fileArray) {
                if (file2.isDirectory() || !file2.getName().endsWith(".Spectrum") || !file2.getName().contains("Abs")) continue;
                String string = file2.getAbsolutePath();
                double[][] dArray = UserInterface.loadGraphDataFromFile(string);
                double[] dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                try {
                    double[] dArray3;
                    double[] dArray4;
                    this.remove((Component)spectroscopyChartPanel);
                    ++measurementCount_Spectroscopy;
                    if (rdbtn_Absorbance.isSelected()) {
                        if (measurementCount_Spectroscopy == 1) {
                            if (rdbtn_nm_Spec.isSelected()) {
                                spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", dArray, true);
                                spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{dArray2, dArray[1]}, true);
                            } else {
                                spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", dArray, true);
                                spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", new double[][]{dArray2, dArray[1]}, true);
                            }
                        } else if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                            spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                        } else {
                            spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                            spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                        }
                        spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartAbs_NM.getChartPanel() : spectroscopyChartAbs_CM.getChartPanel();
                        dArray4 = UserInterface.convertAbstoRefl(dArray[1]);
                        dArray3 = dArray[0];
                        if (measurementCount_Spectroscopy == 1) {
                            if (rdbtn_nm_Spec.isSelected()) {
                                spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray3, dArray4}, true);
                                spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray4}, true);
                                continue;
                            }
                            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray3, dArray4}, true);
                            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray4}, true);
                            continue;
                        }
                        if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray3, dArray4}, true);
                            spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray4}, true);
                            continue;
                        }
                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray3, dArray4}, true);
                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray4}, true);
                        continue;
                    }
                    if (!rdbtn_Refl_Trans.isSelected()) continue;
                    if (measurementCount_Spectroscopy == 1) {
                        if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", dArray, true);
                            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                        } else {
                            spectroscopyChartReflTrans_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "%Reflectance or Transmittance", dArray, true);
                            spectroscopyChartReflTrans_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "%Reflectance or Transmittance", new double[][]{dArray2, dArray[1]}, true);
                        }
                    } else if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                    } else {
                        spectroscopyChartReflTrans_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), dArray, true);
                        spectroscopyChartReflTrans_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray[1]}, true);
                    }
                    spectroscopyChartPanel = rdbtn_nm_Spec.isSelected() ? spectroscopyChartReflTrans_NM.getChartPanel() : spectroscopyChartReflTrans_CM.getChartPanel();
                    dArray4 = UserInterface.convertRefltoAbs(dArray[1]);
                    dArray3 = dArray[0];
                    if (measurementCount_Spectroscopy == 1) {
                        if (rdbtn_nm_Spec.isSelected()) {
                            spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", new double[][]{dArray3, dArray4}, true);
                            spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{dArray2, dArray4}, true);
                            continue;
                        }
                        spectroscopyChartAbs_CM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavenumber (cm -\u00b9)", "Absorbance units", new double[][]{dArray3, dArray4}, true);
                        spectroscopyChartAbs_NM = new XYLineChart("Spectrum", (Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), "Wavelength (nm)", "Absorbance units", new double[][]{dArray2, dArray4}, true);
                        continue;
                    }
                    if (rdbtn_nm_Spec.isSelected()) {
                        spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray3, dArray4}, true);
                        spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray4}, true);
                        continue;
                    }
                    spectroscopyChartAbs_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray3, dArray4}, true);
                    spectroscopyChartAbs_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + measurementCount_Spectroscopy)), new double[][]{dArray2, dArray4}, true);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Failed to save measurement data files in the temporary directory: " + exception.getMessage(), "Saving files", 0);
                }
            }
        }
        spectroscopyChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
        spectroscopyChartPanel.repaint();
        spectroscopyChartPanel.setPreferredSize(new Dimension((int)spectroscopyChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
        this.add((Component)spectroscopyChartPanel, "cell 6 0 10 21,grow");
        this.repaint();
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
        if (!bl) {
            rdbtn_Refl_Trans.doClick();
        }
    }

    public static void saveGraphsRoutine() {
        p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = UserInterface.fileNameToSave.equals("!Default!") ? fileArray[i].getName() : UserInterface.fileNameToSave + fileArray[i].getName().substring(fileArray[i].getName().indexOf("_"));
        }
        JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonText("Save");
        jFileChooser.setDialogTitle("Save");
        if (stringArray.length != 0 && jFileChooser.showOpenDialog(null) == 0) {
            BufferedReader bufferedReader = null;
            p3AppManagerUtils.createDir((String)jFileChooser.getSelectedFile().getAbsolutePath());
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].getAbsolutePath().endsWith(".Spectrum")) continue;
                try {
                    if (new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).exists()) {
                        if (n == -1) {
                            int n2 = JOptionPane.showConfirmDialog(null, "The chosen directory has plot(s) with the same name, overwrite all?", "Overwrite", 0);
                            switch (n2) {
                                case 0: {
                                    String string;
                                    n = 1;
                                    if (rdbtn_Refl_Trans.isSelected()) {
                                        bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                                        string = bufferedReader.readLine();
                                        if (string.contains("y_Axis:%Reflectance") || string.contains("y_Axis:%Transmittance")) {
                                            Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        } else {
                                            Files.delete(new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath());
                                        }
                                        bufferedReader.close();
                                        break;
                                    }
                                    bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                                    string = bufferedReader.readLine();
                                    if (string.contains(SPECTRUMFILE_Y_AXIS_A)) {
                                        Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    } else {
                                        Files.delete(new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath());
                                    }
                                    bufferedReader.close();
                                    break;
                                }
                                case -1: {
                                    n = 0;
                                    break;
                                }
                                case 1: {
                                    n = 0;
                                }
                            }
                            continue;
                        }
                        if (n != 1) continue;
                        if (rdbtn_Refl_Trans.isSelected()) {
                            bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                            String string = bufferedReader.readLine();
                            if (string.contains("y_Axis:%Reflectance") || string.contains("y_Axis:%Transmittance")) {
                                Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            bufferedReader.close();
                            continue;
                        }
                        bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                        String string = bufferedReader.readLine();
                        if (string.contains(SPECTRUMFILE_Y_AXIS_A)) {
                            Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        bufferedReader.close();
                        continue;
                    }
                    if (rdbtn_Refl_Trans.isSelected()) {
                        bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                        String string = bufferedReader.readLine();
                        if (string.contains("y_Axis:%Reflectance") || string.contains("y_Axis:%Transmittance")) {
                            Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        bufferedReader.close();
                        continue;
                    }
                    bufferedReader = new BufferedReader(new FileReader(fileArray[i].getAbsolutePath()));
                    String string = bufferedReader.readLine();
                    if (string.contains(SPECTRUMFILE_Y_AXIS_A)) {
                        Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    bufferedReader.close();
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Failed to save files to the selected destination: " + exception.getMessage(), "Saving files", 0);
                    return;
                }
            }
            UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getAbsolutePath();
        }
    }

    static {
        lastResolutionSelected = "";
        lastOpticalSettingsSelected = "";
        lastZeroPaddingSelected = "";
        lastWindowSelected = "";
        lastCommonWavenumberSelected = "";
        chb_AutoSave_Spectroscopy = new JCheckBox("Auto-save");
        chb_EnableLinearInterpolation_Spectroscopy = new JCheckBox("Enable linear interpolaion");
        rdbtn_Absorbance = new JRadioButton("Abs.");
        rdbtn_Refl_Trans = new JRadioButton("%Refl. or Trans.");
        rdbtn_nm_Spec = new JRadioButton("nm");
        rdbtn_cm_Spec = new JRadioButton("cm\u207b\u00b9");
        spectroscopyChartReflTrans_NM = null;
        spectroscopyChartAbs_NM = null;
        spectroscopyChartReflTrans_CM = null;
        spectroscopyChartAbs_CM = null;
        spectroscopyChartPanel = null;
        measurementCount_Spectroscopy = 0;
    }
}

