/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import sws.spectromost.UserInterface;

public class SaveOpticalGainPanel
extends JPanel {
    static JFrame frmSaveOpticalGain;
    static JButton btn_Save;
    private JLabel lblSetupName;
    private JTextField txt_SetupName;
    private JLabel lblNote;
    private int gainValue;

    public SaveOpticalGainPanel(int n) {
        this.gainValue = n;
        this.initialize();
    }

    public void initialize() {
        frmSaveOpticalGain = new JFrame();
        try {
            File file = new File(UserInterface.ICON_PATH);
            if (file.exists()) {
                BufferedImage bufferedImage = ImageIO.read(file);
                frmSaveOpticalGain.setIconImage(bufferedImage);
            } else {
                JOptionPane.showMessageDialog(frmSaveOpticalGain, "Icon doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(frmSaveOpticalGain, "Error loading Icon:" + iOException.getMessage(), "Loading icon", 0);
        }
        frmSaveOpticalGain.setBackground(new Color(176, 196, 222));
        frmSaveOpticalGain.getContentPane().setBackground(new Color(176, 196, 222));
        frmSaveOpticalGain.setVisible(true);
        frmSaveOpticalGain.setName("SpecFrame");
        frmSaveOpticalGain.setMinimumSize(new Dimension(450, 120));
        frmSaveOpticalGain.setMaximumSize(new Dimension(450, 120));
        frmSaveOpticalGain.setPreferredSize(new Dimension(450, 120));
        frmSaveOpticalGain.setLocation((int)(UserInterface.screenSize.getWidth() / 2.0 - 150.0), (int)(UserInterface.screenSize.getHeight() / 2.0 - 60.0));
        frmSaveOpticalGain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SaveOpticalGainPanel.this.onCloseOperation();
            }
        });
        frmSaveOpticalGain.setTitle("Saving Optical Gain Value");
        frmSaveOpticalGain.setDefaultCloseOperation(0);
        frmSaveOpticalGain.setResizable(false);
        frmSaveOpticalGain.setFont(new Font("Dialog", 0, 12));
        frmSaveOpticalGain.setBackground(new Color(176, 196, 222));
        frmSaveOpticalGain.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][][][][45.00:45.00,grow]", "[][][]"));
        this.lblSetupName = new JLabel("Optical Gain Name");
        frmSaveOpticalGain.getContentPane().add((Component)this.lblSetupName, "cell 0 0 2 1,grow");
        this.txt_SetupName = new JTextField();
        this.txt_SetupName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    SaveOpticalGainPanel.this.saveAction();
                }
            }
        });
        frmSaveOpticalGain.getContentPane().add((Component)this.txt_SetupName, "cell 2 0 3 1,growx");
        this.txt_SetupName.setColumns(10);
        this.lblNote = new JLabel("Please enter the name of your setup");
        frmSaveOpticalGain.getContentPane().add((Component)this.lblNote, "cell 0 1 5 1,grow");
        btn_Save = new JButton("");
        btn_Save.setFont(new Font("Dialog", 0, 12));
        btn_Save.setText("Save");
        btn_Save.setVerticalTextPosition(0);
        btn_Save.setHorizontalTextPosition(0);
        btn_Save.setToolTipText("Save Optical Gain Value");
        btn_Save.setMaximumSize(new Dimension(110, SaveOpticalGainPanel.btn_Save.getPreferredSize().height));
        btn_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveOpticalGainPanel.this.saveAction();
            }
        });
        frmSaveOpticalGain.getContentPane().add((Component)btn_Save, "cell 0 2 5 1,alignx center");
    }

    private void onCloseOperation() {
        UserInterface.releaseDeviceToken();
        UserInterface.checkDeviceStatusThreadStop = false;
        UserInterface.boardReadyRoutine(true);
        frmSaveOpticalGain.dispose();
    }

    private void saveAction() {
        String string = "";
        if (!this.txt_SetupName.getText().equals("")) {
            string = this.txt_SetupName.getText().contains(":") ? this.txt_SetupName.getText().replace(":", "") : this.txt_SetupName.getText();
            int n = UserInterface.saveOpticalGainRoutine(string, this.gainValue);
            if (n == 1) {
                int n2 = JOptionPane.showConfirmDialog(this, "There is already a setup with the same name. do you want to overwrite it?", "Name already exists", 0);
                switch (n2) {
                    case 0: {
                        UserInterface.deleteOpticalSetting(string);
                        UserInterface.saveOpticalGainRoutine(string, this.gainValue);
                        break;
                    }
                    case -1: {
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
            } else if (n < 0) {
                JOptionPane.showMessageDialog(null, "Optical gain value can't be saved, please try again.", "Saving error", 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(null, "Please fill the name field!", "Saving Optical Gain Value", 0);
            return;
        }
        UserInterface.displaySpecOpticalSettings();
        UserInterface.displayInterSpecOpticalSettings();
        UserInterface.updateSelectedOpticalSetting();
        this.onCloseOperation();
    }
}

