/*
 * Decompiled with CFR 0.152.
 */
package sws.spectromost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import sws.p3AppManager_micro.utils.p3AppManagerException;
import sws.p3AppManager_micro.utils.p3AppManagerNotification;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.p3AppManager_micro.utils.p3Constants;
import sws.p3AppManager_micro.utils.p3Enumerations;
import sws.spectromost.SaveGraphsPanel;
import sws.spectromost.SpectroscopyPanel;
import sws.spectromost.UserInterface;
import sws.spectromost.WL_WN_CalibrationPanel;
import sws.spectromost.jfreechart.XYLineChart;

public class InterSpecPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(InterSpecPanel.class);
    public static final String PSD_PATH_TEMPLATE = p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH) + File.separatorChar + "Measurement_{0}.InterPSD";
    public static final String PSD_FILE_X_AXIS_CM = "x_Axis:Wavenumber (cm-1)";
    public static final String PSD_FILE_X_AXIS_NM = "x_Axis:Wavelength (nm)";
    public static final String PSD_FILE_Y_AXIS_N = "y_Axis:Normalized PSD (a.u.)";
    public static final String PSD_FILE_Y_AXIS = "y_Axis:PSD (a.u.)";
    public static boolean capture_Displayed_InterSpec = false;
    private static boolean clearingGraphsInProgress = false;
    private String AutoSavePath_Inter_Spec = "";
    public static String lastResolutionSelected = "";
    public static String lastOpticalSettingsSelected = "";
    public static JRadioButton rdbtn_nm_Inter_Spec = new JRadioButton("nm");
    public static JRadioButton rdbtn_cm_Inter_Spec = new JRadioButton("cm\u207b\u00b9");
    static Label lbl_ModuleID_Inter_Spec;
    static XYLineChart spectrumChart_NM;
    static XYLineChart spectrumChart_CM;
    static ChartPanel spectrumChartPanel;
    public static final JCheckBox chb_AutoSave_Inter_Spec;
    public static final JCheckBox chb_EnableLinearInterpolation_Inter_Spec;
    static JButton btn_Run_Inter_Spec;
    static JButton btn_Capture_Interfero;
    static JButton btn_ClearGraphs_Inter_Spec;
    static JButton btn_LoadGraphs_Inter_Spec;
    static JButton btn_SaveGraphs_Inter_Spec;
    static JButton btn_Stop_Inter_Spec;
    static JButton btn_GainAdjustmentPanel_Inter_Spec;
    static JButton btn_WavelengthWavenumberCalibration_Inter_Spec;
    static JButton btn_WriteSettings_Inter_Spec;
    static JButton btn_RestoreDefault_Inter_Spec;
    static JButton btn_DeleteOpticalOption_Inter_Spec;
    static JComboBox<String> cmb_Optical_Settings_Inter_Spec;
    static JComboBox<String> cmb_Resolution_Inter_Spec;
    static JFormattedTextField txt_RunTime_Inter_Spec;
    static JComboBox<String> cmb_Wavenumber_No_Of_Points_Inter_Spec;
    static JComboBox<String> cmb_Apodization_Inter_Spec;
    static JComboBox<String> cmb_ZeroPadding_Inter_Spec;
    static Label lbl_advancedSettings_Inter_Spec;
    static Label lbl_FFT_Settings_Inter_Spec;
    static JSeparator separatorV1_Inter_Spec;
    static Label lbl_Apodization_Inter_Spec;
    static Label lbl_ZeroPadding_Inter_Spec;
    private int measurementCount_Spectrum = 0;
    public static final double PSD_X_NM_MIN = 1285.0;
    public static final double PSD_X_NM_MAX = 2615.0;
    public static final double PSD_X_CM_MIN = 3700.0;
    public static final double PSD_X_CM_MAX = 7795.0;
    public static final double PSD_Y_MIN = 0.0;
    public static final double PSD_Y_MAX = 1.2;
    private Label lbl_SpectrometerInfo_Inter_Spec;
    public static JRadioButton rdbtn_SingleRun_Inter_Spec;
    public static JRadioButton rdbtn_ContRun_Inter_Spec;
    private Label lblDataDisplay_Inter_Spec;
    private Label lblXaxis_Inter_Spec;
    private boolean genuineAction = false;

    public InterSpecPanel() {
        this.initialize();
    }

    public void initialize() {
        BufferedImage bufferedImage;
        Image image;
        File file;
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(new Color(176, 196, 222));
        this.setLayout((LayoutManager)new MigLayout("", "[90.00:90.00:90.00][45.00:45.00:45.00][45.00:45.00:45.00][30.00:30.00:30.00][30.00:30.00:30.00][30.00:30.00:30.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00][90.00:90.00:90.00][grow,fill][][][][][grow,fill]", "[][][][][][][][][][][][][][][][][][25.00:25.00:25.00][20:n][][][][][][][][][][][][grow,fill]"));
        this.lbl_SpectrometerInfo_Inter_Spec = new Label("NeoSpectra Micro kit Info");
        this.lbl_SpectrometerInfo_Inter_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)this.lbl_SpectrometerInfo_Inter_Spec, "cell 0 0 6 1");
        Label label = new Label("Kit ID");
        label.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label, "cell 0 1 2 1,growx");
        lbl_ModuleID_Inter_Spec = new Label(UserInterface.moduleID);
        lbl_ModuleID_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_ModuleID_Inter_Spec, "cell 2 1 2 1,alignx right");
        JSeparator jSeparator = new JSeparator();
        this.add((Component)jSeparator, "cell 0 2 6 1,growx");
        Label label2 = new Label("Measurement Parameters");
        label2.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label2, "cell 0 3 6 1,growx");
        Label label3 = new Label("Scan Time");
        label3.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label3, "cell 0 4,growx");
        txt_RunTime_Inter_Spec = new JFormattedTextField();
        txt_RunTime_Inter_Spec.setEditable(true);
        txt_RunTime_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        txt_RunTime_Inter_Spec.setText("2");
        txt_RunTime_Inter_Spec.setMinimumSize(new Dimension(110, InterSpecPanel.txt_RunTime_Inter_Spec.getPreferredSize().height));
        txt_RunTime_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.txt_RunTime_Inter_Spec.getPreferredSize().height));
        txt_RunTime_Inter_Spec.setPreferredSize(new Dimension(110, InterSpecPanel.txt_RunTime_Inter_Spec.getPreferredSize().height));
        this.add((Component)txt_RunTime_Inter_Spec, "cell 2 4 3 1,alignx left");
        Label label4 = new Label("s");
        label4.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label4, "cell 5 4,growx");
        Label label5 = new Label("Optical Gain Settings");
        label5.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label5, "cell 0 5,growx");
        cmb_Optical_Settings_Inter_Spec = new JComboBox();
        cmb_Optical_Settings_Inter_Spec.setEnabled(false);
        cmb_Optical_Settings_Inter_Spec.setEditable(false);
        cmb_Optical_Settings_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Optical_Settings_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        this.add(cmb_Optical_Settings_Inter_Spec, "cell 2 5 4 1,growx");
        cmb_Optical_Settings_Inter_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SpectroscopyPanel.cmb_Optical_Settings_Spec.setSelectedIndex(cmb_Optical_Settings_Inter_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                UserInterface.displaySpecOpticalSettings();
                UserInterface.displayInterSpecOpticalSettings();
            }
        });
        btn_DeleteOpticalOption_Inter_Spec = new JButton("");
        btn_DeleteOpticalOption_Inter_Spec.setEnabled(false);
        btn_DeleteOpticalOption_Inter_Spec.setVisible(true);
        btn_DeleteOpticalOption_Inter_Spec.setToolTipText("Delete the selected optical gain setting");
        btn_DeleteOpticalOption_Inter_Spec.setMaximumSize(new Dimension(30, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Inter_Spec.setMinimumSize(new Dimension(30, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Inter_Spec.setPreferredSize(new Dimension(30, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        btn_DeleteOpticalOption_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (cmb_Optical_Settings_Inter_Spec.getSelectedItem().toString().equals("Default")) {
                    JOptionPane.showMessageDialog(null, "Default Option cannot be deleted!", "Delete optical gain", 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + cmb_Optical_Settings_Inter_Spec.getSelectedItem().toString() + " ?", "Delete optical gain", 0) == 1) {
                    return;
                }
                UserInterface.deleteOpticalSetting(cmb_Optical_Settings_Inter_Spec.getSelectedItem().toString());
                UserInterface.displaySpecOpticalSettings();
                UserInterface.displayInterSpecOpticalSettings();
            }
        });
        this.add((Component)btn_DeleteOpticalOption_Inter_Spec, "cell 5 5,grow");
        Label label6 = new Label("Resolution");
        label6.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label6, "cell 0 6,growx");
        cmb_Resolution_Inter_Spec = new JComboBox();
        cmb_Resolution_Inter_Spec.setEnabled(false);
        cmb_Resolution_Inter_Spec.setEditable(false);
        cmb_Resolution_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Resolution_Inter_Spec.addItem("16 nm");
        cmb_Resolution_Inter_Spec.addItem("10 nm");
        cmb_Resolution_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.cmb_Resolution_Inter_Spec.getPreferredSize().height));
        this.add(cmb_Resolution_Inter_Spec, "cell 2 6 4 1,growx");
        cmb_Resolution_Inter_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SpectroscopyPanel.cmb_Resolution_Spec.setSelectedIndex(cmb_Resolution_Inter_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        Label label7 = new Label("Run Mode");
        label7.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label7, "cell 0 7,growx");
        ButtonGroup buttonGroup = new ButtonGroup();
        rdbtn_SingleRun_Inter_Spec = new JRadioButton("Single");
        rdbtn_SingleRun_Inter_Spec.setEnabled(false);
        rdbtn_SingleRun_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        rdbtn_SingleRun_Inter_Spec.setSelected(true);
        rdbtn_SingleRun_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                btn_Capture_Interfero.setEnabled(false);
            }
        });
        this.add((Component)rdbtn_SingleRun_Inter_Spec, "cell 1 7 2 1,growx");
        buttonGroup.add(rdbtn_SingleRun_Inter_Spec);
        btn_Run_Inter_Spec = new JButton("");
        btn_Run_Inter_Spec.setEnabled(false);
        btn_Run_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_Run_Inter_Spec.setText("Run");
        btn_Run_Inter_Spec.setVerticalTextPosition(3);
        btn_Run_Inter_Spec.setHorizontalTextPosition(0);
        btn_Run_Inter_Spec.setToolTipText("Run");
        btn_Run_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterSpecPanel.this.RunSequence();
                try {
                    logger.info((Object)("Run_Inter_Spec Finished (With PowerUp) - Scan Time = " + String.valueOf(Double.parseDouble(txt_RunTime_Inter_Spec.getText()) * 1000.0)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        rdbtn_ContRun_Inter_Spec = new JRadioButton("Cont.");
        rdbtn_ContRun_Inter_Spec.setEnabled(false);
        rdbtn_ContRun_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        rdbtn_ContRun_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                btn_Capture_Interfero.setEnabled(true);
            }
        });
        this.add((Component)rdbtn_ContRun_Inter_Spec, "cell 3 7 3 1,growx");
        buttonGroup.add(rdbtn_ContRun_Inter_Spec);
        this.add((Component)btn_Run_Inter_Spec, "cell 1 8 2 1,growx");
        btn_Stop_Inter_Spec = new JButton("Stop");
        btn_Stop_Inter_Spec.setEnabled(false);
        btn_Stop_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_Stop_Inter_Spec.setText("Stop");
        btn_Stop_Inter_Spec.setVerticalTextPosition(3);
        btn_Stop_Inter_Spec.setHorizontalTextPosition(0);
        btn_Stop_Inter_Spec.setToolTipText("Stop");
        btn_Stop_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopContinuousRun = true;
                UserInterface.isContinuousRun = false;
                UserInterface.statusLabel.setText("Stopping NeoSpectra Micro kit. Please wait...");
            }
        });
        this.add((Component)btn_Stop_Inter_Spec, "cell 3 8 3 1,growx");
        JSeparator jSeparator2 = new JSeparator();
        this.add((Component)jSeparator2, "cell 0 9 6 1,growx");
        btn_SaveGraphs_Inter_Spec = new JButton("");
        btn_SaveGraphs_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_SaveGraphs_Inter_Spec.setText("Save");
        btn_SaveGraphs_Inter_Spec.setVerticalTextPosition(3);
        btn_SaveGraphs_Inter_Spec.setHorizontalTextPosition(0);
        btn_SaveGraphs_Inter_Spec.setToolTipText("Save Plots");
        btn_SaveGraphs_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopEnablingButtons = true;
                UserInterface.boardReadyRoutine(false);
                btn_ClearGraphs_Inter_Spec.setEnabled(false);
                String[] stringArray = spectrumChart_NM.getSeriesKeys();
                int n = stringArray.length;
                for (String string : stringArray) {
                    double[][] dArray = spectrumChart_NM.getGraphData(string);
                    double[][] dArray2 = spectrumChart_CM.getGraphData(string);
                    if (rdbtn_nm_Inter_Spec.isSelected()) {
                        UserInterface.writeGraphFile(dArray[0], dArray[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)PSD_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavelength (nm)\ty_Axis:PSD (a.u.)");
                    } else {
                        UserInterface.writeGraphFile(dArray2[0], dArray2[1], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)PSD_PATH_TEMPLATE), (Object[])new Object[]{n}), "x_Axis:Wavenumber (cm-1)\ty_Axis:PSD (a.u.)");
                    }
                    --n;
                }
                SaveGraphsPanel saveGraphsPanel = new SaveGraphsPanel("_InterSpec_");
                SaveGraphsPanel.frmSaveGraphs.setVisible(true);
            }
        });
        this.add((Component)btn_SaveGraphs_Inter_Spec, "cell 0 11,growx");
        btn_LoadGraphs_Inter_Spec = new JButton("");
        btn_LoadGraphs_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_LoadGraphs_Inter_Spec.setText("Load");
        btn_LoadGraphs_Inter_Spec.setVerticalTextPosition(3);
        btn_LoadGraphs_Inter_Spec.setHorizontalTextPosition(0);
        btn_LoadGraphs_Inter_Spec.setToolTipText("Load Plot");
        btn_LoadGraphs_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!capture_Displayed_InterSpec && InterSpecPanel.this.measurementCount_Spectrum != 0) {
                    InterSpecPanel.this.measurementCount_Spectrum--;
                }
                capture_Displayed_InterSpec = false;
                JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setFileFilter(new FileNameExtensionFilter("Interferogram or PSD plots (*.Interferogram , *.InterPSD)", "Interferogram", "InterPSD"));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    for (File file : jFileChooser.getSelectedFiles()) {
                        InterSpecPanel.this.LoadCharts(file);
                    }
                    UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getParentFile().getAbsolutePath();
                }
            }
        });
        this.add((Component)btn_LoadGraphs_Inter_Spec, "cell 1 11 2 1,growx");
        btn_Capture_Interfero = new JButton("Capture");
        btn_Capture_Interfero.setEnabled(false);
        btn_Capture_Interfero.setToolTipText("Capture Plot");
        btn_Capture_Interfero.setFont(new Font("Dialog", 0, 10));
        btn_Capture_Interfero.setVerticalTextPosition(3);
        btn_Capture_Interfero.setHorizontalTextPosition(0);
        btn_Capture_Interfero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!capture_Displayed_InterSpec) {
                    capture_Displayed_InterSpec = true;
                    if (!InterSpecPanel.this.AutoSavePath_Inter_Spec.equals("") && capture_Displayed_InterSpec) {
                        try {
                            p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                            File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                            File[] fileArray = file.listFiles();
                            if (fileArray.length != 0) {
                                for (int i = 0; i < fileArray.length; ++i) {
                                    if (!fileArray[i].isFile() || !fileArray[i].getAbsolutePath().endsWith(".Interferogram") && !fileArray[i].getAbsolutePath().endsWith(".InterPSD")) continue;
                                    try {
                                        p3AppManagerUtils.createDir((String)InterSpecPanel.this.AutoSavePath_Inter_Spec);
                                        Files.copy(fileArray[i].toPath(), new File(InterSpecPanel.this.AutoSavePath_Inter_Spec + File.separatorChar + fileArray[i].getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        JOptionPane.showMessageDialog(null, "Failed to save files to the selected destination: " + exception.getMessage(), "Saving files", 0);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.add((Component)btn_Capture_Interfero, "cell 1 12 2 1,growx");
        JSeparator jSeparator3 = new JSeparator();
        this.add((Component)jSeparator3, "cell 0 13 6 1,growx");
        this.lblDataDisplay_Inter_Spec = new Label("Data Display");
        this.lblDataDisplay_Inter_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)this.lblDataDisplay_Inter_Spec, "cell 0 16,growx");
        Label label8 = new Label("Number of Data Points");
        label8.setFont(new Font("Dialog", 0, 10));
        this.add((Component)label8, "cell 0 18,growx");
        cmb_Wavenumber_No_Of_Points_Inter_Spec = new JComboBox();
        cmb_Wavenumber_No_Of_Points_Inter_Spec.setEnabled(false);
        cmb_Wavenumber_No_Of_Points_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Wavenumber_No_Of_Points_Inter_Spec.setPreferredSize(new Dimension(110, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        cmb_Wavenumber_No_Of_Points_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.cmb_Optical_Settings_Inter_Spec.getPreferredSize().height));
        cmb_Wavenumber_No_Of_Points_Inter_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.setSelectedIndex(cmb_Wavenumber_No_Of_Points_Inter_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.add(cmb_Wavenumber_No_Of_Points_Inter_Spec, "cell 2 18 4 1,growx");
        chb_EnableLinearInterpolation_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)chb_EnableLinearInterpolation_Inter_Spec, "cell 0 17 4 1,growx");
        chb_EnableLinearInterpolation_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectroscopyPanel.chb_EnableLinearInterpolation_Spectroscopy.setSelected(chb_EnableLinearInterpolation_Inter_Spec.isSelected());
                if (chb_EnableLinearInterpolation_Inter_Spec.isSelected()) {
                    cmb_Wavenumber_No_Of_Points_Inter_Spec.setEnabled(true);
                    UserInterface.displayCommonWVN();
                    cmb_Wavenumber_No_Of_Points_Inter_Spec.setSelectedIndex(4);
                    SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.setEnabled(true);
                    SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.setSelectedIndex(4);
                } else {
                    cmb_Wavenumber_No_Of_Points_Inter_Spec.setEnabled(false);
                    cmb_Wavenumber_No_Of_Points_Inter_Spec.removeAllItems();
                    SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.setEnabled(false);
                    SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.removeAllItems();
                }
            }
        });
        rdbtn_nm_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterSpecPanel.this.remove((Component)spectrumChartPanel);
                spectrumChartPanel = null;
                spectrumChartPanel = spectrumChart_NM.getChartPanel();
                spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                if (InterSpecPanel.this.measurementCount_Spectrum == 0) {
                    spectrumChartPanel.getChart().removeLegend();
                }
                spectrumChartPanel.repaint();
                spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                InterSpecPanel.this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
                InterSpecPanel.this.revalidate();
                InterSpecPanel.this.repaint();
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        rdbtn_nm_Inter_Spec.setSelected(true);
        rdbtn_nm_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_nm_Inter_Spec, "flowx,cell 1 19 2 1,aligny top");
        buttonGroup2.add(rdbtn_nm_Inter_Spec);
        rdbtn_cm_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterSpecPanel.this.remove((Component)spectrumChartPanel);
                spectrumChartPanel = null;
                spectrumChartPanel = spectrumChart_CM.getChartPanel();
                spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                if (InterSpecPanel.this.measurementCount_Spectrum == 0) {
                    spectrumChartPanel.getChart().removeLegend();
                }
                spectrumChartPanel.repaint();
                spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                InterSpecPanel.this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
                InterSpecPanel.this.revalidate();
                InterSpecPanel.this.repaint();
            }
        });
        rdbtn_cm_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)rdbtn_cm_Inter_Spec, "cell 3 19 3 1,aligny top");
        buttonGroup2.add(rdbtn_cm_Inter_Spec);
        this.lblXaxis_Inter_Spec = new Label("X-Axis:");
        this.lblXaxis_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)this.lblXaxis_Inter_Spec, "cell 0 19,growx,aligny top");
        Label label9 = new Label("Y-Axis:");
        label9.setFont(new Font("Dialog", 0, 10));
        label9.setVisible(false);
        this.add((Component)label9, "cell 0 20,growx,aligny top");
        JRadioButton jRadioButton = new JRadioButton("%Refl. or Trans.");
        jRadioButton.setFont(new Font("Dialog", 0, 10));
        jRadioButton.setVisible(false);
        this.add((Component)jRadioButton, "flowx,cell 1 20 2 1,aligny top");
        JRadioButton jRadioButton2 = new JRadioButton("Abs");
        jRadioButton2.setFont(new Font("Dialog", 0, 10));
        jRadioButton2.setVisible(false);
        this.add((Component)jRadioButton2, "cell 3 20 3 1,aligny top");
        lbl_advancedSettings_Inter_Spec = new Label("Advanced Settings");
        lbl_advancedSettings_Inter_Spec.setVisible(false);
        lbl_advancedSettings_Inter_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)lbl_advancedSettings_Inter_Spec, "cell 6 22 2 1,growx");
        lbl_FFT_Settings_Inter_Spec = new Label("FFT Settings");
        lbl_FFT_Settings_Inter_Spec.setVisible(false);
        lbl_FFT_Settings_Inter_Spec.setFont(new Font("Dialog", 1, 12));
        this.add((Component)lbl_FFT_Settings_Inter_Spec, "cell 12 22,growx");
        btn_GainAdjustmentPanel_Inter_Spec = new JButton("");
        btn_GainAdjustmentPanel_Inter_Spec.setVisible(false);
        btn_GainAdjustmentPanel_Inter_Spec.setEnabled(false);
        btn_GainAdjustmentPanel_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_GainAdjustmentPanel_Inter_Spec.setText("<html><center>Add New Optical Gain Setting</center></html>");
        btn_GainAdjustmentPanel_Inter_Spec.setVerticalTextPosition(0);
        btn_GainAdjustmentPanel_Inter_Spec.setHorizontalTextPosition(0);
        btn_GainAdjustmentPanel_Inter_Spec.setToolTipText("Add new optical gain setting");
        btn_GainAdjustmentPanel_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"OK"};
                int n = JOptionPane.showOptionDialog(null, "Please make sure that your sample is in the light path!", "Warning!", 0, 2, null, objectArray, objectArray[0]);
                if (n == -1) {
                    return;
                }
                if (n == 0) {
                    UserInterface.GainAdjustment();
                }
            }
        });
        this.add((Component)btn_GainAdjustmentPanel_Inter_Spec, "cell 6 23 2 1,grow");
        btn_WavelengthWavenumberCalibration_Inter_Spec = new JButton("");
        btn_WavelengthWavenumberCalibration_Inter_Spec.setVisible(false);
        btn_WavelengthWavenumberCalibration_Inter_Spec.setEnabled(false);
        btn_WavelengthWavenumberCalibration_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_WavelengthWavenumberCalibration_Inter_Spec.setText("<html><center>Wavelength Correction</center></html>");
        btn_WavelengthWavenumberCalibration_Inter_Spec.setVerticalTextPosition(0);
        btn_WavelengthWavenumberCalibration_Inter_Spec.setHorizontalTextPosition(0);
        btn_WavelengthWavenumberCalibration_Inter_Spec.setToolTipText("Wavelength & Wavenumber Correction");
        btn_WavelengthWavenumberCalibration_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.stopEnablingButtons = true;
                UserInterface.boardReadyRoutine(false);
                try {
                    int n = 0;
                    if (chb_EnableLinearInterpolation_Inter_Spec.isSelected()) {
                        n = cmb_Wavenumber_No_Of_Points_Inter_Spec.getSelectedIndex() + 1;
                    }
                    WL_WN_CalibrationPanel wL_WN_CalibrationPanel = new WL_WN_CalibrationPanel(String.valueOf(Double.parseDouble(txt_RunTime_Inter_Spec.getText()) * 1000.0), String.valueOf(cmb_Resolution_Inter_Spec.getSelectedIndex()), UserInterface.getOpticalGainValue((String)cmb_Optical_Settings_Inter_Spec.getSelectedItem()), String.valueOf(cmb_Apodization_Inter_Spec.getSelectedIndex()), String.valueOf(cmb_ZeroPadding_Inter_Spec.getSelectedIndex()), String.valueOf(n), "_InterSpec_");
                    WL_WN_CalibrationPanel.frmWL_Calib.setVisible(true);
                }
                catch (Exception exception) {
                    UserInterface.stopEnablingButtons = false;
                    UserInterface.boardReadyRoutine(true);
                    JOptionPane.showMessageDialog(null, "Failed to start. \n Please make sure that entries in measurement parameters are valid.", "Wavelength & Wavenumber Correction", 0);
                }
            }
        });
        this.add((Component)btn_WavelengthWavenumberCalibration_Inter_Spec, "cell 8 23 2 1,grow");
        lbl_Apodization_Inter_Spec = new Label("Apodization Function");
        lbl_Apodization_Inter_Spec.setVisible(false);
        lbl_Apodization_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_Apodization_Inter_Spec, "cell 12 23,growx");
        JLabel jLabel = new JLabel("");
        jLabel.setFont(new Font("Dialog", 1, 10));
        jLabel.setForeground(Color.WHITE);
        jLabel.setBackground(Color.WHITE);
        this.add((Component)jLabel, "cell 0 22 6 3,alignx left,aligny bottom");
        spectrumChart_NM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)""), "Wavelength (nm)", "PSD (a.u.)", new double[][]{{0.0}, {0.0}}, 1285.0, 2615.0, 0.0, 1.2);
        spectrumChart_CM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "PSD (a.u.)", new double[][]{{0.0}, {0.0}}, 3700.0, 7795.0, 0.0, 1.2);
        spectrumChartPanel = spectrumChart_NM.getChartPanel();
        spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
        spectrumChartPanel.getChart().removeLegend();
        spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
        this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
        Label label10 = new Label("Plots");
        label10.setFont(new Font("Dialog", 1, 12));
        this.add((Component)label10, "cell 0 10,growx");
        btn_ClearGraphs_Inter_Spec = new JButton("");
        btn_ClearGraphs_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_ClearGraphs_Inter_Spec.setText("Clear");
        btn_ClearGraphs_Inter_Spec.setVerticalTextPosition(3);
        btn_ClearGraphs_Inter_Spec.setHorizontalTextPosition(0);
        btn_ClearGraphs_Inter_Spec.setToolTipText("Clear Plots");
        btn_ClearGraphs_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File[] fileArray;
                clearingGraphsInProgress = true;
                p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                for (File file2 : fileArray = file.listFiles()) {
                    if (!file2.getAbsolutePath().endsWith(".Interferogram") && !file2.getAbsolutePath().endsWith(".InterPSD")) continue;
                    file2.delete();
                }
                spectrumChart_NM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)""), "Wavelength (nm)", "PSD (a.u.)", new double[][]{{0.0}, {0.0}}, 1285.0, 2615.0, 0.0, 1.2);
                spectrumChart_CM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)""), "Wavenumber (cm -\u00b9)", "PSD (a.u.)", new double[][]{{0.0}, {0.0}}, 3700.0, 7795.0, 0.0, 1.2);
                InterSpecPanel.this.remove((Component)spectrumChartPanel);
                spectrumChartPanel = null;
                spectrumChartPanel = spectrumChart_NM.getChartPanel();
                rdbtn_nm_Inter_Spec.setSelected(true);
                spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                spectrumChartPanel.getChart().removeLegend();
                spectrumChartPanel.repaint();
                spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                InterSpecPanel.this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
                InterSpecPanel.this.measurementCount_Spectrum = 0;
                UserInterface.frmMain.revalidate();
                UserInterface.frmMain.repaint();
                InterSpecPanel.this.AutoSavePath_Inter_Spec = "";
                if (chb_AutoSave_Inter_Spec.isSelected()) {
                    chb_AutoSave_Inter_Spec.setSelected(false);
                    JOptionPane.showMessageDialog(null, "Auto-save is disabled, please rechoose saving directory", "Auto-save Disabled!", 0);
                }
                clearingGraphsInProgress = false;
            }
        });
        this.add((Component)btn_ClearGraphs_Inter_Spec, "cell 3 11 3 1,growx");
        chb_AutoSave_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        chb_AutoSave_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser(){

                    @Override
                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (!UserInterface.checkEmptyDirectory(file.getAbsolutePath())) {
                            int n = JOptionPane.showConfirmDialog(this, "The chosen directory is not empty. Overwritting might occur, Are you sure you want to proceed?", "Directory not empty", 0);
                            switch (n) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case -1: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                            }
                        }
                        super.approveSelection();
                    }
                } : new JFileChooser(UserInterface.defaultDirectorySaveLoad){

                    @Override
                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (!UserInterface.checkEmptyDirectory(file.getAbsolutePath())) {
                            int n = JOptionPane.showConfirmDialog(this, "The chosen directory is not empty. Overwritting might occur, Are you sure you want to proceed?", "Directory not empty", 0);
                            switch (n) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case -1: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                            }
                        }
                        super.approveSelection();
                    }
                };
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setApproveButtonText("Save");
                jFileChooser.setDialogTitle("Save");
                if (chb_AutoSave_Inter_Spec.isSelected()) {
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        InterSpecPanel.this.AutoSavePath_Inter_Spec = jFileChooser.getSelectedFile().getAbsolutePath();
                        UserInterface.defaultDirectorySaveLoad = InterSpecPanel.this.AutoSavePath_Inter_Spec;
                    } else {
                        chb_AutoSave_Inter_Spec.setSelected(false);
                    }
                } else {
                    InterSpecPanel.this.AutoSavePath_Inter_Spec = "";
                }
            }
        });
        this.add((Component)chb_AutoSave_Inter_Spec, "cell 1 10 2 1,growx");
        separatorV1_Inter_Spec = new JSeparator();
        separatorV1_Inter_Spec.setVisible(false);
        separatorV1_Inter_Spec.setOrientation(1);
        this.add((Component)separatorV1_Inter_Spec, "cell 11 22 1 5,growy");
        btn_WriteSettings_Inter_Spec = new JButton("");
        btn_WriteSettings_Inter_Spec.setVisible(false);
        btn_WriteSettings_Inter_Spec.setEnabled(false);
        btn_WriteSettings_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        btn_WriteSettings_Inter_Spec.setText("Burn Settings");
        btn_WriteSettings_Inter_Spec.setVerticalTextPosition(0);
        btn_WriteSettings_Inter_Spec.setHorizontalTextPosition(0);
        btn_WriteSettings_Inter_Spec.setToolTipText("Burn current settings in kit's ROM");
        btn_WriteSettings_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.burnSequence();
            }
        });
        this.add((Component)btn_WriteSettings_Inter_Spec, "cell 6 24 2 1,growx");
        cmb_Apodization_Inter_Spec = new JComboBox();
        cmb_Apodization_Inter_Spec.setEnabled(false);
        cmb_Apodization_Inter_Spec.setVisible(false);
        cmb_Apodization_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        cmb_Apodization_Inter_Spec.setModel(new DefaultComboBoxModel<String>(p3Constants.apodizationOptions));
        cmb_Apodization_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.cmb_Apodization_Inter_Spec.getPreferredSize().height));
        cmb_Apodization_Inter_Spec.setMinimumSize(new Dimension(110, InterSpecPanel.cmb_Apodization_Inter_Spec.getPreferredSize().height));
        cmb_Apodization_Inter_Spec.setPreferredSize(new Dimension(110, InterSpecPanel.cmb_Apodization_Inter_Spec.getPreferredSize().height));
        this.add(cmb_Apodization_Inter_Spec, "cell 13 23 3 1,growx");
        cmb_Apodization_Inter_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SpectroscopyPanel.cmb_Apodization_Spec.setSelectedIndex(cmb_Apodization_Inter_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                cmb_Apodization_Inter_Spec.setModel(new DefaultComboBoxModel<String>(p3Constants.apodizationOptions));
                InterSpecPanel.this.genuineAction = true;
            }
        });
        cmb_Apodization_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                File file = null;
                if (InterSpecPanel.this.genuineAction) {
                    InterSpecPanel.this.genuineAction = false;
                    object = null;
                    if (cmb_Apodization_Inter_Spec.getSelectedItem().toString().startsWith("External Function")) {
                        JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
                        jFileChooser.setMultiSelectionEnabled(false);
                        jFileChooser.setFileFilter(new FileNameExtensionFilter("Apodization window coefficients (*.txt)", "txt"));
                        if (jFileChooser.showOpenDialog(null) == 0) {
                            file = jFileChooser.getSelectedFile();
                            object = p3AppManagerUtils.loadLongDataFile((String)file.getAbsolutePath());
                            long l = 0L;
                            for (Object object2 : object) {
                                l += object2;
                            }
                            if (object == null || ((Object)object).length > 20 || ((Object)object).length == 0 || l == 0L) {
                                cmb_Apodization_Inter_Spec.setSelectedIndex(0);
                                SpectroscopyPanel.cmb_Apodization_Spec.setSelectedIndex(cmb_Apodization_Inter_Spec.getSelectedIndex());
                                JOptionPane.showMessageDialog(null, "Invalid apodization window. \nPlease select a valid window coefficients between 1~20 coefficients", "Apodization window", 0);
                                object = null;
                                return;
                            }
                            UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getParentFile().getAbsolutePath();
                        }
                    }
                    UserInterface.applicationManager.setExternalApodizationWindow((long[])object);
                }
                if (file != null) {
                    object = file.getName().replace(".txt", "");
                    cmb_Apodization_Inter_Spec.setSelectedIndex(0);
                    cmb_Apodization_Inter_Spec.removeItemAt(cmb_Apodization_Inter_Spec.getItemCount() - 1);
                    cmb_Apodization_Inter_Spec.addItem((String)object);
                    cmb_Apodization_Inter_Spec.setSelectedIndex(cmb_Apodization_Inter_Spec.getItemCount() - 1);
                    SpectroscopyPanel.cmb_Apodization_Spec.removeItemAt(SpectroscopyPanel.cmb_Apodization_Spec.getItemCount() - 1);
                    SpectroscopyPanel.cmb_Apodization_Spec.addItem((String)object);
                    SpectroscopyPanel.cmb_Apodization_Spec.setSelectedIndex(SpectroscopyPanel.cmb_Apodization_Spec.getItemCount() - 1);
                } else {
                    SpectroscopyPanel.cmb_Apodization_Spec.setSelectedIndex(cmb_Apodization_Inter_Spec.getSelectedIndex());
                }
            }
        });
        lbl_ZeroPadding_Inter_Spec = new Label("Zero Padding");
        lbl_ZeroPadding_Inter_Spec.setVisible(false);
        lbl_ZeroPadding_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)lbl_ZeroPadding_Inter_Spec, "cell 12 24,growx");
        cmb_ZeroPadding_Inter_Spec = new JComboBox();
        cmb_ZeroPadding_Inter_Spec.setEnabled(false);
        cmb_ZeroPadding_Inter_Spec.setVisible(false);
        cmb_ZeroPadding_Inter_Spec.setFont(new Font("Dialog", 1, 10));
        for (int i = 0; i < p3Constants.paddingOptions.length; ++i) {
            cmb_ZeroPadding_Inter_Spec.addItem(p3Constants.paddingOptions[i] + " N");
        }
        cmb_ZeroPadding_Inter_Spec.setMaximumSize(new Dimension(110, InterSpecPanel.cmb_ZeroPadding_Inter_Spec.getPreferredSize().height));
        this.add(cmb_ZeroPadding_Inter_Spec, "cell 13 24 3 1,growx");
        cmb_ZeroPadding_Inter_Spec.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SpectroscopyPanel.cmb_ZeroPadding_Spec.setSelectedIndex(cmb_ZeroPadding_Inter_Spec.getSelectedIndex());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        btn_RestoreDefault_Inter_Spec = new JButton("Restore Default Settings");
        btn_RestoreDefault_Inter_Spec.setVisible(false);
        btn_RestoreDefault_Inter_Spec.setToolTipText("Restore Default Settings");
        btn_RestoreDefault_Inter_Spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserInterface.restoreSequence();
            }
        });
        btn_RestoreDefault_Inter_Spec.setEnabled(false);
        btn_RestoreDefault_Inter_Spec.setFont(new Font("Dialog", 0, 10));
        this.add((Component)btn_RestoreDefault_Inter_Spec, "cell 8 24 2 1,growx");
        try {
            file = new File(UserInterface.DELETE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(20, -1, 4);
                btn_DeleteOpticalOption_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Delete optical gain image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading  plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.LOAD_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_LoadGraphs_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Load plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading load plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.CAPTURE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Capture_Interfero.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Capture image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading capture image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.LOGO_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(264, 66, 4);
                jLabel.setHorizontalTextPosition(2);
                jLabel.setText("   ");
                jLabel.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Logo image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.SAVE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_SaveGraphs_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Save plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading save plots image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.STOP_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Stop_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Stop image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading Stop image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.RUN_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_Run_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Run image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading run image:" + iOException.getMessage(), "Loading image", 0);
        }
        try {
            file = new File(UserInterface.DELETE_IMAGE_PATH);
            if (file.exists()) {
                bufferedImage = image = ImageIO.read(file);
                image = bufferedImage.getScaledInstance(25, -1, 4);
                btn_ClearGraphs_Inter_Spec.setIcon(new ImageIcon(image));
            } else {
                JOptionPane.showMessageDialog(null, "Clear plots image doesn't exist.", "Loading image", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error loading clear plots image:" + iOException.getMessage(), "Loading image", 0);
        }
    }

    public void update(Object object) {
        if (object instanceof p3AppManagerNotification) {
            logger.info((Object)"update method started");
            p3AppManagerNotification p3AppManagerNotification2 = (p3AppManagerNotification)object;
            switch (p3AppManagerNotification2.getAction()) {
                case 1: {
                    logger.info((Object)"Run_Inter_Spec Finished");
                    if (!UserInterface.stopContinuousRun) {
                        if (p3AppManagerNotification2.getStatus() == 0) {
                            logger.info((Object)"Get Data of Run_Inter_Spec Started");
                            double[][] dArray = UserInterface.applicationManager.getInterSpecData();
                            logger.info((Object)"Get Data of Run_Inter_Spec Finished");
                            double[] dArray2 = UserInterface.switch_NM_CM(dArray[2]);
                            boolean bl = false;
                            if (!chb_EnableLinearInterpolation_Inter_Spec.isSelected()) {
                                String string = String.valueOf((int)dArray[4][0]);
                                string = string + " pts";
                                cmb_Wavenumber_No_Of_Points_Inter_Spec.removeAllItems();
                                SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.removeAllItems();
                                cmb_Wavenumber_No_Of_Points_Inter_Spec.addItem(string);
                                SpectroscopyPanel.cmb_Wavenumber_No_Of_Points_Spec.addItem(string);
                            }
                            if (!clearingGraphsInProgress) {
                                try {
                                    if (this.measurementCount_Spectrum == 0) {
                                        bl = true;
                                    }
                                    if (!capture_Displayed_InterSpec && this.measurementCount_Spectrum != 0) {
                                        --this.measurementCount_Spectrum;
                                    }
                                    ++this.measurementCount_Spectrum;
                                    if (this.measurementCount_Spectrum == 1 && bl) {
                                        spectrumChart_NM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavelength (nm)", "PSD (a.u.)", new double[][]{dArray2, dArray[3]}, true);
                                        spectrumChart_CM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavenumber (cm -\u00b9)", "PSD (a.u.)", new double[][]{dArray[2], dArray[3]}, true);
                                        bl = false;
                                    } else {
                                        spectrumChart_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), new double[][]{dArray2, dArray[3]}, true);
                                        spectrumChart_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), new double[][]{dArray[2], dArray[3]}, true);
                                    }
                                    capture_Displayed_InterSpec = false;
                                    this.remove((Component)spectrumChartPanel);
                                    spectrumChartPanel = null;
                                    spectrumChartPanel = rdbtn_nm_Inter_Spec.isSelected() ? spectrumChart_NM.getChartPanel() : spectrumChart_CM.getChartPanel();
                                    spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                                    spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                                    this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
                                    spectrumChartPanel.repaint();
                                }
                                catch (Exception exception) {
                                    logger.error((Object)exception.getMessage());
                                }
                                if (dArray != null) {
                                    logger.info((Object)"writing plot to file started");
                                    this.writeRunDataFile(dArray, p3AppManagerNotification2.getDeviceId());
                                    logger.info((Object)"writing plot to file finished");
                                }
                            }
                            dArray = null;
                            dArray2 = null;
                            if (UserInterface.stopContinuousRun || !UserInterface.isContinuousRun || !rdbtn_ContRun_Inter_Spec.isSelected()) {
                                UserInterface.statusLabel.setText("Measurement completed successfully.");
                                UserInterface.colorLabel.setForeground(Color.green.darker());
                                UserInterface.colorLabel.setBackground(Color.green.darker());
                                UserInterface.progressTime = -1.0;
                                UserInterface.progressPar.setValue(100);
                            }
                        } else {
                            UserInterface.colorLabel.setForeground(Color.red);
                            UserInterface.colorLabel.setBackground(Color.red);
                            UserInterface.progressTime = -1.0;
                            UserInterface.progressPar.setValue(100);
                            JOptionPane.showMessageDialog(null, UserInterface.convertErrorCodesToMessages(p3AppManagerNotification2.getStatus()), "Run NeoSpectra Micro", 0);
                            btn_Stop_Inter_Spec.doClick();
                        }
                    }
                    if (!UserInterface.stopContinuousRun && UserInterface.isContinuousRun && rdbtn_ContRun_Inter_Spec.isSelected()) {
                        UserInterface.releaseDeviceToken();
                        this.RunSequence();
                        try {
                            logger.info((Object)("Run_Inter_Spec Finished (Without PowerUp) - Scan Time = " + String.valueOf(Double.parseDouble(txt_RunTime_Inter_Spec.getText()) * 1000.0)));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    if (rdbtn_ContRun_Inter_Spec.isSelected()) {
                        UserInterface.colorLabel.setForeground(Color.green.darker());
                        UserInterface.colorLabel.setBackground(Color.green.darker());
                    }
                    logger.info((Object)"enabling GUI fields started");
                    UserInterface.boardReadyRoutine(true);
                    logger.info((Object)"enabling GUI fields finished");
                    boolean bl = btn_Capture_Interfero.isEnabled();
                    btn_Capture_Interfero.setEnabled(true);
                    btn_Capture_Interfero.doClick();
                    btn_Capture_Interfero.setEnabled(bl);
                    UserInterface.releaseDeviceToken();
                    UserInterface.checkDeviceStatusThreadStop = false;
                    break;
                }
            }
        }
    }

    boolean writeRunDataFile(double[][] dArray, String string) {
        double[] dArray2 = UserInterface.switch_NM_CM(dArray[2]);
        if (rdbtn_nm_Inter_Spec.isSelected()) {
            if (!UserInterface.writeGraphFile(dArray2, dArray[3], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)PSD_PATH_TEMPLATE), (Object[])new Object[]{this.measurementCount_Spectrum}), "x_Axis:Wavelength (nm)\ty_Axis:PSD (a.u.)")) {
                throw new p3AppManagerException("Error writing write PSD file    ", p3Enumerations.p3AppManagerStatus.PSD_FILE_CREATION_ERROR.getNumVal());
            }
        } else if (!UserInterface.writeGraphFile(dArray[2], dArray[3], p3AppManagerUtils.formatString((String)p3Constants.getPath((String)PSD_PATH_TEMPLATE), (Object[])new Object[]{this.measurementCount_Spectrum}), "x_Axis:Wavenumber (cm-1)\ty_Axis:PSD (a.u.)")) {
            throw new p3AppManagerException("Error while writing PSD file    ", p3Enumerations.p3AppManagerStatus.PSD_FILE_CREATION_ERROR.getNumVal());
        }
        dArray2 = null;
        return true;
    }

    private void RunSequence() {
        UserInterface.isContinuousRun = true;
        UserInterface.stopContinuousRun = false;
        logger.info((Object)"RunSequence function started");
        if (!UserInterface.stopContinuousRun) {
            try {
                UserInterface.checkDeviceStatusThreadStop = true;
                int n = 0;
                if (chb_EnableLinearInterpolation_Inter_Spec.isSelected()) {
                    n = cmb_Wavenumber_No_Of_Points_Inter_Spec.getSelectedIndex() + 1;
                }
                UserInterface.progressTime = Double.parseDouble(txt_RunTime_Inter_Spec.getText().toString()) * 1000.0;
                UserInterface.progressPar.setValue(0);
                logger.info((Object)"runInterSpec function started");
                while (!UserInterface.acquireDeviceToken()) {
                }
                p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = UserInterface.applicationManager.runInterSpec(new String[]{String.valueOf(Double.parseDouble(txt_RunTime_Inter_Spec.getText()) * 1000.0), Integer.toString(cmb_Apodization_Inter_Spec.getSelectedIndex()), Integer.toString(cmb_ZeroPadding_Inter_Spec.getSelectedIndex()), UserInterface.getOpticalGainValue((String)cmb_Optical_Settings_Inter_Spec.getSelectedItem()), String.valueOf(n), Integer.toString(rdbtn_ContRun_Inter_Spec.isSelected() ? 1 : 0), Integer.toString(cmb_Resolution_Inter_Spec.getSelectedIndex())});
                logger.info((Object)"runInterSpec function finished");
                if (p3Enumerations.p3AppManagerStatus.NO_ERROR != p3AppManagerStatus2) {
                    if (p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR != p3AppManagerStatus2) {
                        UserInterface.checkDeviceStatusThreadStop = false;
                    }
                    JOptionPane.showMessageDialog(null, "Run failed to start: " + UserInterface.convertErrorCodesToMessages(p3AppManagerStatus2), "Run NeoSpectra Micro", 0);
                    UserInterface.stopContinuousRun = true;
                    UserInterface.isContinuousRun = false;
                    UserInterface.releaseDeviceToken();
                } else {
                    logger.info((Object)"disabling GUI fields started");
                    UserInterface.boardReadyRoutine(false);
                    logger.info((Object)"disabling GUI fields finished");
                    UserInterface.statusLabel.setText("Run started. Please wait...");
                    UserInterface.colorLabel.setForeground(Color.yellow);
                    UserInterface.colorLabel.setBackground(Color.yellow);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Run failed to start. \n Please make sure that the entries in measurement parameters are valid.", "Run NeoSpectra Micro", 0);
                UserInterface.stopContinuousRun = true;
                UserInterface.isContinuousRun = false;
                UserInterface.boardReadyRoutine(true);
                UserInterface.releaseDeviceToken();
                UserInterface.checkDeviceStatusThreadStop = false;
            }
        }
        UserInterface.frmMain.revalidate();
        UserInterface.frmMain.repaint();
    }

    private void LoadCharts(File file) {
        double[][] dArray = UserInterface.loadGraphDataFromFile(file.getAbsolutePath());
        if (dArray == null) {
            return;
        }
        try {
            if (file.getAbsolutePath().endsWith(".InterPSD")) {
                this.remove((Component)spectrumChartPanel);
                ++this.measurementCount_Spectrum;
                double[] dArray2 = UserInterface.switch_NM_CM(dArray[0]);
                if (this.measurementCount_Spectrum == 1) {
                    if (rdbtn_nm_Inter_Spec.isSelected()) {
                        spectrumChart_NM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavelength (nm)", "PSD (a.u.)", dArray);
                        spectrumChart_CM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavenumber (cm -\u00b9)", "PSD (a.u.)", new double[][]{dArray2, dArray[1]});
                    } else {
                        spectrumChart_CM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavenumber (cm -\u00b9)", "PSD (a.u.)", dArray);
                        spectrumChart_NM = new XYLineChart("Power Spectral Density (PSD)", (Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), "Wavelength (nm)", "PSD (a.u.)", new double[][]{dArray2, dArray[1]});
                    }
                } else if (rdbtn_nm_Inter_Spec.isSelected()) {
                    spectrumChart_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), dArray);
                    spectrumChart_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), new double[][]{dArray2, dArray[1]});
                } else {
                    spectrumChart_CM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), dArray);
                    spectrumChart_NM.addSeries((Comparable<String>)((Object)("Measurement No. " + this.measurementCount_Spectrum)), new double[][]{dArray2, dArray[1]});
                }
                spectrumChartPanel = rdbtn_nm_Inter_Spec.isSelected() ? spectrumChart_NM.getChartPanel() : spectrumChart_CM.getChartPanel();
                spectrumChartPanel.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, true));
                spectrumChartPanel.repaint();
                spectrumChartPanel.setPreferredSize(new Dimension((int)spectrumChartPanel.getPreferredSize().getWidth(), (int)UserInterface.screenSize.getHeight()));
                this.add((Component)spectrumChartPanel, "cell 6 0 10 21, grow");
                p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
                File file2 = new File(p3AppManagerUtils.formatString((String)p3Constants.getPath((String)PSD_PATH_TEMPLATE), (Object[])new Object[]{this.measurementCount_Spectrum}));
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            boolean bl = btn_Capture_Interfero.isEnabled();
            btn_Capture_Interfero.setEnabled(true);
            btn_Capture_Interfero.doClick();
            btn_Capture_Interfero.setEnabled(bl);
            this.repaint();
            UserInterface.frmMain.revalidate();
            UserInterface.frmMain.repaint();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to save measurement data files in the temporary directory: " + exception.getMessage(), "Saving files", 0);
        }
    }

    public static void saveGraphsRoutine() {
        p3AppManagerUtils.createDir((String)p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File file = new File(p3Constants.getPath((String)UserInterface.GRAPH_FILES_FOLDER_PATH));
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = UserInterface.fileNameToSave.equals("!Default!") ? fileArray[i].getName() : UserInterface.fileNameToSave + fileArray[i].getName().substring(fileArray[i].getName().indexOf("_"));
        }
        JFileChooser jFileChooser = UserInterface.defaultDirectorySaveLoad.equals("") || !new File(UserInterface.defaultDirectorySaveLoad).exists() ? new JFileChooser() : new JFileChooser(UserInterface.defaultDirectorySaveLoad);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonText("Save");
        jFileChooser.setDialogTitle("Save");
        if (stringArray.length != 0 && jFileChooser.showOpenDialog(null) == 0) {
            p3AppManagerUtils.createDir((String)jFileChooser.getSelectedFile().getAbsolutePath());
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].getAbsolutePath().endsWith(".Interferogram") && !fileArray[i].getAbsolutePath().endsWith(".InterPSD")) continue;
                try {
                    if (new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).exists()) {
                        if (n == -1) {
                            int n2 = JOptionPane.showConfirmDialog(null, "The chosen directory has plot(s) with the same name, overwrite all?", "Overwrite", 0);
                            switch (n2) {
                                case 0: {
                                    n = 1;
                                    Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    break;
                                }
                                case -1: {
                                    n = 0;
                                    break;
                                }
                                case 1: {
                                    n = 0;
                                }
                            }
                            continue;
                        }
                        if (n != 1) continue;
                        Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    Files.copy(fileArray[i].toPath(), new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separatorChar + stringArray[i]).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Failed to save files to the selected destination: " + exception.getMessage(), "Saving files", 0);
                    return;
                }
            }
            UserInterface.defaultDirectorySaveLoad = jFileChooser.getSelectedFile().getAbsolutePath();
        }
    }

    static {
        spectrumChart_NM = null;
        spectrumChart_CM = null;
        spectrumChartPanel = null;
        chb_AutoSave_Inter_Spec = new JCheckBox("Auto-save");
        chb_EnableLinearInterpolation_Inter_Spec = new JCheckBox("Enable linear interpolaion");
    }
}

