/*
 * Decompiled with CFR 0.152.
 */
package sws.p3AppManager_micro.devices;

import java.io.File;
import org.apache.log4j.Logger;
import sws.p3AppManager_micro.P3Driver;
import sws.p3AppManager_micro.configuration.p3RunConfig;
import sws.p3AppManager_micro.devices.p3Device;
import sws.p3AppManager_micro.jobs.p3AbstractJob;
import sws.p3AppManager_micro.jobs.p3JobManager;
import sws.p3AppManager_micro.utils.p3AppManagerException;
import sws.p3AppManager_micro.utils.p3AppManagerUtils;
import sws.p3AppManager_micro.utils.p3Constants;
import sws.p3AppManager_micro.utils.p3DeviceNotificationResult;
import sws.p3AppManager_micro.utils.p3Enumerations;

public class p3Sample
extends p3Device {
    private static Logger logger = Logger.getLogger(p3Sample.class);
    private String sampleId = "";
    private p3Enumerations.p3AppManagerState state;
    private double[][] SpecResult = null;
    private double[][] bgSpecResult = null;
    private double[][] bgWL_CalibResult = null;
    private long[] externalApodizationWindow = null;
    private double[][] GainAdjustSpec_Result = null;
    private double[][] interSpecResult = null;
    private double[][] rawData = null;
    private double lastBGTime = 0.0;
    private double gainAdjustError = 1.0;
    private String productId = "21845";
    private P3Driver driver;
    int[][] PGAs_values = new int[][]{{0, 0, 1}, {1, 0, 2}, {1, 1, 4}, {3, 0, 6}, {2, 1, 8}, {5, 0, 10}, {3, 1, 12}, {2, 2, 16}, {5, 1, 20}, {3, 2, 24}, {4, 2, 32}, {3, 3, 36}, {5, 2, 40}, {4, 3, 48}, {5, 3, 60}, {4, 4, 64}, {5, 4, 80}, {5, 5, 100}};

    public p3Sample() {
        this.state = p3Enumerations.p3AppManagerState.Idle;
        this.driver = new P3Driver(Integer.parseInt(this.productId), p3Constants.APPLICATION_WORKING_DIRECTORY);
    }

    private p3Enumerations.p3AppManagerState getState() {
        return this.state;
    }

    private void setState(p3Enumerations.p3AppManagerState p3AppManagerState2) {
        logger.info((Object)("------State Change------From------" + (Object)((Object)this.state) + "-----To-----" + (Object)((Object)p3AppManagerState2)));
        this.state = p3AppManagerState2;
    }

    @Override
    public String getDeviceId() {
        return this.sampleId;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus initializeCore(String ... stringArray) {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.BOARD_ALREADY_INITIALIZED == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            this.setState(p3Enumerations.p3AppManagerState.Initialize);
            this.executeIntiliazation();
        }
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus checkDeviceStatus(String ... stringArray) {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            if (p3Enumerations.p3AppManagerState.Initialize == this.getState()) {
                return p3Enumerations.p3AppManagerStatus.INITIALIZATION_IN_PROGRESS;
            }
            return p3Enumerations.p3AppManagerStatus.NO_ERROR;
        }
        this.setState(p3Enumerations.p3AppManagerState.CheckingDeviceStatus);
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        this.setState(p3Enumerations.p3AppManagerState.Idle);
        logger.info((Object)("checkBoardStatus method returned : " + p3AppManagerStatus2.toString()));
        if (p3Enumerations.p3AppManagerStatus.BOARD_ALREADY_INITIALIZED == p3AppManagerStatus2) {
            return p3Enumerations.p3AppManagerStatus.NO_ERROR;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            p3AppManagerStatus2 = this.initializeCore(new String[0]);
        } else if (p3AppManagerStatus2 == p3Enumerations.p3AppManagerStatus.INITIATE_TAIFDRIVER_ERROR) {
            logger.error((Object)"INITIATE_TAIFDRIVER_ERROR returned but the application manager swallowed it");
            return p3Enumerations.p3AppManagerStatus.INITIALIZATION_IN_PROGRESS;
        }
        return p3AppManagerStatus2;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runSpec(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 8 && stringArray.length != 2) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        boolean bl2 = Boolean.parseBoolean(stringArray[1]);
        try {
            if (bl2) {
                if (this.bgSpecResult == null) {
                    return p3Enumerations.p3AppManagerStatus.NO_VALID_BG_DATA_ERROR;
                }
                if (this.lastBGTime < Double.parseDouble(stringArray[0])) {
                    return p3Enumerations.p3AppManagerStatus.INVALID_RUN_TIME_NOT_EQUAL_BG_RUN_TIME_ERROR;
                }
                p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunSpecSample, stringArray);
                this.SpecResult = null;
            } else {
                this.lastBGTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunSpecBackground, stringArray);
                this.bgSpecResult = null;
            }
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus wavelengthCalibrationBG(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 6) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.state) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        try {
            this.bgWL_CalibResult = null;
            p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunWavelengthCalibrationBG, stringArray);
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus wavelengthCalibration(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 7) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.state) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        try {
            if (this.bgWL_CalibResult == null) {
                return p3Enumerations.p3AppManagerStatus.NO_VALID_BG_DATA_ERROR;
            }
            p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunWavelengthCalibration, stringArray);
            double[] dArray = p3AppManagerUtils.loadRawDataFile(p3Constants.getPath(p3Constants.STANDARD_CALIBRATORS_FOLDER_PATH) + File.separatorChar + p3RunConfig2.standardCalibratorType + ".txt");
            p3RunConfig2.CalibrationWells = new int[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                p3RunConfig2.CalibrationWells[i] = (int)(dArray[i] * Math.pow(2.0, 20.0));
            }
            if (p3RunConfig2.CalibrationWells == null) {
                throw new p3AppManagerException("Failed to load standard calibrator file ", p3Enumerations.p3AppManagerStatus.WHITE_FILE_NOT_EXIST_ERROR.getNumVal());
            }
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public double getErrorData() {
        return this.gainAdjustError;
    }

    @Override
    public double[][] getSpecData() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            logger.error((Object)"p2Device is busy now");
            return null;
        }
        if (this.SpecResult == null) {
            logger.error((Object)"there is no Spec data may be you don't have any successful spec run ");
            return null;
        }
        return this.SpecResult;
    }

    @Override
    public void setExternalApodizationWindow(long[] lArray) {
        if (lArray == null) {
            this.externalApodizationWindow = null;
            return;
        }
        this.externalApodizationWindow = new long[lArray.length];
        System.arraycopy(lArray, 0, this.externalApodizationWindow, 0, lArray.length);
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runInterSpec(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 7 && stringArray.length != 1) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        this.interSpecResult = null;
        try {
            p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunInterSpec, stringArray);
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.setState(p3Enumerations.p3AppManagerState.InterferogramRun);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runCalibCorr(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 5) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        this.interSpecResult = null;
        try {
            p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunSelfCorr, stringArray);
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.setState(p3Enumerations.p3AppManagerState.selfCorr_Run);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public double[][] getRawData() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            logger.error((Object)"p2Device is busy now");
            return null;
        }
        if (this.rawData == null) {
            logger.error((Object)"there is no raw data may be you don't have any successful runs ");
            return null;
        }
        return this.rawData;
    }

    @Override
    public double[][] getInterSpecData() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            logger.error((Object)"p2Device is busy now");
            return null;
        }
        if (this.interSpecResult == null) {
            logger.error((Object)"there is no interSpec data may be you don't have any successful interspec run ");
            return null;
        }
        return this.interSpecResult;
    }

    @Override
    public double[][] getGainAdjustSpecData() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            logger.error((Object)"p2Device is busy now");
            return null;
        }
        if (this.GainAdjustSpec_Result == null) {
            logger.error((Object)"there is no valid data");
            return null;
        }
        return this.GainAdjustSpec_Result;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus restoreDefaultSettings(String ... stringArray) {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.RestoreDefault;
        p3RunConfig2.restoreOption = stringArray.length != 0 ? stringArray[0] : p3Enumerations.RestoreOptionsEnum.ALL.getStringVal();
        this.setState(p3Enumerations.p3AppManagerState.RestoreDefault);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus sleepAction() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.SleepAction;
        this.setState(p3Enumerations.p3AppManagerState.SleepAction);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus wakeUpAction() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.WakeUpAction;
        this.setState(p3Enumerations.p3AppManagerState.WakeUpAction);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus powerOff() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.PowerOff;
        this.setState(p3Enumerations.p3AppManagerState.PowerOff);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus powerOn() {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.PowerOn;
        this.setState(p3Enumerations.p3AppManagerState.PowerOn);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public p3Enumerations.p3AppManagerStatus burnSettingsSpecificSettings(String ... stringArray) {
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        p3RunConfig p3RunConfig2 = new p3RunConfig();
        p3RunConfig2.runType = p3Enumerations.p3AppManagerState.BurnSettings;
        p3RunConfig2.burnMode = Integer.parseInt(stringArray[0]);
        this.setState(p3Enumerations.p3AppManagerState.BurnSettings);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    @Override
    public String[] getSoftwareVersion() {
        return this.driver.readSWVersion();
    }

    @Override
    public p3Enumerations.p3AppManagerStatus runSpecGainAdjBG(String ... stringArray) {
        p3RunConfig p3RunConfig2;
        if (stringArray.length != 1) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        if (p3Enumerations.p3AppManagerState.Idle != this.getState()) {
            return p3Enumerations.p3AppManagerStatus.DEVICE_BUSY_ERROR;
        }
        boolean bl = false;
        p3Enumerations.p3AppManagerStatus p3AppManagerStatus2 = this.checkBoardStatus();
        if (p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR == p3AppManagerStatus2 || p3Enumerations.p3AppManagerStatus.UNKNOWN_ERROR == p3AppManagerStatus2) {
            return p3AppManagerStatus2;
        }
        if (p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR == p3AppManagerStatus2) {
            bl = true;
        }
        try {
            p3RunConfig2 = this.initiateRunConfig(p3Enumerations.p3DeviceAction.RunGainAdjustSpecBG, stringArray);
        }
        catch (p3AppManagerException p3AppManagerException2) {
            return p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode());
        }
        catch (Exception exception) {
            return p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR;
        }
        this.setState(p3Enumerations.p3AppManagerState.gainAdjustSpecBG_Run);
        this.executeRunSpecByRunType(p3RunConfig2, bl);
        return p3Enumerations.p3AppManagerStatus.NO_ERROR;
    }

    private void executeIntiliazation() {
        try {
            this.taifDriverInitiation();
            this.setFinalResultAndnotifyObservers(p3Enumerations.p3DeviceAction.initializeCore, null, p3Enumerations.p3AppManagerStatus.NO_ERROR);
        }
        catch (p3AppManagerException p3AppManagerException2) {
            logger.error((Object)p3AppManagerException2.getMessage());
            this.setFinalResultAndnotifyObservers(p3Enumerations.p3DeviceAction.initializeCore, null, p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException2.getErrorCode()));
        }
    }

    private void executeRunSpecByRunType(final p3RunConfig p3RunConfig2, boolean bl) {
        p3JobManager.submit(new p3AbstractJob<Boolean>(){

            @Override
            protected Boolean execute() {
                try {
                    double[][] dArray = null;
                    int n = 0;
                    while (n < 4) {
                        p3RunConfig p3RunConfig22 = (p3RunConfig)p3RunConfig2.clone();
                        try {
                            dArray = p3Sample.this.driver.runOperation(p3RunConfig22);
                            break;
                        }
                        catch (p3AppManagerException p3AppManagerException2) {
                            System.out.println("trial no. " + ++n + " failed. error code is " + p3AppManagerException2.getErrorCode());
                            logger.error((Object)("trial no. " + n + " failed. error code is " + p3AppManagerException2.getErrorCode()));
                            if (n == 4) {
                                throw p3AppManagerException2;
                            }
                            if (p3AppManagerException2.getErrorCode() != 400) continue;
                            throw p3AppManagerException2;
                        }
                    }
                    if (dArray == null) {
                        throw new p3AppManagerException("No valid result back for this p2Sample : " + p3Sample.this.sampleId + " run.", p3Enumerations.p3AppManagerStatus.NO_OF_SCANS_DSP_ERROR.getNumVal());
                    }
                    p3Sample.this.setFinalResultAndnotifyObservers(p3RunConfig2.runType.getDeviceAtion(), dArray, p3Enumerations.p3AppManagerStatus.NO_ERROR);
                }
                catch (p3AppManagerException p3AppManagerException3) {
                    logger.error((Object)p3AppManagerException3.getMessage());
                    p3Sample.this.setFinalResultAndnotifyObservers(p3RunConfig2.runType.getDeviceAtion(), null, p3Enumerations.p3AppManagerStatus.getAppManagerStatusByCode(p3AppManagerException3.getErrorCode()));
                }
                catch (Exception exception) {
                    p3Sample.this.setFinalResultAndnotifyObservers(p3RunConfig2.runType.getDeviceAtion(), null, p3Enumerations.p3AppManagerStatus.DATA_STREAMING_ERROR);
                }
                return true;
            }
        });
    }

    private void taifDriverInitiation() {
        this.driver.initiateTAIF(new boolean[0]);
        try {
            this.sampleId = this.driver.readROMID();
        }
        catch (Exception exception) {
            this.sampleId = "sampleId";
        }
    }

    private p3Enumerations.p3AppManagerStatus checkBoardStatus() {
        int n = this.driver.checkBoardStatus();
        if (n == 14) {
            return p3Enumerations.p3AppManagerStatus.BOARD_DISTCONNECTED_ERROR;
        }
        if (n == 74) {
            return p3Enumerations.p3AppManagerStatus.BOARD_NOT_INITIALIZED_ERROR;
        }
        return p3Enumerations.p3AppManagerStatus.BOARD_ALREADY_INITIALIZED;
    }

    private p3RunConfig initiateRunConfig(p3Enumerations.p3DeviceAction p3DeviceAction2, String ... stringArray) throws p3AppManagerException, Exception {
        p3RunConfig p3RunConfig2;
        switch (p3DeviceAction2) {
            case RunInterSpec: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                if (stringArray.length == 7 && (p3AppManagerUtils.isEmptyString(stringArray[1]) || p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4]) || p3AppManagerUtils.isEmptyString(stringArray[5]) || p3AppManagerUtils.isEmptyString(stringArray[6]))) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.INTER_SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                if (stringArray.length == 7) {
                    p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[1]);
                    p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[2]);
                    if (Integer.parseInt(stringArray[3]) != -1) {
                        p3RunConfig2.gainIndex = 2;
                        p3RunConfig2.gainValue = Integer.parseInt(stringArray[3]);
                    } else {
                        p3RunConfig2.gainIndex = 0;
                        p3RunConfig2.gainValue = 0;
                    }
                    p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[4]);
                    p3RunConfig2.mode = Integer.parseInt(stringArray[5]);
                    p3RunConfig2.resolution = Integer.parseInt(stringArray[6]);
                } else {
                    p3RunConfig2.apodizationIndex = 0;
                    p3RunConfig2.zeroPaddingMultiplier = 1;
                    p3RunConfig2.resolution = 0;
                }
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.InterferogramRun;
                break;
            }
            case RunSpecBackground: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0]) || p3AppManagerUtils.isEmptyString(stringArray[1])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                if (stringArray.length == 8 && (p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4]) || p3AppManagerUtils.isEmptyString(stringArray[5]) || p3AppManagerUtils.isEmptyString(stringArray[6]) || p3AppManagerUtils.isEmptyString(stringArray[7]))) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.BG_SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                if (stringArray.length == 8) {
                    p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[2]);
                    p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[3]);
                    if (Integer.parseInt(stringArray[4]) != -1) {
                        p3RunConfig2.gainIndex = 2;
                        p3RunConfig2.gainValue = Integer.parseInt(stringArray[4]);
                    } else {
                        p3RunConfig2.gainIndex = 0;
                        p3RunConfig2.gainValue = 0;
                    }
                    p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[5]);
                    p3RunConfig2.mode = Integer.parseInt(stringArray[6]);
                    p3RunConfig2.resolution = Integer.parseInt(stringArray[7]);
                } else {
                    p3RunConfig2.apodizationIndex = 0;
                    p3RunConfig2.zeroPaddingMultiplier = 1;
                    p3RunConfig2.resolution = 0;
                }
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.SpectroscopyBackgroundRun;
                this.setState(p3Enumerations.p3AppManagerState.SpectroscopyBackgroundRun);
                break;
            }
            case RunSpecSample: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0]) || p3AppManagerUtils.isEmptyString(stringArray[1])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                if (stringArray.length == 8 && (p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4]) || p3AppManagerUtils.isEmptyString(stringArray[5]) || p3AppManagerUtils.isEmptyString(stringArray[6]) || p3AppManagerUtils.isEmptyString(stringArray[7]))) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                if (stringArray.length == 8) {
                    p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[2]);
                    p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[3]);
                    if (Integer.parseInt(stringArray[4]) != -1) {
                        p3RunConfig2.gainIndex = 2;
                        p3RunConfig2.gainValue = Integer.parseInt(stringArray[4]);
                    } else {
                        p3RunConfig2.gainIndex = 0;
                        p3RunConfig2.gainValue = 0;
                    }
                    p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[5]);
                    p3RunConfig2.mode = Integer.parseInt(stringArray[6]);
                    p3RunConfig2.resolution = Integer.parseInt(stringArray[7]);
                } else {
                    p3RunConfig2.apodizationIndex = 0;
                    p3RunConfig2.zeroPaddingMultiplier = 1;
                    p3RunConfig2.resolution = 0;
                }
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.SpectroscopySampleRun;
                this.setState(p3Enumerations.p3AppManagerState.SpectroscopySampleRun);
                break;
            }
            case RunWavelengthCalibrationBG: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0]) || p3AppManagerUtils.isEmptyString(stringArray[1]) || p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4]) || p3AppManagerUtils.isEmptyString(stringArray[5])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.BG_SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[1]);
                p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[2]);
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.wavelengthCalibrationBG_Run;
                if (Integer.parseInt(stringArray[3]) != -1) {
                    p3RunConfig2.gainIndex = 2;
                    p3RunConfig2.gainValue = Integer.parseInt(stringArray[3]);
                } else {
                    p3RunConfig2.gainIndex = 0;
                    p3RunConfig2.gainValue = 0;
                }
                p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[4]);
                p3RunConfig2.resolution = Integer.parseInt(stringArray[5]);
                this.setState(p3Enumerations.p3AppManagerState.wavelengthCalibrationBG_Run);
                break;
            }
            case RunWavelengthCalibration: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0]) || p3AppManagerUtils.isEmptyString(stringArray[1]) || p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4]) || p3AppManagerUtils.isEmptyString(stringArray[5]) || p3AppManagerUtils.isEmptyString(stringArray[6])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.standardCalibratorType = stringArray[1];
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[2]);
                p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[3]);
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.wavelengthCalibration_Run;
                if (Integer.parseInt(stringArray[4]) != -1) {
                    p3RunConfig2.gainIndex = 2;
                    p3RunConfig2.gainValue = Integer.parseInt(stringArray[4]);
                } else {
                    p3RunConfig2.gainIndex = 0;
                    p3RunConfig2.gainValue = 0;
                }
                p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[5]);
                p3RunConfig2.resolution = Integer.parseInt(stringArray[6]);
                this.setState(p3Enumerations.p3AppManagerState.wavelengthCalibration_Run);
                break;
            }
            case RunGainAdjustSpecBG: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.INTER_SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 0;
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.gainAdjustSpecBG_Run;
                break;
            }
            case RunSelfCorr: {
                if (p3AppManagerUtils.isEmptyString(stringArray[0]) || p3AppManagerUtils.isEmptyString(stringArray[1]) || p3AppManagerUtils.isEmptyString(stringArray[2]) || p3AppManagerUtils.isEmptyString(stringArray[3]) || p3AppManagerUtils.isEmptyString(stringArray[4])) {
                    throw new p3AppManagerException("Invalid Parameters. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_PARAMETERS_ERROR.getNumVal());
                }
                p3RunConfig2 = new p3RunConfig();
                p3RunConfig2.runTime = Double.parseDouble(stringArray[0]);
                p3RunConfig2.phaseCorrection = 0;
                p3RunConfig2.normalizeSpectrum = 0;
                p3RunConfig2.WL_Correction = p3Constants.INTER_SPEC_WL_CORR;
                p3RunConfig2.selfCorrectionEnable = 1;
                p3RunConfig2.apodizationIndex = Integer.parseInt(stringArray[1]);
                p3RunConfig2.zeroPaddingMultiplier = Integer.parseInt(stringArray[2]);
                p3RunConfig2.runType = p3Enumerations.p3AppManagerState.selfCorr_Run;
                if (Integer.parseInt(stringArray[3]) != -1) {
                    p3RunConfig2.gainIndex = 2;
                    p3RunConfig2.gainValue = Integer.parseInt(stringArray[3]);
                } else {
                    p3RunConfig2.gainIndex = 0;
                    p3RunConfig2.gainValue = 0;
                }
                p3RunConfig2.commonWaveNum = Integer.parseInt(stringArray[4]);
                break;
            }
            default: {
                return null;
            }
        }
        this.ApodizationSettings(p3RunConfig2);
        this.SourceSettings(p3RunConfig2);
        this.ScanTimeChecking(p3RunConfig2);
        return p3RunConfig2;
    }

    void ScanTimeChecking(p3RunConfig p3RunConfig2) throws p3AppManagerException {
        if (p3RunConfig2.runTime < 10.0 || p3RunConfig2.runTime > p3Constants.MAX_RUNTIME_MS) {
            throw new p3AppManagerException("Invalid Scan Time. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_RUN_TIME_ERROR.getNumVal());
        }
    }

    void ApodizationSettings(p3RunConfig p3RunConfig2) throws p3AppManagerException {
        if (p3RunConfig2.apodizationIndex == 4) {
            p3RunConfig2.externalApodizationWindow = this.externalApodizationWindow;
        } else {
            this.externalApodizationWindow = null;
        }
        if (p3RunConfig2.apodizationIndex == 4 && p3RunConfig2.externalApodizationWindow == null) {
            throw new p3AppManagerException("Invalid Apodization Window. Error: ", p3Enumerations.p3AppManagerStatus.INVALID_APODIZATION_WINDOW.getNumVal());
        }
    }

    void SourceSettings(p3RunConfig p3RunConfig2) {
        double[] dArray = p3AppManagerUtils.loadParamFile(p3Constants.SOURCE_DELAY_P3_FILE_PATH);
        if (dArray != null) {
            p3RunConfig2.P3Source = true;
            p3RunConfig2.t1 = (int)dArray[0];
            p3RunConfig2.t2_c1 = (int)dArray[1];
            p3RunConfig2.t2_c2 = (int)dArray[2];
            p3RunConfig2.t2_tmax = (int)dArray[3];
            p3RunConfig2.delta_t = (int)dArray[4];
            p3RunConfig2.lamps_count = (int)dArray[5];
            p3RunConfig2.lamp_sel = (int)dArray[6];
        } else {
            dArray = p3AppManagerUtils.loadParamFile(p3Constants.SOURCE_DELAY_FILE_PATH);
            p3RunConfig2.P3Source = false;
            p3RunConfig2.sourceMode = true;
            p3RunConfig2.t1 = (int)dArray[0];
            p3RunConfig2.t2 = (int)dArray[1];
            p3RunConfig2.delta_t = (int)dArray[2];
            p3RunConfig2.lamps_count = (int)dArray[3];
            p3RunConfig2.lamp_sel = (int)dArray[4];
        }
    }

    private void setFinalResultAndnotifyObservers(p3Enumerations.p3DeviceAction p3DeviceAction2, double[][] dArray, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        this.setFinalResultByRunType(p3DeviceAction2, dArray);
        this.setState(p3Enumerations.p3AppManagerState.Idle);
        p3DeviceNotificationResult p3DeviceNotificationResult2 = this.createSampleNotificationResult(p3DeviceAction2, p3AppManagerStatus2);
        this.setChanged();
        this.notifyObservers(p3DeviceNotificationResult2);
    }

    private void setFinalResultByRunType(p3Enumerations.p3DeviceAction p3DeviceAction2, double[][] dArray) {
        switch (p3DeviceAction2) {
            case initializeCore: {
                break;
            }
            case RunInterSpec: {
                this.interSpecResult = dArray;
                break;
            }
            case RunUpdateFFT_SettingsInterSpec: {
                this.interSpecResult = dArray;
                break;
            }
            case RunUpdateFFT_SettingsSpec: {
                this.SpecResult = dArray;
                break;
            }
            case RunSpecBackground: {
                this.bgSpecResult = dArray;
                break;
            }
            case RunSpecSample: {
                this.SpecResult = dArray;
                break;
            }
            case RunWavelengthCalibrationBG: {
                this.bgWL_CalibResult = dArray;
                break;
            }
            case RunWavelengthCalibration: {
                break;
            }
            case RunGainAdjustSpecBG: 
            case RunGainAdjustSpecSample: {
                this.GainAdjustSpec_Result = dArray;
                break;
            }
            case RunSelfCorr: {
                this.interSpecResult = dArray;
                break;
            }
        }
    }

    private p3DeviceNotificationResult createSampleNotificationResult(p3Enumerations.p3DeviceAction p3DeviceAction2, p3Enumerations.p3AppManagerStatus p3AppManagerStatus2) {
        p3DeviceNotificationResult p3DeviceNotificationResult2 = new p3DeviceNotificationResult();
        p3DeviceNotificationResult2.setAction(p3DeviceAction2);
        p3DeviceNotificationResult2.setDeviceId(this.sampleId);
        p3DeviceNotificationResult2.setStatus(p3AppManagerStatus2);
        return p3DeviceNotificationResult2;
    }
}

