/*
 * Decompiled with CFR 0.152.
 */
package sws.p3AppManager_micro;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import sws.p3AppManager_micro.P3Thread;
import sws.p3AppManager_micro.PSDResponse;
import sws.p3AppManager_micro.RequestPacket;
import sws.p3AppManager_micro.configuration.p3RunConfig;
import sws.p3AppManager_micro.utils.p3AppManagerException;
import sws.p3AppManager_micro.utils.p3Enumerations;

public class P3Driver {
    private Socket readSocket;
    private Socket writeSocket = null;
    private static final String serverIP = "192.168.137.2";
    private static final int readPort = 5001;
    private static final int writePort = 5000;
    private boolean initialized = false;

    public P3Driver(int n) {
    }

    public P3Driver(int n, String string) {
    }

    public void initiateTAIF(boolean ... blArray) {
        this.initialized = true;
    }

    private byte[] receivePacket() throws Exception {
        if (this.readSocket == null) {
            this.readSocket = new Socket(serverIP, 5001);
        }
        P3Thread p3Thread = new P3Thread(){

            @Override
            public void run() {
                int n = 0;
                int n2 = 0;
                while (this.running) {
                    try {
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(P3Driver.serverIP, 5000), 1000);
                        Thread.sleep(1000L);
                        socket.close();
                        ++n;
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.getMessage() + n);
                        if (n2 == 1) {
                            this.data = new byte[1];
                            this.data[0] = 0;
                            break;
                        }
                        ++n2;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        p3Thread.start();
        P3Thread p3Thread2 = new P3Thread(){

            @Override
            public void run() {
                byte[] byArray = new byte[100000];
                byte[] byArray2 = new byte[4];
                int n = 0;
                int n2 = 0;
                try {
                    P3Driver.this.readSocket.setSoTimeout(0);
                    n2 = P3Driver.this.readSocket.getInputStream().read(byArray, n, byArray.length - n);
                    if (n2 > 0) {
                        int n3;
                        n += n2;
                        for (n3 = 0; n3 < byArray2.length; ++n3) {
                            byArray2[byArray2.length - 1 - n3] = byArray[n3];
                        }
                        n3 = ByteBuffer.wrap(byArray2).getInt();
                        while (n < n3 + 4) {
                            n2 = P3Driver.this.readSocket.getInputStream().read(byArray, n, byArray.length - n);
                            n += n2;
                        }
                        byte[] byArray3 = new byte[n - 4];
                        System.arraycopy(byArray, 4, byArray3, 0, n - 4);
                        this.data = byArray3;
                    } else {
                        this.data = new byte[0];
                    }
                }
                catch (Exception exception) {
                    this.threadException = exception;
                }
            }
        };
        p3Thread2.start();
        while (p3Thread2.getData() == null) {
            if (p3Thread.getData() != null) {
                System.out.println("connectionTest Thread not null");
                throw new Exception("Error DVK is unplugged");
            }
            if (p3Thread2.getException() == null) continue;
            System.out.println("receive Thread Exception");
            p3Thread.terminate();
            p3Thread.join();
            throw p3Thread2.getException();
        }
        p3Thread.terminate();
        p3Thread.join();
        return p3Thread2.getData();
    }

    private byte[] receivePacket(int n) throws Exception {
        byte[] byArray = new byte[100000];
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        int n3 = 0;
        if (this.readSocket == null) {
            this.readSocket = new Socket(serverIP, 5001);
        }
        this.readSocket.setSoTimeout(n);
        n3 = this.readSocket.getInputStream().read(byArray, n2, byArray.length - n2);
        if (n3 > 0) {
            int n4;
            n2 += n3;
            for (n4 = 0; n4 < byArray2.length; ++n4) {
                byArray2[byArray2.length - 1 - n4] = byArray[n4];
            }
            n4 = ByteBuffer.wrap(byArray2).getInt();
            while (n2 < n4 + 4) {
                n3 = this.readSocket.getInputStream().read(byArray, n2, byArray.length - n2);
                n2 += n3;
            }
            byte[] byArray3 = new byte[n2 - 4];
            System.arraycopy(byArray, 4, byArray3, 0, n2 - 4);
            return byArray3;
        }
        return new byte[0];
    }

    private void sendPacket(RequestPacket requestPacket) throws Exception {
        this.writeSocket.getOutputStream().write(requestPacket.getBytes());
        Thread.sleep(10L);
    }

    public int checkBoardStatus() {
        int n;
        block10: {
            n = 0;
            try {
                if (this.writeSocket == null) {
                    this.writeSocket = new Socket();
                    this.writeSocket.connect(new InetSocketAddress(serverIP, 5000), 200);
                    try {
                        byte[] byArray = this.checkBoard();
                        if (byArray[0] == 1) {
                            n = 74;
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        System.out.println("Catch 1");
                        this.writeSocket = null;
                        this.readSocket = null;
                        this.initialized = false;
                        n = 14;
                    }
                    break block10;
                }
                if (this.initialized) {
                    try {
                        byte[] byArray = this.checkBoard();
                        if (byArray[0] == 1) {
                            n = 0;
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        n = 14;
                        this.writeSocket = null;
                        this.readSocket = null;
                        this.initialized = false;
                    }
                    break block10;
                }
                n = 74;
            }
            catch (Exception exception) {
                n = 14;
                this.writeSocket = null;
                this.readSocket = null;
                this.initialized = false;
            }
        }
        return n;
    }

    public double[][] runOperation(p3RunConfig p3RunConfig2) throws Exception {
        ++p3RunConfig2.zeroPaddingMultiplier;
        p3RunConfig2.mode *= 5;
        if (!p3RunConfig2.runType.equals((Object)p3Enumerations.p3AppManagerState.BurnSettings)) {
            this.setOpticalSettings(p3RunConfig2.gainValue);
        }
        if (p3RunConfig2.P3Source) {
            this.SourceSettings(p3RunConfig2.t1, p3RunConfig2.t2_c1, p3RunConfig2.t2_c2, p3RunConfig2.t2_tmax, p3RunConfig2.delta_t, p3RunConfig2.lamps_count, p3RunConfig2.lamp_sel);
        } else {
            this.SourceSettings(p3RunConfig2.sourceMode, p3RunConfig2.t1, p3RunConfig2.t2, p3RunConfig2.delta_t, p3RunConfig2.lamps_count, p3RunConfig2.lamp_sel);
        }
        if (p3RunConfig2.apodizationIndex == 4) {
            this.injectExternalWindow(p3RunConfig2.externalApodizationWindow);
        }
        switch (p3RunConfig2.runType) {
            case InterferogramRun: {
                return this.runPSD((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum, p3RunConfig2.resolution, p3RunConfig2.mode);
            }
            case SpectroscopyBackgroundRun: {
                return this.runBackground((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum, p3RunConfig2.resolution);
            }
            case SpectroscopySampleRun: {
                return this.runAbsorbance((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum, p3RunConfig2.resolution, p3RunConfig2.mode);
            }
            case gainAdjustSpecBG_Run: {
                return this.runGainAdjusment();
            }
            case BurnSettings: {
                return this.runBurnSettings(p3RunConfig2.burnMode);
            }
            case selfCorr_Run: {
                return this.runSelfCorr((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum);
            }
            case wavelengthCalibrationBG_Run: {
                return this.runWavelengthCorrBG((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum, p3RunConfig2.resolution);
            }
            case wavelengthCalibration_Run: {
                return this.runWavelengthCorr((int)p3RunConfig2.runTime, p3RunConfig2.apodizationIndex, p3RunConfig2.zeroPaddingMultiplier, p3RunConfig2.gainIndex, p3RunConfig2.commonWaveNum, p3RunConfig2.resolution, p3RunConfig2.CalibrationWells);
            }
            case RestoreDefault: {
                return this.runRestoreDefault();
            }
            case SleepAction: {
                return this.sleepAction();
            }
            case WakeUpAction: {
                return this.wakeUpAction();
            }
            case PowerOff: {
                return this.powerOff();
            }
            case PowerOn: {
                return this.powerOn();
            }
        }
        return null;
    }

    private void injectExternalWindow(long[] lArray) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 28;
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.mode = 0;
        requestPacket.opticalGain = 0;
        for (int i = 0; i < lArray.length; ++i) {
            requestPacket.calibrationWells[2 * i] = (int)(lArray[i] & 0xFFFFFFFFFFFFFFFFL);
            requestPacket.calibrationWells[2 * i + 1] = (int)(lArray[i] >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        }
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
    }

    private double[][] runPSD(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws p3AppManagerException {
        PSDResponse pSDResponse;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 3;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = n6;
        requestPacket.mode = n7;
        requestPacket.opticalGain = n4;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            pSDResponse = new PSDResponse(this.receivePacket());
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (pSDResponse.status != 0) {
            throw new p3AppManagerException("DVK error. ", pSDResponse.status + 200);
        }
        double[][] dArrayArray = new double[][]{new double[pSDResponse.length], new double[pSDResponse.length], new double[pSDResponse.length], new double[pSDResponse.length], new double[1]};
        for (int i = 0; i < pSDResponse.length; ++i) {
            dArrayArray[0][i] = (double)pSDResponse.WVN_WVL[i] / Math.pow(2.0, 30.0);
            dArrayArray[1][i] = (double)pSDResponse.PSD[i] / Math.pow(2.0, 33.0);
            dArrayArray[2][i] = (double)pSDResponse.WVN_WVL[i] / Math.pow(2.0, 30.0);
            dArrayArray[3][i] = (double)pSDResponse.PSD[i] / Math.pow(2.0, 33.0);
        }
        dArrayArray[4][0] = pSDResponse.length;
        return dArrayArray;
    }

    private double[][] runBackground(int n, int n2, int n3, int n4, int n5, int n6) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 4;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = n6;
        requestPacket.mode = 0;
        requestPacket.opticalGain = n4;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] runAbsorbance(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws p3AppManagerException {
        PSDResponse pSDResponse;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 5;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = n6;
        requestPacket.mode = n7;
        requestPacket.opticalGain = n4;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            pSDResponse = new PSDResponse(this.receivePacket());
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (pSDResponse.status != 0) {
            throw new p3AppManagerException("DVK error. ", pSDResponse.status + 200);
        }
        double[][] dArrayArray = new double[][]{new double[pSDResponse.length], new double[pSDResponse.length], new double[pSDResponse.length], new double[pSDResponse.length], new double[1]};
        for (int i = 0; i < pSDResponse.length; ++i) {
            dArrayArray[0][i] = (double)pSDResponse.WVN_WVL[i] / Math.pow(2.0, 30.0);
            dArrayArray[1][i] = (double)pSDResponse.PSD[i] / Math.pow(2.0, 33.0);
            dArrayArray[2][i] = (double)pSDResponse.WVN_WVL[i] / Math.pow(2.0, 30.0);
            dArrayArray[3][i] = (double)pSDResponse.PSD[i] / Math.pow(2.0, 33.0);
        }
        dArrayArray[4][0] = pSDResponse.length;
        return dArrayArray;
    }

    private double[][] runGainAdjusment() throws p3AppManagerException {
        int n;
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 6;
        byte[] byArray2 = new byte[2];
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.mode = 0;
        requestPacket.opticalGain = 0;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[byArray2.length - 1 - n] = byArray[n + 1];
        }
        n = ByteBuffer.wrap(byArray2).getShort();
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = n;
        return dArrayArray;
    }

    private double[][] runBurnSettings(int n) throws p3AppManagerException {
        double[][] dArrayArray = new double[1][];
        if (n == 3) {
            for (n = 0; n < 3; ++n) {
                byte[] byArray;
                RequestPacket requestPacket = new RequestPacket();
                requestPacket.operation = 7 + n;
                requestPacket.scanTime = 0;
                requestPacket.apodizationSel = 0;
                requestPacket.zeroPadding = 0;
                requestPacket.commonWaveNum = 0;
                requestPacket.resolution = 0;
                requestPacket.mode = 0;
                requestPacket.opticalGain = 0;
                try {
                    this.sendPacket(requestPacket);
                }
                catch (Exception exception) {
                    throw new p3AppManagerException("Communication error. ", 400);
                }
                try {
                    byArray = this.receivePacket();
                }
                catch (Exception exception) {
                    throw new p3AppManagerException("Communication error. ", 400);
                }
                if (byArray[0] != 0) {
                    throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
                }
                dArrayArray[0] = new double[1];
                dArrayArray[0][0] = byArray[0];
            }
        } else {
            byte[] byArray;
            RequestPacket requestPacket = new RequestPacket();
            requestPacket.operation = 7 + n;
            requestPacket.scanTime = 0;
            requestPacket.apodizationSel = 0;
            requestPacket.zeroPadding = 0;
            requestPacket.commonWaveNum = 0;
            requestPacket.resolution = 0;
            requestPacket.mode = 0;
            requestPacket.opticalGain = 0;
            try {
                this.sendPacket(requestPacket);
            }
            catch (Exception exception) {
                throw new p3AppManagerException("Communication error. ", 400);
            }
            try {
                byArray = this.receivePacket();
            }
            catch (Exception exception) {
                throw new p3AppManagerException("Communication error. ", 400);
            }
            if (byArray[0] != 0) {
                throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
            }
            dArrayArray[0] = new double[1];
            dArrayArray[0][0] = byArray[0];
        }
        return dArrayArray;
    }

    private double[][] runSelfCorr(int n, int n2, int n3, int n4, int n5) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 10;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = 0;
        requestPacket.mode = 0;
        requestPacket.opticalGain = n4;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] runWavelengthCorrBG(int n, int n2, int n3, int n4, int n5, int n6) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 11;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = n6;
        requestPacket.mode = 0;
        requestPacket.opticalGain = n4;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] runWavelengthCorr(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 12;
        requestPacket.scanTime = n;
        requestPacket.apodizationSel = n2;
        requestPacket.zeroPadding = n3;
        requestPacket.commonWaveNum = n5;
        requestPacket.resolution = n6;
        requestPacket.mode = 0;
        requestPacket.opticalGain = n4;
        for (int i = 0; i < (requestPacket.calibrationWells.length > nArray.length ? nArray.length : requestPacket.calibrationWells.length); ++i) {
            requestPacket.calibrationWells[i] = nArray[i];
        }
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] runRestoreDefault() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 13;
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.mode = 0;
        requestPacket.opticalGain = 0;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] sleepAction() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 15;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] wakeUpAction() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 16;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] powerOff() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 17;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private double[][] powerOn() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 18;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
        double[][] dArrayArray = new double[][]{new double[1]};
        dArrayArray[0][0] = byArray[0];
        return dArrayArray;
    }

    private void setOpticalSettings(int n) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 27;
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.mode = 0;
        requestPacket.opticalGain = 0;
        requestPacket.calibrationWells[0] = n;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
    }

    private void SourceSettings(boolean bl, int n, int n2, int n3, int n4, int n5) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 22;
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.opticalGain = 0;
        requestPacket.calibrationWells[0] = n5 * 256 + n4;
        requestPacket.calibrationWells[1] = n3 * 65536 + n2 * 256 + n;
        requestPacket.calibrationWells[1] = bl ? requestPacket.calibrationWells[1] + 0x1000000 : requestPacket.calibrationWells[1] + 0;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("DVK error. ", byArray[0] + 200);
        }
    }

    private void SourceSettings(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 22;
        requestPacket.scanTime = 0;
        requestPacket.apodizationSel = 0;
        requestPacket.zeroPadding = 0;
        requestPacket.commonWaveNum = 0;
        requestPacket.resolution = 0;
        requestPacket.opticalGain = 0;
        requestPacket.calibrationWells[0] = n7 * 256 + n6;
        requestPacket.calibrationWells[1] = n5 * 256 + n;
        requestPacket.calibrationWells[2] = n4 * 65536 + n3 * 256 + n2;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket();
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        if (byArray[0] != 0) {
            throw new p3AppManagerException("EVK error. ", byArray[0] + 200);
        }
    }

    private byte[] checkBoard() throws p3AppManagerException {
        byte[] byArray;
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 2;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        try {
            byArray = this.receivePacket(1000);
        }
        catch (Exception exception) {
            throw new p3AppManagerException("Communication error. ", 400);
        }
        return byArray;
    }

    public String readROMID() throws Exception {
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 1;
        this.sendPacket(requestPacket);
        byte[] byArray = this.receivePacket();
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new String(byArray2);
    }

    public String[] readSWVersion() {
        String[] stringArray = new String[2];
        RequestPacket requestPacket = new RequestPacket();
        requestPacket.operation = 14;
        try {
            this.sendPacket(requestPacket);
        }
        catch (Exception exception) {
            stringArray[0] = "0.1";
            stringArray[1] = "0.1";
            return stringArray;
        }
        try {
            byte[] byArray = this.receivePacket();
            byte[] byArray2 = new byte[8];
            for (int i = 0; i < 4; ++i) {
                byArray2[byArray2.length - 1 - i] = byArray[i];
            }
            String string = new Long(ByteBuffer.wrap(byArray2).getLong()).toString();
            for (int i = 4; i < 8; ++i) {
                byArray2[byArray2.length - 1 - i + 4] = byArray[i];
            }
            String string2 = new Long(ByteBuffer.wrap(byArray2).getLong()).toString();
            stringArray[0] = string.substring(0, 6) + "." + string.substring(6, 10);
            stringArray[1] = string2.substring(0, 6) + "." + string2.substring(6, 10);
            return stringArray;
        }
        catch (Exception exception) {
            stringArray[0] = "0.2";
            stringArray[1] = "0.2";
            return stringArray;
        }
    }
}

